/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.dnssec4j;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import org.littleshoot.dnssec4j.DNSSECException;
import org.littleshoot.dnssec4j.DnsSec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifiedAddressFactory {
    private static final Logger LOG = LoggerFactory.getLogger(VerifiedAddressFactory.class);

    public static InetSocketAddress newInetSocketAddress(String host, int port) throws UnknownHostException {
        return VerifiedAddressFactory.newInetSocketAddress(host, port, true);
    }

    public static InetSocketAddress newInetSocketAddress(String host, int port, boolean useDnsSec) throws UnknownHostException {
        return new InetSocketAddress(VerifiedAddressFactory.newVerifiedInetAddress(host, useDnsSec), port);
    }

    public static InetAddress newVerifiedInetAddress(String host, boolean useDnsSec) throws UnknownHostException {
        if (useDnsSec) {
            try {
                return DnsSec.getByName(host);
            }
            catch (IOException e) {
                LOG.info("Could not resolve address for: " + host, (Throwable)e);
            }
            catch (DNSSECException e) {
                LOG.warn("DNSSEC error. Bad signature?", (Throwable)e);
                throw new Error("DNSSEC error. Bad signature?", e);
            }
        }
        return InetAddress.getByName(host);
    }
}

