/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.http.client;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.StatusLine;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.lastbamboo.common.http.client.ServiceUnavailableException;
import org.littleshoot.util.DefaultHttpClient;
import org.littleshoot.util.DefaultHttpClientImpl;
import org.littleshoot.util.Pair;
import org.littleshoot.util.UriUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseHttpClientRequester {
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private final DefaultHttpClient m_httpClient = new DefaultHttpClientImpl();

    public String post(String baseUrl, Collection<Pair<String, String>> parameters) throws IOException, ServiceUnavailableException {
        String url = UriUtils.newUrl((String)baseUrl, parameters);
        PostMethod method = new PostMethod(url);
        return this.request((HttpMethod)method);
    }

    public String post(String baseUrl, Map<String, String> parameters) throws IOException, ServiceUnavailableException {
        String url = UriUtils.newUrl((String)baseUrl, parameters);
        PostMethod method = new PostMethod(url);
        return this.request((HttpMethod)method);
    }

    public String get(String baseUrl, Collection<Pair<String, String>> parameters) throws IOException, ServiceUnavailableException {
        String url = UriUtils.newUrl((String)baseUrl, parameters);
        GetMethod method = new GetMethod(url);
        return this.request((HttpMethod)method);
    }

    public String get(String baseUrl, Map<String, String> parameters) throws IOException, ServiceUnavailableException {
        String url = UriUtils.newUrl((String)baseUrl, parameters);
        GetMethod method = new GetMethod(url);
        return this.request((HttpMethod)method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String request(HttpMethod method) throws IOException, ServiceUnavailableException {
        String string;
        method.setRequestHeader("Accept-Encoding", "gzip");
        InputStream is = null;
        try {
            this.m_httpClient.executeMethod(method);
            int statusCode = method.getStatusCode();
            StatusLine statusLine = method.getStatusLine();
            Header encoding = method.getResponseHeader("Content-Encoding");
            if (encoding != null && encoding.getValue().equals("gzip")) {
                this.LOG.debug("Unzipping body...");
                is = new GZIPInputStream(method.getResponseBodyAsStream());
            } else {
                is = method.getResponseBodyAsStream();
            }
            String body = IOUtils.toString((InputStream)is);
            if (StringUtils.isBlank((String)body)) {
                this.LOG.debug("No response body.  Post request?");
            }
            if (statusCode == 503) {
                String msg = "Got 503 Service Unavailable " + method.getURI() + "\n" + statusLine + "\n" + body;
                this.LOG.warn(msg);
                throw new ServiceUnavailableException(msg);
            }
            if (statusCode != 200) {
                String msg = "NO 200 OK: " + method.getURI() + "\n" + statusLine + "\n" + body;
                this.LOG.warn(msg);
                this.writeToFile(body);
                throw new IOException(msg);
            }
            this.LOG.debug("Got 200 response...");
            string = body;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            method.releaseConnection();
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        method.releaseConnection();
        return string;
    }

    private void writeToFile(String body) {
        File out = new File(this.getClass().getSimpleName() + "-Error.html");
        if (out.exists()) {
            out.delete();
        }
        StringReader is = new StringReader(body);
        try {
            IOUtils.copy((Reader)is, (OutputStream)new FileOutputStream(out));
        }
        catch (FileNotFoundException e) {
            this.LOG.debug("FNF", (Throwable)e);
        }
        catch (IOException e) {
            this.LOG.debug("IO", (Throwable)e);
        }
    }
}

