/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.http.client;

import java.io.IOException;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.lastbamboo.common.http.client.CommonsHttpClient;
import org.lastbamboo.common.http.client.RuntimeHttpException;
import org.littleshoot.util.DefaultHttpClient;
import org.littleshoot.util.DefaultHttpClientImpl;
import org.littleshoot.util.RuntimeIoException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CommonsHttpClientImpl
implements CommonsHttpClient {
    private final Logger m_log = LoggerFactory.getLogger(this.getClass());
    private final DefaultHttpClient m_commonsClient;

    public CommonsHttpClientImpl() {
        this.m_commonsClient = new DefaultHttpClientImpl();
    }

    public CommonsHttpClientImpl(HttpConnectionManager connectionManager) {
        this.m_commonsClient = new DefaultHttpClientImpl(connectionManager);
    }

    @Override
    public int executeMethod(HttpMethod method) {
        try {
            return this.m_commonsClient.executeMethod(method);
        }
        catch (HttpException e) {
            this.m_log.debug("HttpException executing method", (Throwable)e);
            throw new RuntimeHttpException("Exception executing method", e);
        }
        catch (IOException e) {
            this.m_log.debug("IOException executing method", (Throwable)e);
            throw new RuntimeIoException("Exception executing method", (Exception)e);
        }
    }

    @Override
    public HttpClientParams getParams() {
        return this.m_commonsClient.getParams();
    }

    @Override
    public HttpConnectionManager getHttpConnectionManager() {
        return this.m_commonsClient.getHttpConnectionManager();
    }
}

