/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.http.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.util.zip.GZIPInputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.LongRange;
import org.lastbamboo.common.http.client.CommonsHttpClient;
import org.lastbamboo.common.http.client.HttpListener;
import org.lastbamboo.common.http.client.NoContentRangeException;
import org.littleshoot.util.InputStreamHandler;
import org.littleshoot.util.RuntimeIoException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpClientRunner
implements Runnable {
    private final Logger m_log = LoggerFactory.getLogger(HttpClientRunner.class);
    private final InputStreamHandler m_inputStreamHandler;
    private final HttpListener m_listener;
    private final CommonsHttpClient m_httpClient;
    private final HttpMethod m_httpMethod;

    public HttpClientRunner(InputStreamHandler handler, CommonsHttpClient client, HttpMethod method, HttpListener listener) {
        this.m_inputStreamHandler = handler;
        this.m_httpClient = client;
        this.m_httpMethod = method;
        this.m_listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.handleDownload();
        }
        catch (RuntimeIoException e) {
            this.m_log.debug("Could not connect to host or connection lost?", (Throwable)e);
            this.m_listener.onFailure();
        }
        catch (Throwable t) {
            this.m_log.error("Unexpected exception", t);
            this.m_listener.onFailure();
        }
        finally {
            try {
                this.m_log.debug("Releasing HTTP connection...");
                this.m_httpMethod.releaseConnection();
            }
            catch (RuntimeException e) {
                this.m_log.warn("Exception releasing connection", (Throwable)e);
            }
            this.m_log.trace("Released connection...");
        }
    }

    private void handleDownload() {
        this.m_listener.onStatusEvent("Connecting...");
        this.m_listener.onDownloadStarted();
        try {
            this.executeHttpRequest();
        }
        catch (HttpException e) {
            this.m_log.warn("HTTP exception downloading, method: " + this.m_httpMethod.getPath() + " " + e.getReason(), (Throwable)e);
            int reasonCode = e.getReasonCode();
            String status = reasonCode >= 100 && reasonCode < 600 ? "Could Not Access User" : "Unknown response";
            this.m_listener.onStatusEvent(status);
            this.m_listener.onHttpException(e);
        }
        catch (SocketTimeoutException e) {
            this.warn("Socket timeout: ", e);
            this.m_listener.onFailure();
        }
        catch (IOException e) {
            this.m_log.debug("Connection or copying error", (Throwable)e);
            this.m_listener.onFailure();
        }
    }

    private void warn(String msg, Throwable t) {
        try {
            this.m_log.warn(msg + this.m_httpMethod.getURI(), t);
        }
        catch (URIException uRIException) {
            // empty catch block
        }
    }

    private void executeHttpRequest() throws IOException {
        this.m_log.trace("Sending HTTP GET request for: {}", (Object)this.m_httpMethod.getQueryString());
        long start = System.currentTimeMillis();
        this.m_httpClient.executeMethod(this.m_httpMethod);
        long connected = System.currentTimeMillis();
        this.m_log.trace("Received status code: " + this.m_httpMethod.getStatusCode());
        this.m_listener.onConnect(connected - start);
        int statusCode = this.m_httpMethod.getStatusCode();
        if (statusCode == 200) {
            this.onTwoHundredResponse();
        } else if (statusCode == 206) {
            this.onPartialContent();
        } else {
            this.onNonTwoHundredLevelResponse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onNonTwoHundredLevelResponse() throws IOException {
        InputStream inputStream = this.m_httpMethod.getResponseBodyAsStream();
        try {
            IOUtils.copy((InputStream)inputStream, (OutputStream)new NullOutputStream());
            this.m_log.warn("Did not receive 200 OK response for request to URI: " + this.m_httpMethod.getURI() + "\n" + "\nRequest headers:\n" + HttpClientRunner.headerString(this.m_httpMethod.getRequestHeaders()) + "\nResponse:\n" + this.m_httpMethod.getStatusLine() + "\n" + HttpClientRunner.headerString(this.m_httpMethod.getResponseHeaders()));
        }
        catch (URIException e) {
            this.m_log.error("Could not resolve URI", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
            this.m_listener.onNoTwoHundredOk(this.m_httpMethod.getStatusCode());
        }
    }

    private static String headerString(Header[] headers) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < headers.length; ++i) {
            sb.append(headers[i].getName());
            sb.append(": ");
            sb.append(headers[i].getValue());
            sb.append("\n");
        }
        return sb.toString();
    }

    private void onPartialContent() throws IOException {
        Header rangeHeader = this.m_httpMethod.getResponseHeader("Content-Range");
        this.m_log.debug("Received range header: {}", (Object)rangeHeader);
        if (rangeHeader == null) {
            this.m_log.warn("No range header!!");
            throw new IOException("Received Partial Content response with no Content-Range header");
        }
        this.notifyRange(rangeHeader);
        this.onTwoHundredResponse();
    }

    private void onTwoHundredResponse() throws IOException {
        Header rangeHeader;
        Header length = this.m_httpMethod.getResponseHeader("Content-Length");
        if (length != null) {
            this.m_listener.onContentLength(Long.parseLong(length.getValue()));
        }
        if ((rangeHeader = this.m_httpMethod.getResponseHeader("Content-Range")) != null) {
            this.notifyRange(rangeHeader);
        }
        Header contentEncoding = this.m_httpMethod.getResponseHeader("Content-Encoding");
        InputStream inputStream = this.m_httpMethod.getResponseBodyAsStream();
        this.m_log.debug("Got input stream...sending to: {}", (Object)this.m_inputStreamHandler);
        if (contentEncoding == null) {
            this.handleInputStream(inputStream);
        } else if (StringUtils.contains((String)contentEncoding.getValue(), (String)"gzip")) {
            this.m_log.trace("Handling gzipped message body...");
            this.handleInputStream(new GZIPInputStream(inputStream));
        } else {
            this.m_log.warn("Unrecognized content encoding: {}", (Object)contentEncoding);
        }
    }

    private void handleInputStream(InputStream inputStream) throws IOException {
        try {
            this.m_inputStreamHandler.handleInputStream(inputStream);
            this.m_listener.onMessageBodyRead();
        }
        catch (NoContentRangeException e) {
            this.m_listener.onPermanentFailure();
        }
    }

    private void notifyRange(Header rangeHeader) throws IOException {
        String rangeString = rangeHeader.getValue().trim();
        if (!rangeString.startsWith("bytes")) {
            this.m_log.warn("Bad header!!  {}", (Object)rangeHeader);
            this.m_listener.onBadHeader(rangeHeader.toString());
            throw new IOException("Could not read header: " + rangeHeader);
        }
        rangeString = StringUtils.substringBetween((String)rangeString, (String)"bytes", (String)"/").trim();
        String minString = StringUtils.substringBefore((String)rangeString, (String)"-").trim();
        String maxString = StringUtils.substringAfter((String)rangeString, (String)"-").trim();
        long min = Long.parseLong(minString);
        long max = Long.parseLong(maxString);
        LongRange range = new LongRange(min, max);
        this.m_listener.onContentRange(range);
    }
}

