/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.jni;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.lastbamboo.common.portmapping.NatPmpService;
import org.lastbamboo.common.portmapping.PortMapListener;
import org.lastbamboo.common.portmapping.PortMappingProtocol;
import org.lastbamboo.common.portmapping.UpnpService;
import org.littleshoot.util.CommonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JLibTorrent
implements NatPmpService,
UpnpService {
    private final Logger m_log = LoggerFactory.getLogger(this.getClass());
    private long m_totalUploadBytes;
    private long m_totalDownloadBytes;
    private long m_totalPayloadUploadBytes;
    private long m_totalPayloadDownloadBytes;
    private int m_uploadRate;
    private int m_downloadRate;
    private int m_payloadUploadRate;
    private int m_payloadDownloadRate;
    private int m_numPeers;
    private final boolean m_isPro;
    private final File m_dataDir = CommonUtils.getLittleShootDir();
    private boolean m_libLoaded;
    private final Map<Integer, PortMapListener> m_upnpMappingIdsToListeners = Collections.synchronizedMap(new LinkedHashMap<Integer, PortMapListener>(){
        private static final long serialVersionUID = 6999097893740294302L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<Integer, PortMapListener> eldest) {
            boolean remove = this.size() > 200;
            return remove;
        }
    });
    private final Map<Integer, PortMapListener> m_natPmpMappingIdsToListeners = Collections.synchronizedMap(new LinkedHashMap<Integer, PortMapListener>(){
        private static final long serialVersionUID = 8582401885547276580L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<Integer, PortMapListener> eldest) {
            boolean remove = this.size() > 200;
            return remove;
        }
    });
    private volatile boolean m_stopped;

    public JLibTorrent(Collection<File> libFiles, boolean isPro) {
        this.m_isPro = isPro;
        this.m_libLoaded = false;
        try {
            for (File lib : libFiles) {
                if (!lib.isFile()) continue;
                this.m_log.info("Loading: " + lib);
                System.load(lib.getAbsolutePath());
                this.m_libLoaded = true;
                this.m_log.info("Loaded: " + lib);
                break;
            }
            if (!this.m_libLoaded) {
                System.loadLibrary("jnltorrent");
                this.m_libLoaded = true;
            }
            this.init();
        }
        catch (Throwable t) {
            this.m_log.warn("Could not load LibTorrent library!", t);
            this.m_libLoaded = false;
        }
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                Set upnpIndeces = JLibTorrent.this.m_upnpMappingIdsToListeners.keySet();
                Iterator i$ = upnpIndeces.iterator();
                while (i$.hasNext()) {
                    int index = (Integer)i$.next();
                    System.out.println("Removing UPnP mapping at index: " + index);
                    JLibTorrent.this.removeUpnpMapping(index);
                }
                Set natPmpIndeces = JLibTorrent.this.m_natPmpMappingIdsToListeners.keySet();
                Iterator i$2 = natPmpIndeces.iterator();
                while (i$2.hasNext()) {
                    int index = (Integer)i$2.next();
                    System.out.println("Removing NAT-PMP mapping at index: " + index);
                    JLibTorrent.this.removeNatPmpMapping(index);
                }
            }
        };
        Thread shutdown = new Thread(runner, "Remove-UPNP-NATPMP-Mappings");
        Runtime.getRuntime().addShutdownHook(shutdown);
    }

    public JLibTorrent(boolean isPro) {
        this.m_isPro = isPro;
        System.loadLibrary("jnltorrent");
        this.init();
    }

    public JLibTorrent(String libraryPath, boolean isPro) {
        this.m_isPro = isPro;
        System.load(libraryPath);
        this.init();
    }

    private void init() {
        this.cacheMethodIds();
        this.start(this.m_isPro, this.normalizePath(this.m_dataDir));
        this.checkAlerts();
    }

    public void stopLibTorrent() {
        if (!this.m_libLoaded || this.m_stopped) {
            return;
        }
        this.m_stopped = true;
        this.stop();
    }

    public void updateSessionStatus() {
        if (!this.m_libLoaded || this.m_stopped) {
            return;
        }
        this.update_session_status();
    }

    public void download(File incompleteDir, File torrentFile, boolean sequential, int torrentState) throws IOException {
        if (!this.m_libLoaded || this.m_stopped) {
            return;
        }
        this.add_torrent(incompleteDir.getCanonicalPath(), torrentFile.getCanonicalPath(), (int)torrentFile.length(), sequential, torrentState);
    }

    public void rename(File torrentFile, String newName) {
        if (!this.m_libLoaded || this.m_stopped) {
            return;
        }
        String path = this.normalizePath(torrentFile);
        this.rename(path, newName);
    }

    public void moveToDownloadsDir(File torrentFile, File downloadsDir) {
        if (!this.m_libLoaded || this.m_stopped) {
            return;
        }
        String path = this.normalizePath(torrentFile);
        String downloadsDirPath = this.normalizePath(downloadsDir);
        this.move_to_downloads_dir(path, downloadsDirPath);
    }

    public long getMaxByteForTorrent(File torrentFile) {
        if (!this.m_libLoaded || this.m_stopped) {
            return -1L;
        }
        String path = this.normalizePath(torrentFile);
        return this.get_max_byte_for_torrent(path);
    }

    public void pauseTorrent(File torrentFile) {
        if (!this.m_libLoaded || this.m_stopped) {
            return;
        }
        String path = this.normalizePath(torrentFile);
        this.pause_torrent(path);
    }

    public void resumeTorrent(File torrentFile) {
        if (!this.m_libLoaded || this.m_stopped) {
            return;
        }
        String path = this.normalizePath(torrentFile);
        this.resume_torrent(path);
    }

    public void hardResumeTorrent(File torrentFile) {
        if (!this.m_libLoaded || this.m_stopped) {
            return;
        }
        this.m_log.info("Performing hard resume");
        String path = this.normalizePath(torrentFile);
        this.hard_resume_torrent(path);
    }

    public long getSizeForTorrent(File torrentFile) {
        if (!this.m_libLoaded || this.m_stopped) {
            return 0L;
        }
        String path = this.normalizePath(torrentFile);
        return this.get_size_for_torrent(path);
    }

    public void removeTorrent(File torrentFile) {
        if (!this.m_libLoaded || this.m_stopped) {
            return;
        }
        String path = this.normalizePath(torrentFile);
        this.remove_torrent(path);
    }

    public void removeTorrentAndFiles(File torrentFile) {
        if (!this.m_libLoaded || this.m_stopped) {
            return;
        }
        String path = this.normalizePath(torrentFile);
        this.remove_torrent_and_files(path);
    }

    public int getStateForTorrent(File torrentFile) {
        if (!this.m_libLoaded || this.m_stopped) {
            return -1;
        }
        String path = this.normalizePath(torrentFile);
        return this.get_state_for_torrent(path);
    }

    public String getName(File torrentFile) {
        if (!this.m_libLoaded || this.m_stopped) {
            return torrentFile.getName();
        }
        String path = this.normalizePath(torrentFile);
        return this.get_name_for_torrent(path);
    }

    public int getNumFiles(File torrentFile) {
        if (!this.m_libLoaded || this.m_stopped) {
            return 0;
        }
        String path = this.normalizePath(torrentFile);
        return this.get_num_files_for_torrent(path);
    }

    public int getDownloadSpeed(File torrentFile) {
        if (!this.m_libLoaded || this.m_stopped) {
            return 0;
        }
        String path = this.normalizePath(torrentFile);
        return this.get_speed_for_torrent(path);
    }

    public int getNumHosts(File torrentFile) {
        if (!this.m_libLoaded || this.m_stopped) {
            return 0;
        }
        String path = this.normalizePath(torrentFile);
        return this.get_num_peers_for_torrent(path);
    }

    public long getBytesRead(File torrentFile) {
        if (!this.m_libLoaded || this.m_stopped) {
            return 0L;
        }
        String path = this.normalizePath(torrentFile);
        return this.get_bytes_read_for_torrent(path);
    }

    public void setMaxUploadSpeed(int bytesPerSecond) {
        if (!this.m_libLoaded || this.m_stopped) {
            return;
        }
        this.set_max_upload_speed(bytesPerSecond);
    }

    public int addUpnpMapping(PortMappingProtocol protocol, int internalPort, int externalPort, PortMapListener portMapListener) {
        int mappingId;
        if (!this.m_libLoaded || this.m_stopped) {
            return -1;
        }
        switch (protocol) {
            case TCP: {
                mappingId = this.add_tcp_upnp_mapping(internalPort, externalPort);
                break;
            }
            case UDP: {
                mappingId = this.add_udp_upnp_mapping(internalPort, externalPort);
                break;
            }
            default: {
                this.m_log.error("Bad protocol");
                throw new IllegalArgumentException("Bad protocol");
            }
        }
        this.m_log.info("Adding port mapping ID " + mappingId + " for port " + externalPort + " and hashCode " + this.hashCode());
        if (mappingId == -1) {
            portMapListener.onPortMapError();
        } else {
            this.m_upnpMappingIdsToListeners.put(mappingId, portMapListener);
        }
        return mappingId;
    }

    public int addNatPmpMapping(PortMappingProtocol protocol, int internalPort, int externalPort, PortMapListener portMapListener) {
        int mappingId;
        if (!this.m_libLoaded || this.m_stopped) {
            return -1;
        }
        switch (protocol) {
            case TCP: {
                mappingId = this.add_tcp_natpmp_mapping(internalPort, externalPort);
                break;
            }
            case UDP: {
                mappingId = this.add_udp_natpmp_mapping(internalPort, externalPort);
                break;
            }
            default: {
                this.m_log.error("Bad protocol");
                throw new IllegalArgumentException("Bad protocol");
            }
        }
        this.m_log.info("Adding port mapping ID: {}", (Object)mappingId);
        if (mappingId == -1) {
            portMapListener.onPortMapError();
        } else {
            this.m_natPmpMappingIdsToListeners.put(mappingId, portMapListener);
        }
        return mappingId;
    }

    public void removeUpnpMapping(int mappingIndex) {
        this.delete_upnp_mapping(mappingIndex);
    }

    public void removeNatPmpMapping(int mappingIndex) {
        this.delete_natpmp_mapping(mappingIndex);
    }

    public void checkAlerts() {
        if (!this.m_libLoaded || this.m_stopped) {
            return;
        }
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                while (!JLibTorrent.this.m_stopped) {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        JLibTorrent.this.m_log.error("Interrupted?", (Throwable)e);
                    }
                    JLibTorrent.this.check_alerts();
                }
            }
        };
        Thread t = new Thread(runner);
        t.setDaemon(true);
        t.start();
    }

    private final String normalizePath(File torrentFile) {
        try {
            return torrentFile.getCanonicalPath();
        }
        catch (IOException e) {
            return torrentFile.getAbsolutePath();
        }
    }

    private native void set_max_upload_speed(int var1);

    private native int add_tcp_upnp_mapping(int var1, int var2);

    private native int add_udp_upnp_mapping(int var1, int var2);

    private native int add_tcp_natpmp_mapping(int var1, int var2);

    private native int add_udp_natpmp_mapping(int var1, int var2);

    private native void delete_natpmp_mapping(int var1);

    private native void delete_upnp_mapping(int var1);

    private native void check_alerts();

    private native void cacheMethodIds();

    private native void update_session_status();

    private native void move_to_downloads_dir(String var1, String var2);

    private native void rename(String var1, String var2);

    private native long get_bytes_read_for_torrent(String var1);

    private native int get_num_peers_for_torrent(String var1);

    private native int get_speed_for_torrent(String var1);

    private native int get_num_files_for_torrent(String var1);

    private native int get_state_for_torrent(String var1);

    private native long get_size_for_torrent(String var1);

    private native String get_name_for_torrent(String var1);

    private native void remove_torrent(String var1);

    private native void remove_torrent_and_files(String var1);

    private native void pause_torrent(String var1);

    private native void resume_torrent(String var1);

    private native void hard_resume_torrent(String var1);

    private native long get_max_byte_for_torrent(String var1);

    private native void start(boolean var1, String var2);

    private native void stop();

    private native long add_torrent(String var1, String var2, int var3, boolean var4, int var5);

    public void setTotalUploadBytes(long totalUploadBytes) {
        this.m_totalUploadBytes = totalUploadBytes;
    }

    public long getTotalUploadBytes() {
        return this.m_totalUploadBytes;
    }

    public void setTotalDownloadBytes(long totalDownloadBytes) {
        this.m_totalDownloadBytes = totalDownloadBytes;
    }

    public long getTotalDownloadBytes() {
        return this.m_totalDownloadBytes;
    }

    public void setDownloadRate(int downloadRate) {
        this.m_downloadRate = downloadRate;
    }

    public int getDownloadRate() {
        return this.m_downloadRate;
    }

    public void setUploadRate(int uploadRate) {
        this.m_uploadRate = uploadRate;
    }

    public int getUploadRate() {
        return this.m_uploadRate;
    }

    public void setNumPeers(int numPeers) {
        this.m_numPeers = numPeers;
    }

    public int getNumPeers() {
        return this.m_numPeers;
    }

    public void setPayloadUploadRate(int payloadUploadRate) {
        this.m_payloadUploadRate = payloadUploadRate;
    }

    public int getPayloadUploadRate() {
        return this.m_payloadUploadRate;
    }

    public void setPayloadDownloadRate(int payloadDownloadRate) {
        this.m_payloadDownloadRate = payloadDownloadRate;
    }

    public int getPayloadDownloadRate() {
        return this.m_payloadDownloadRate;
    }

    public void setTotalPayloadUploadBytes(long totalPayloadUploadBytes) {
        this.m_totalPayloadUploadBytes = totalPayloadUploadBytes;
    }

    public long getTotalPayloadUploadBytes() {
        return this.m_totalPayloadUploadBytes;
    }

    public void setTotalPayloadDownloadBytes(long totalPayloadDownloadBytes) {
        this.m_totalPayloadDownloadBytes = totalPayloadDownloadBytes;
    }

    public long getTotalPayloadDownloadBytes() {
        return this.m_totalPayloadDownloadBytes;
    }

    public void portMapAlert(int mappingId, int externalPort, int type) {
        PortMapListener listener;
        this.m_log.info("GOT PORT MAPPED!! ID: " + mappingId + " EXTERNAL PORT: " + externalPort);
        if (type == 0) {
            this.m_log.info("Alert from NAT-PMP");
            listener = this.m_natPmpMappingIdsToListeners.get(mappingId);
        } else {
            this.m_log.info("Alert from UPnP");
            listener = this.m_upnpMappingIdsToListeners.get(mappingId);
        }
        if (listener == null) {
            this.m_log.info("No listener for ID!! " + mappingId + " in " + listener + " this is: " + this.hashCode());
            this.m_log.info("UPNP: " + this.m_upnpMappingIdsToListeners);
            this.m_log.info("NAT-PMP: " + this.m_natPmpMappingIdsToListeners);
            return;
        }
        listener.onPortMap(externalPort);
    }

    public void portMapLogAlert(int type, String message) {
        this.m_log.info("Port map log for type {}: " + message, (Object)type);
    }

    public void log(String msg) {
        this.m_log.info("From native code: {}", (Object)msg);
    }

    public void logError(String msg) {
        this.m_log.error("From native code: {}", (Object)msg);
    }

    public void shutdown() {
    }
}

