/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store;

import java.util.LinkedHashMap;
import java.util.Map;
import net.sf.ehcache.CacheEntry;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import net.sf.ehcache.store.AbstractStore;
import net.sf.ehcache.store.LruPolicy;
import net.sf.ehcache.store.Policy;
import net.sf.ehcache.store.Store;
import net.sf.ehcache.writer.CacheWriterManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LruMemoryStore
extends AbstractStore {
    private static final Logger LOG = LoggerFactory.getLogger(LruMemoryStore.class.getName());
    protected Ehcache cache;
    protected Map map;
    protected final Store diskStore;
    protected Status status = Status.STATUS_UNINITIALISED;
    protected int maximumSize;

    public LruMemoryStore(Ehcache cache, Store diskStore) {
        this.maximumSize = cache.getCacheConfiguration().getMaxElementsInMemory();
        this.cache = cache;
        this.diskStore = diskStore;
        this.map = new SpoolingLinkedHashMap();
        this.status = Status.STATUS_ALIVE;
    }

    public final boolean put(Element element) throws CacheException {
        return this.putInternal(element, null);
    }

    public final boolean putWithWriter(Element element, CacheWriterManager writerManager) throws CacheException {
        return this.putInternal(element, writerManager);
    }

    private synchronized boolean putInternal(Element element, CacheWriterManager writerManager) throws CacheException {
        boolean newPut = true;
        if (element != null) {
            boolean bl = newPut = this.map.put(element.getObjectKey(), element) == null;
            if (writerManager != null) {
                writerManager.put(element);
            }
            this.doPut(element);
        }
        return newPut;
    }

    protected void doPut(Element element) throws CacheException {
    }

    public final synchronized Element get(Object key) {
        return (Element)this.map.get(key);
    }

    public final synchronized Element getQuiet(Object key) {
        return this.get(key);
    }

    public final Element remove(Object key) {
        return this.removeInternal(key, null);
    }

    public final Element removeWithWriter(Object key, CacheWriterManager writerManager) throws CacheException {
        return this.removeInternal(key, writerManager);
    }

    private synchronized Element removeInternal(Object key, CacheWriterManager writerManager) throws CacheException {
        Element element = (Element)this.map.remove(key);
        if (writerManager != null) {
            writerManager.remove(new CacheEntry(key, element));
        }
        if (element != null) {
            return element;
        }
        return null;
    }

    public final synchronized void removeAll() throws CacheException {
        this.clear();
    }

    protected final void clear() {
        this.map.clear();
    }

    public final synchronized void dispose() {
        if (this.status.equals(Status.STATUS_SHUTDOWN)) {
            return;
        }
        this.status = Status.STATUS_SHUTDOWN;
        this.flush();
        this.cache = null;
    }

    public final void flush() {
        if (this.cache.getCacheConfiguration().isDiskPersistent()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.cache.getName() + " is persistent. Spooling " + this.map.size() + " elements to the disk store.");
            }
            this.spoolAllToDisk();
        }
        if (this.cache.getCacheConfiguration().isClearOnFlush()) {
            this.clear();
        }
    }

    protected final void spoolAllToDisk() {
        Object[] keys;
        boolean clearOnFlush = this.cache.getCacheConfiguration().isClearOnFlush();
        for (Object key : keys = this.getKeyArray()) {
            Element element = (Element)this.map.get(key);
            if (element == null) continue;
            if (!element.isSerializable()) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Object with key " + element.getObjectKey() + " is not Serializable and is not being overflowed to disk.");
                continue;
            }
            this.spoolToDisk(element);
            if (!clearOnFlush) continue;
            this.remove(key);
        }
    }

    protected void spoolToDisk(Element element) {
        this.diskStore.put(element);
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.cache.getName() + "Cache: spool to disk done for: " + element.getObjectKey());
        }
    }

    public final Status getStatus() {
        return this.status;
    }

    public final synchronized Object[] getKeyArray() {
        return this.map.keySet().toArray();
    }

    public final int getSize() {
        return this.map.size();
    }

    public final int getTerracottaClusteredSize() {
        return 0;
    }

    public final boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public final synchronized long getSizeInBytes() throws CacheException {
        long sizeInBytes = 0L;
        for (Element element : this.map.values()) {
            if (element == null) continue;
            sizeInBytes += element.getSerializedSize();
        }
        return sizeInBytes;
    }

    protected final void evict(Element element) throws CacheException {
        boolean spooled = false;
        if (this.cache.getCacheConfiguration().isOverflowToDisk()) {
            if (!element.isSerializable()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Object with key " + element.getObjectKey() + " is not Serializable and cannot be overflowed to disk");
                }
            } else {
                this.spoolToDisk(element);
                spooled = true;
            }
        }
        if (!spooled) {
            this.cache.getCacheEventNotificationService().notifyElementEvicted(element, false);
        }
    }

    protected final void notifyExpiry(Element element) {
        this.cache.getCacheEventNotificationService().notifyElementExpiry(element, false);
    }

    protected final boolean isFull() {
        return this.maximumSize > 0 && this.map.size() > this.maximumSize;
    }

    public void expireElements() {
    }

    public boolean bufferFull() {
        return false;
    }

    Map getBackingMap() {
        return this.map;
    }

    public Policy getEvictionPolicy() {
        return new LruPolicy();
    }

    public void setEvictionPolicy(Policy policy) {
        throw new UnsupportedOperationException("This store is LRU only. It does not support changing the eviction strategy.");
    }

    public Object getInternalContext() {
        return null;
    }

    public boolean containsKeyInMemory(Object key) {
        return this.containsKey(key);
    }

    public boolean containsKeyOnDisk(Object key) {
        return false;
    }

    public Policy getInMemoryEvictionPolicy() {
        return this.getEvictionPolicy();
    }

    public int getInMemorySize() {
        return this.getSize();
    }

    public long getInMemorySizeInBytes() {
        return this.getSizeInBytes();
    }

    public int getOnDiskSize() {
        return 0;
    }

    public long getOnDiskSizeInBytes() {
        return 0L;
    }

    public void setInMemoryEvictionPolicy(Policy policy) {
        this.setEvictionPolicy(policy);
    }

    public Element putIfAbsent(Element element) throws NullPointerException {
        throw new UnsupportedOperationException();
    }

    public Element removeElement(Element element) throws NullPointerException {
        throw new UnsupportedOperationException();
    }

    public boolean replace(Element old, Element element) throws NullPointerException, IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public Element replace(Element element) throws NullPointerException {
        throw new UnsupportedOperationException();
    }

    public final class SpoolingLinkedHashMap
    extends LinkedHashMap {
        private static final int INITIAL_CAPACITY = 100;
        private static final float GROWTH_FACTOR = 0.75f;

        public SpoolingLinkedHashMap() {
            super(100, 0.75f, true);
        }

        protected final boolean removeEldestEntry(Map.Entry eldest) {
            Element element = (Element)eldest.getValue();
            return element != null && this.removeLeastRecentlyUsedElement(element);
        }

        private boolean removeLeastRecentlyUsedElement(Element element) throws CacheException {
            if (element.isExpired()) {
                LruMemoryStore.this.notifyExpiry(element);
                return true;
            }
            if (LruMemoryStore.this.isFull()) {
                LruMemoryStore.this.evict(element);
                return true;
            }
            return false;
        }
    }
}

