/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.proxy;

import java.util.Arrays;
import java.util.Collection;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.littleshoot.proxy.HttpFilter;
import org.littleshoot.proxy.HttpRequestMatcher;
import org.littleshoot.proxy.HttpResponseFilter;

public class DefaultHttpFilter
implements HttpFilter {
    private final Collection<HttpRequestMatcher> requestMatchers;
    private final HttpResponseFilter responseFilter;

    public DefaultHttpFilter(HttpResponseFilter responseFilter, HttpRequestMatcher ... requestRules) {
        this.responseFilter = responseFilter;
        this.requestMatchers = Arrays.asList(requestRules);
    }

    public boolean shouldFilterResponses(HttpRequest httpRequest) {
        for (HttpRequestMatcher rule : this.requestMatchers) {
            if (rule.shouldFilterResponses(httpRequest)) continue;
            return false;
        }
        return true;
    }

    public HttpResponse filterResponse(HttpResponse response) {
        return this.responseFilter.filterResponse(response);
    }

    public int getMaxResponseSize() {
        return 204800;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Request Matchers: ");
        sb.append(this.requestMatchers);
        sb.append("\nResponse Filter: ");
        sb.append(this.responseFilter);
        return sb.toString();
    }
}

