/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.proxy;

import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.littleshoot.proxy.ProxyAuthorizationHandler;
import org.littleshoot.proxy.ProxyAuthorizationManager;
import org.littleshoot.proxy.ProxyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultProxyAuthorizationManager
implements ProxyAuthorizationManager {
    private final Logger m_log = LoggerFactory.getLogger(this.getClass());
    private final Collection<ProxyAuthorizationHandler> m_handlers = new LinkedList<ProxyAuthorizationHandler>();

    public void addHandler(ProxyAuthorizationHandler pah) {
        this.m_handlers.add(pah);
    }

    public boolean handleProxyAuthorization(HttpRequest request, ChannelHandlerContext ctx) {
        if (!request.containsHeader("Proxy-Authorization")) {
            if (!this.m_handlers.isEmpty()) {
                this.rejectRequest(ctx);
                return false;
            }
            return true;
        }
        List<String> values = request.getHeaders("Proxy-Authorization");
        String fullValue = values.iterator().next();
        String value = StringUtils.substringAfter(fullValue, "Basic ").trim();
        byte[] decodedValue = Base64.decodeBase64(value);
        try {
            String decodedString = new String(decodedValue, "UTF-8");
            String userName = StringUtils.substringBefore(decodedString, ":");
            String password = StringUtils.substringAfter(decodedString, ":");
            for (ProxyAuthorizationHandler handler : this.m_handlers) {
                if (handler.authenticate(userName, password)) continue;
                this.rejectRequest(ctx);
                return false;
            }
        }
        catch (UnsupportedEncodingException e) {
            this.m_log.error("Could not decode?", e);
        }
        this.m_log.info("Got proxy authorization!");
        String authentication = request.getHeader("Proxy-Authorization");
        this.m_log.info(authentication);
        request.removeHeader("Proxy-Authorization");
        return true;
    }

    private void rejectRequest(ChannelHandlerContext ctx) {
        String statusLine = "HTTP/1.1 407 Proxy Authentication Required\r\n";
        String headers = "Date: " + ProxyUtils.httpDate() + "\r\n" + "Proxy-Authenticate: Basic realm=\"Restricted Files\"\r\n" + "Content-Length: 415\r\n" + "Content-Type: text/html; charset=iso-8859-1\r\n" + "\r\n";
        String responseBody = "<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\">\n<html><head>\n<title>407 Proxy Authentication Required</title>\n</head><body>\n<h1>Proxy Authentication Required</h1>\n<p>This server could not verify that you\nare authorized to access the document\nrequested.  Either you supplied the wrong\ncredentials (e.g., bad password), or your\nbrowser doesn't understand how to supply\nthe credentials required.</p>\n</body></html>\n";
        this.m_log.info("Content-Length is really: " + "<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\">\n<html><head>\n<title>407 Proxy Authentication Required</title>\n</head><body>\n<h1>Proxy Authentication Required</h1>\n<p>This server could not verify that you\nare authorized to access the document\nrequested.  Either you supplied the wrong\ncredentials (e.g., bad password), or your\nbrowser doesn't understand how to supply\nthe credentials required.</p>\n</body></html>\n".length());
        ProxyUtils.writeResponse(ctx.getChannel(), "HTTP/1.1 407 Proxy Authentication Required\r\n", headers, "<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\">\n<html><head>\n<title>407 Proxy Authentication Required</title>\n</head><body>\n<h1>Proxy Authentication Required</h1>\n<p>This server could not verify that you\nare authorized to access the document\nrequested.  Either you supplied the wrong\ncredentials (e.g., bad password), or your\nbrowser doesn't understand how to supply\nthe credentials required.</p>\n</body></html>\n");
    }
}

