/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.proxy;

import java.util.Map;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.handler.codec.http.HttpChunkAggregator;
import org.jboss.netty.handler.codec.http.HttpContentDecompressor;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponseDecoder;
import org.jboss.netty.handler.timeout.IdleStateHandler;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timer;
import org.littleshoot.proxy.HttpFilter;
import org.littleshoot.proxy.HttpRelayingHandler;
import org.littleshoot.proxy.HttpRequestFilter;
import org.littleshoot.proxy.IdleAwareHandler;
import org.littleshoot.proxy.ProxyHttpRequestEncoder;
import org.littleshoot.proxy.RelayListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRelayPipelineFactory
implements ChannelPipelineFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultRelayPipelineFactory.class);
    private static final Timer TIMER = new HashedWheelTimer();
    private final String hostAndPort;
    private final HttpRequest httpRequest;
    private final RelayListener relayListener;
    private final Channel browserToProxyChannel;
    private final ChannelGroup channelGroup;
    private final Map<String, HttpFilter> filters;
    private final HttpRequestFilter requestFilter;
    private String chainProxyHostAndPort;
    private final boolean filtersOff;

    public DefaultRelayPipelineFactory(String hostAndPort, HttpRequest httpRequest, RelayListener relayListener, Channel browserToProxyChannel, ChannelGroup channelGroup, Map<String, HttpFilter> filters, HttpRequestFilter requestFilter, String chainProxyHostAndPort) {
        this.hostAndPort = hostAndPort;
        this.httpRequest = httpRequest;
        this.relayListener = relayListener;
        this.browserToProxyChannel = browserToProxyChannel;
        this.channelGroup = channelGroup;
        this.filters = filters;
        this.requestFilter = requestFilter;
        this.chainProxyHostAndPort = chainProxyHostAndPort;
        this.filtersOff = filters.isEmpty();
    }

    @Override
    public ChannelPipeline getPipeline() throws Exception {
        int writeTimeoutSeconds;
        int readTimeoutSeconds;
        HttpFilter filter;
        boolean shouldFilter;
        ChannelPipeline pipeline = Channels.pipeline();
        pipeline.addLast("decoder", new HttpResponseDecoder(8192, 16384, 16384));
        LOG.debug("Querying for host and port: {}", (Object)this.hostAndPort);
        if (this.filtersOff) {
            shouldFilter = false;
            filter = null;
        } else {
            filter = this.filters.get(this.hostAndPort);
            if (filter == null) {
                LOG.info("Filter not found in: {}", this.filters);
                shouldFilter = false;
            } else {
                LOG.debug("Using filter: {}", filter);
                shouldFilter = filter.shouldFilterResponses(this.httpRequest);
            }
            LOG.debug("Filtering: " + shouldFilter);
        }
        if (shouldFilter) {
            pipeline.addLast("inflater", new HttpContentDecompressor());
            pipeline.addLast("aggregator", new HttpChunkAggregator(filter.getMaxResponseSize()));
        }
        HttpRelayingHandler handler = shouldFilter ? new HttpRelayingHandler(this.browserToProxyChannel, this.channelGroup, filter, this.relayListener, this.hostAndPort) : new HttpRelayingHandler(this.browserToProxyChannel, this.channelGroup, this.relayListener, this.hostAndPort);
        ProxyHttpRequestEncoder encoder = new ProxyHttpRequestEncoder(handler, this.requestFilter, this.chainProxyHostAndPort);
        pipeline.addLast("encoder", encoder);
        if (this.httpRequest.getMethod().equals(HttpMethod.POST) || this.httpRequest.getMethod().equals(HttpMethod.PUT)) {
            readTimeoutSeconds = 0;
            writeTimeoutSeconds = 40;
        } else {
            readTimeoutSeconds = 40;
            writeTimeoutSeconds = 0;
        }
        pipeline.addLast("idle", new IdleStateHandler(TIMER, readTimeoutSeconds, writeTimeoutSeconds, 0));
        pipeline.addLast("idleAware", new IdleAwareHandler());
        pipeline.addLast("handler", handler);
        return pipeline;
    }
}

