/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.proxy;

import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import org.littleshoot.proxy.ProxyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class HttpConnectRelayingHandler
extends SimpleChannelUpstreamHandler {
    private static final Logger LOG = LoggerFactory.getLogger(HttpConnectRelayingHandler.class);
    private final Channel relayChannel;
    private final ChannelGroup channelGroup;

    public HttpConnectRelayingHandler(Channel relayChannel, ChannelGroup channelGroup) {
        this.relayChannel = relayChannel;
        this.channelGroup = channelGroup;
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        ChannelBuffer msg = (ChannelBuffer)e.getMessage();
        if (this.relayChannel.isConnected()) {
            ChannelFutureListener logListener = new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    LOG.debug("Finished writing data on CONNECT channel");
                }
            };
            this.relayChannel.write(msg).addListener(logListener);
        } else {
            LOG.info("Channel not open. Connected? {}", this.relayChannel.isConnected());
            ProxyUtils.closeOnFlush(e.getChannel());
        }
    }

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent cse) throws Exception {
        Channel ch = cse.getChannel();
        LOG.info("New CONNECT channel opened from proxy to web: {}", ch);
        if (this.channelGroup != null) {
            this.channelGroup.add(ch);
        }
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        LOG.info("Got closed event on proxy -> web connection: {}", e.getChannel());
        ProxyUtils.closeOnFlush(this.relayChannel);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        LOG.warn("Caught exception on proxy -> web connection: " + e.getChannel(), e.getCause());
        ProxyUtils.closeOnFlush(e.getChannel());
    }
}

