/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.proxy;

import java.lang.management.ManagementFactory;
import java.net.InetSocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.apache.commons.lang.StringUtils;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.socket.ClientSocketChannelFactory;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.littleshoot.proxy.ConnectionData;
import org.littleshoot.proxy.HttpConnectRelayingHandler;
import org.littleshoot.proxy.ProxyAuthorizationManager;
import org.littleshoot.proxy.ProxyCacheManager;
import org.littleshoot.proxy.ProxyUtils;
import org.littleshoot.proxy.RelayListener;
import org.littleshoot.proxy.RelayPipelineFactoryFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestHandler
extends SimpleChannelUpstreamHandler
implements RelayListener,
ConnectionData {
    private static final Logger log = LoggerFactory.getLogger(HttpRequestHandler.class);
    private volatile boolean readingChunks;
    private static volatile int totalBrowserToProxyConnections = 0;
    private volatile int browserToProxyConnections = 0;
    private final Map<String, Queue<ChannelFuture>> externalHostsToChannelFutures = new ConcurrentHashMap<String, Queue<ChannelFuture>>();
    private volatile int messagesReceived = 0;
    private volatile int unansweredRequestCount = 0;
    private volatile int requestsSent = 0;
    private volatile int responsesReceived = 0;
    private final ProxyAuthorizationManager authorizationManager;
    private final Set<String> answeredRequests = new HashSet<String>();
    private final Set<String> unansweredRequests = new HashSet<String>();
    private ChannelFuture currentChannelFuture;
    private final Queue<HttpRequest> requests = new LinkedList<HttpRequest>();
    private String hostAndPort;
    private final String chainProxyHostAndPort;
    private final ChannelGroup channelGroup;
    private final ClientSocketChannelFactory clientChannelFactory;
    private final ProxyCacheManager cacheManager;
    private final AtomicBoolean browserChannelClosed = new AtomicBoolean(false);
    private volatile boolean receivedChannelClosed = false;
    private final boolean useJmx;
    private final RelayPipelineFactoryFactory relayPipelineFactoryFactory;

    public HttpRequestHandler(ClientSocketChannelFactory clientChannelFactory, RelayPipelineFactoryFactory relayPipelineFactoryFactory) {
        this(null, null, null, clientChannelFactory, null, relayPipelineFactoryFactory, false);
    }

    public HttpRequestHandler(ProxyCacheManager cacheManager, ProxyAuthorizationManager authorizationManager, ChannelGroup channelGroup, ClientSocketChannelFactory clientChannelFactory, RelayPipelineFactoryFactory relayPipelineFactoryFactory) {
        this(cacheManager, authorizationManager, channelGroup, clientChannelFactory, null, relayPipelineFactoryFactory, false);
    }

    public HttpRequestHandler(ProxyCacheManager cacheManager, ProxyAuthorizationManager authorizationManager, ChannelGroup channelGroup, ClientSocketChannelFactory clientChannelFactory, String chainProxyHostAndPort, RelayPipelineFactoryFactory relayPipelineFactoryFactory, boolean useJmx) {
        this.cacheManager = cacheManager;
        this.authorizationManager = authorizationManager;
        this.channelGroup = channelGroup;
        this.clientChannelFactory = clientChannelFactory;
        this.chainProxyHostAndPort = chainProxyHostAndPort;
        this.relayPipelineFactoryFactory = relayPipelineFactoryFactory;
        this.useJmx = useJmx;
        if (useJmx) {
            this.setupJmx();
        }
    }

    private void setupJmx() {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            Class<?> clazz = this.getClass();
            String pack = clazz.getPackage().getName();
            String oName = pack + ":type=" + clazz.getSimpleName() + "-" + clazz.getSimpleName() + "-" + this.hashCode();
            log.info("Registering MBean with name: {}", (Object)oName);
            ObjectName mxBeanName = new ObjectName(oName);
            if (!mbs.isRegistered(mxBeanName)) {
                mbs.registerMBean(this, mxBeanName);
            }
        }
        catch (MalformedObjectNameException e) {
            log.error("Could not set up JMX", e);
        }
        catch (InstanceAlreadyExistsException e) {
            log.error("Could not set up JMX", e);
        }
        catch (MBeanRegistrationException e) {
            log.error("Could not set up JMX", e);
        }
        catch (NotCompliantMBeanException e) {
            log.error("Could not set up JMX", e);
        }
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent me) {
        if (this.browserChannelClosed.get()) {
            log.info("Ignoring message since the connection to the browser is about to close");
            return;
        }
        ++this.messagesReceived;
        log.info("Received " + this.messagesReceived + " total messages");
        if (!this.readingChunks) {
            this.processMessage(ctx, me);
        } else {
            this.processChunk(ctx, me);
        }
    }

    private void processChunk(ChannelHandlerContext ctx, MessageEvent me) {
        log.info("Processing chunk...");
        final HttpChunk chunk = (HttpChunk)me.getMessage();
        if (chunk.isLast()) {
            this.readingChunks = false;
        }
        if (this.currentChannelFuture.getChannel().isConnected()) {
            this.currentChannelFuture.getChannel().write(chunk);
        } else {
            this.currentChannelFuture.addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    HttpRequestHandler.this.currentChannelFuture.getChannel().write(chunk);
                }
            });
        }
    }

    private void processMessage(final ChannelHandlerContext ctx, MessageEvent me) {
        final HttpRequest request = (HttpRequest)me.getMessage();
        final Channel inboundChannel = me.getChannel();
        if (this.cacheManager != null && this.cacheManager.returnCacheHit((HttpRequest)me.getMessage(), inboundChannel)) {
            log.info("Found cache hit! Cache wrote the response.");
            return;
        }
        ++this.unansweredRequestCount;
        log.info("Got request: {} on channel: " + inboundChannel, request);
        if (this.authorizationManager != null && !this.authorizationManager.handleProxyAuthorization(request, ctx)) {
            log.info("Not authorized!!");
            return;
        }
        this.hostAndPort = this.chainProxyHostAndPort != null ? this.chainProxyHostAndPort : ProxyUtils.parseHostAndPort(request);
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class OnConnect {
            OnConnect() {
            }

            public ChannelFuture onConnect(ChannelFuture cf) {
                if (request.getMethod() != HttpMethod.CONNECT) {
                    ChannelFuture writeFuture = cf.getChannel().write(request);
                    writeFuture.addListener(new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture future) throws Exception {
                            if (HttpRequestHandler.this.useJmx) {
                                HttpRequestHandler.this.unansweredRequests.add(request.toString());
                            }
                            HttpRequestHandler.this.requestsSent++;
                        }
                    });
                    return writeFuture;
                }
                HttpRequestHandler.this.writeConnectResponse(ctx, request, cf.getChannel());
                return cf;
            }
        }
        final OnConnect onConnect = new OnConnect();
        final ChannelFuture curFuture = this.getChannelFuture();
        if (curFuture != null) {
            log.info("Using existing connection...");
            this.currentChannelFuture = curFuture;
            if (curFuture.getChannel().isConnected()) {
                onConnect.onConnect(curFuture);
            } else {
                ChannelFutureListener cfl = new ChannelFutureListener(){
                    {
                    }

                    public void operationComplete(ChannelFuture future) throws Exception {
                        onConnect.onConnect(curFuture);
                    }
                };
                curFuture.addListener(cfl);
            }
        } else {
            log.info("Establishing new connection");
            final ChannelFuture cf = this.newChannelFuture(request, inboundChannel);
            cf.addListener(new ChannelFutureListener(){
                {
                }

                public void operationComplete(ChannelFuture future) throws Exception {
                    Channel channel = future.getChannel();
                    if (HttpRequestHandler.this.channelGroup != null) {
                        HttpRequestHandler.this.channelGroup.add(channel);
                    }
                    if (future.isSuccess()) {
                        log.info("Connected successfully to: {}", channel);
                        log.info("Writing message on channel...");
                        ChannelFuture wf = onConnect.onConnect(cf);
                        wf.addListener(new ChannelFutureListener(){

                            public void operationComplete(ChannelFuture wcf) throws Exception {
                                log.info("Finished write: " + wcf + " to: " + request.getMethod() + " " + request.getUri());
                            }
                        });
                    } else {
                        log.info("Could not connect to " + HttpRequestHandler.this.hostAndPort, future.getCause());
                        HttpRequestHandler.this.onRelayChannelClose(inboundChannel, HttpRequestHandler.this.hostAndPort, 1, true);
                    }
                }
            });
        }
        if (request.isChunked()) {
            this.readingChunks = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChannelAvailable(String hostAndPortKey, ChannelFuture cf) {
        Map<String, Queue<ChannelFuture>> map = this.externalHostsToChannelFutures;
        synchronized (map) {
            Queue<ChannelFuture> toUse;
            Queue<ChannelFuture> futures = this.externalHostsToChannelFutures.get(this.hostAndPort);
            if (futures == null) {
                toUse = new LinkedList<ChannelFuture>();
                this.externalHostsToChannelFutures.put(this.hostAndPort, toUse);
            } else {
                toUse = futures;
            }
            toUse.add(cf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChannelFuture getChannelFuture() {
        Map<String, Queue<ChannelFuture>> map = this.externalHostsToChannelFutures;
        synchronized (map) {
            Queue<ChannelFuture> futures = this.externalHostsToChannelFutures.get(this.hostAndPort);
            if (futures == null) {
                return null;
            }
            if (futures.isEmpty()) {
                return null;
            }
            ChannelFuture cf = futures.remove();
            if (cf != null && cf.isSuccess() && !cf.getChannel().isConnected()) {
                this.removeProxyToWebConnection(this.hostAndPort);
                return null;
            }
            return cf;
        }
    }

    private void writeConnectResponse(ChannelHandlerContext ctx, HttpRequest httpRequest, Channel outgoingChannel) {
        int port = ProxyUtils.parsePort(httpRequest);
        Channel browserToProxyChannel = ctx.getChannel();
        if (port < 0) {
            log.warn("Connecting on port other than 443!!");
            String statusLine = "HTTP/1.1 502 Proxy Error\r\n";
            ProxyUtils.writeResponse(browserToProxyChannel, "HTTP/1.1 502 Proxy Error\r\n", ProxyUtils.PROXY_ERROR_HEADERS);
        } else {
            browserToProxyChannel.setReadable(false);
            ctx.getPipeline().remove("encoder");
            ctx.getPipeline().remove("decoder");
            ctx.getPipeline().remove("handler");
            ctx.getPipeline().addLast("handler", new HttpConnectRelayingHandler(outgoingChannel, this.channelGroup));
            String statusLine = "HTTP/1.1 200 Connection established\r\n";
            ProxyUtils.writeResponse(browserToProxyChannel, "HTTP/1.1 200 Connection established\r\n", ProxyUtils.CONNECT_OK_HEADERS);
            browserToProxyChannel.setReadable(true);
        }
    }

    private ChannelFuture newChannelFuture(HttpRequest httpRequest, final Channel browserToProxyChannel) {
        int port;
        String host;
        if (this.hostAndPort.contains(":")) {
            host = StringUtils.substringBefore(this.hostAndPort, ":");
            String portString = StringUtils.substringAfter(this.hostAndPort, ":");
            port = Integer.parseInt(portString);
        } else {
            host = this.hostAndPort;
            port = 80;
        }
        ClientBootstrap cb = new ClientBootstrap(this.clientChannelFactory);
        ChannelPipelineFactory cpf = httpRequest.getMethod() == HttpMethod.CONNECT ? new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline pipeline = Channels.pipeline();
                pipeline.addLast("handler", new HttpConnectRelayingHandler(browserToProxyChannel, HttpRequestHandler.this.channelGroup));
                return pipeline;
            }
        } : this.relayPipelineFactoryFactory.getRelayPipelineFactory(httpRequest, browserToProxyChannel, this);
        cb.setPipelineFactory(cpf);
        cb.setOption("connectTimeoutMillis", 40000);
        log.info("Starting new connection to: {}", (Object)this.hostAndPort);
        ChannelFuture future = cb.connect(new InetSocketAddress(host, port));
        return future;
    }

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent cse) throws Exception {
        Channel inboundChannel = cse.getChannel();
        log.info("New channel opened: {}", inboundChannel);
        ++this.browserToProxyConnections;
        log.info("Now " + ++totalBrowserToProxyConnections + " browser to proxy channels...");
        log.info("Now this class has " + this.browserToProxyConnections + " browser to proxy channels...");
        if (this.channelGroup != null) {
            this.channelGroup.add(inboundChannel);
        }
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent cse) {
        log.info("Channel closed: {}", cse.getChannel());
        --this.browserToProxyConnections;
        log.info("Now " + --totalBrowserToProxyConnections + " total browser to proxy channels...");
        log.info("Now this class has " + this.browserToProxyConnections + " browser to proxy channels...");
        if (this.browserToProxyConnections == 0) {
            log.info("Closing all proxy to web channels for this browser to proxy connection!!!");
            Collection<Queue<ChannelFuture>> allFutures = this.externalHostsToChannelFutures.values();
            for (Queue<ChannelFuture> futures : allFutures) {
                for (ChannelFuture future : futures) {
                    Channel ch = future.getChannel();
                    if (!ch.isOpen()) continue;
                    future.getChannel().close();
                }
            }
        }
    }

    public void onRelayChannelClose(Channel browserToProxyChannel, String key, int unansweredRequestsOnChannel, boolean closedEndsResponseBody) {
        if (closedEndsResponseBody) {
            log.info("Close ends response body");
            this.receivedChannelClosed = true;
        }
        log.info("this.receivedChannelClosed: " + this.receivedChannelClosed);
        this.removeProxyToWebConnection(key);
        this.unansweredRequestCount -= unansweredRequestsOnChannel;
        if (this.receivedChannelClosed && (this.externalHostsToChannelFutures.isEmpty() || this.unansweredRequestCount == 0)) {
            if (!this.browserChannelClosed.getAndSet(true)) {
                log.info("Closing browser to proxy channel");
                ProxyUtils.closeOnFlush(browserToProxyChannel);
            }
        } else {
            log.info("Not closing browser to proxy channel. Still " + this.externalHostsToChannelFutures.size() + " connections and awaiting " + this.unansweredRequestCount + " responses");
        }
    }

    private void removeProxyToWebConnection(String key) {
        this.externalHostsToChannelFutures.remove(key);
    }

    public void onRelayHttpResponse(Channel browserToProxyChannel, String key, HttpRequest httpRequest) {
        if (this.useJmx) {
            this.answeredRequests.add(httpRequest.toString());
            this.unansweredRequests.remove(httpRequest.toString());
        }
        --this.unansweredRequestCount;
        ++this.responsesReceived;
        if (this.unansweredRequestCount == 0 && this.receivedChannelClosed) {
            if (!this.browserChannelClosed.getAndSet(true)) {
                log.info("Closing browser to proxy channel on HTTP response");
                ProxyUtils.closeOnFlush(browserToProxyChannel);
            }
        } else {
            log.info("Not closing browser to proxy channel. Still awaiting " + this.unansweredRequestCount + " responses..." + "receivedChannelClosed=" + this.receivedChannelClosed);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        Channel channel = e.getChannel();
        Throwable cause = e.getCause();
        if (cause instanceof ClosedChannelException) {
            log.warn("Caught an exception on browser to proxy channel: " + channel, cause);
        } else {
            log.info("Caught an exception on browser to proxy channel: " + channel, cause);
        }
        ProxyUtils.closeOnFlush(channel);
    }

    public int getClientConnections() {
        return this.browserToProxyConnections;
    }

    public int getTotalClientConnections() {
        return totalBrowserToProxyConnections;
    }

    public int getOutgoingConnections() {
        return this.externalHostsToChannelFutures.size();
    }

    public int getRequestsSent() {
        return this.requestsSent;
    }

    public int getResponsesReceived() {
        return this.responsesReceived;
    }

    public String getUnansweredRequests() {
        return this.unansweredRequests.toString();
    }

    public String getAnsweredReqeusts() {
        return this.answeredRequests.toString();
    }

    public String getRequests() {
        StringBuilder sb = new StringBuilder();
        for (HttpRequest hr : this.requests) {
            String uri = hr.getUri();
            sb.append(uri);
            sb.append("\n");
        }
        return sb.toString();
    }
}

