/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.proxy;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.littleshoot.proxy.ProxyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LittleProxyConfig {
    private static final Logger LOG = LoggerFactory.getLogger(LittleProxyConfig.class);
    private static final Properties props = new Properties();
    private static boolean useDnsSec;
    private static boolean useJmx;
    private static String proxyCacheManagerClass;
    private static boolean transparent;

    private LittleProxyConfig() {
    }

    public static void setUseDnsSec(boolean useDnsSec) {
        LittleProxyConfig.useDnsSec = useDnsSec;
    }

    public static boolean isUseDnsSec() {
        return useDnsSec;
    }

    public static void setUseJmx(boolean useJmx) {
        LittleProxyConfig.useJmx = useJmx;
    }

    public static boolean isUseJmx() {
        return useJmx;
    }

    public static void setProxyCacheManagerClass(String clazz) {
        proxyCacheManagerClass = clazz;
    }

    public static String getProxyCacheManagerClass() {
        return proxyCacheManagerClass;
    }

    public static void setTransparent(boolean transparent) {
        LittleProxyConfig.transparent = transparent;
    }

    public static boolean isTransparent() {
        return transparent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        File propsFile = new File("./littleproxy.properties");
        if (propsFile.isFile()) {
            FileInputStream is = null;
            try {
                is = new FileInputStream(propsFile);
                props.load(is);
            }
            catch (IOException e) {
                try {
                    LOG.warn("Could not load props file?", (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)is);
            }
            IOUtils.closeQuietly((InputStream)is);
        }
        useDnsSec = ProxyUtils.extractBooleanDefaultFalse(props, "dnssec");
        useJmx = ProxyUtils.extractBooleanDefaultFalse(props, "jmx");
        proxyCacheManagerClass = props.getProperty("proxy_cache_manager_class");
        transparent = ProxyUtils.extractBooleanDefaultFalse(props, "transparent");
    }
}

