/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.proxy;

import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkUtils {
    private static final Logger LOG = LoggerFactory.getLogger(NetworkUtils.class);

    public static InetAddress getLocalHost() throws UnknownHostException {
        try {
            InetAddress is = InetAddress.getLocalHost();
            if (!is.isLoopbackAddress()) {
                return is;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return NetworkUtils.getLocalHostViaUdp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InetAddress getLocalHostViaUdp() throws UnknownHostException {
        InetSocketAddress sa = new InetSocketAddress("www.google.com", 80);
        DatagramSocket sock = null;
        try {
            InetAddress address;
            sock = new DatagramSocket();
            sock.connect(sa);
            InetAddress inetAddress = address = sock.getLocalAddress();
            return inetAddress;
        }
        catch (SocketException e) {
            LOG.warn("Exception getting address", (Throwable)e);
            InetAddress inetAddress = InetAddress.getLocalHost();
            return inetAddress;
        }
        finally {
            if (sock != null) {
                sock.close();
            }
        }
    }

    public static boolean isPublicAddress(InetAddress ia) {
        return !ia.isSiteLocalAddress() && !ia.isLinkLocalAddress() && !ia.isAnyLocalAddress() && !ia.isLoopbackAddress() && !ia.isMulticastAddress();
    }

    public static boolean isPublicAddress() {
        try {
            return NetworkUtils.isPublicAddress(NetworkUtils.getLocalHost());
        }
        catch (UnknownHostException e) {
            LOG.warn("Could not get address", (Throwable)e);
            return false;
        }
    }

    public static Collection<InetAddress> getNetworkInterfaces() throws SocketException {
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
        while (e.hasMoreElements()) {
            NetworkInterface ni = e.nextElement();
            Enumeration<InetAddress> niAddresses = ni.getInetAddresses();
            while (niAddresses.hasMoreElements()) {
                addresses.add(niAddresses.nextElement());
            }
        }
        return addresses;
    }
}

