/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.proxy;

import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseEncoder;
import org.littleshoot.proxy.ProxyCacheManager;
import org.littleshoot.proxy.ProxyHttpResponse;
import org.littleshoot.proxy.ProxyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyHttpResponseEncoder
extends HttpResponseEncoder {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final ProxyCacheManager cacheManager;
    private final boolean transparent;

    public ProxyHttpResponseEncoder() {
        this(null);
    }

    public ProxyHttpResponseEncoder(ProxyCacheManager cacheManager) {
        this(cacheManager, false);
    }

    public ProxyHttpResponseEncoder(boolean transparent) {
        this(null, transparent);
    }

    public ProxyHttpResponseEncoder(ProxyCacheManager cacheManager, boolean transparent) {
        this.cacheManager = cacheManager;
        this.transparent = transparent;
    }

    protected Object encode(ChannelHandlerContext ctx, Channel channel, Object msg) throws Exception {
        if (msg instanceof ProxyHttpResponse) {
            ChannelBuffer encoded;
            ProxyHttpResponse proxyResponse = (ProxyHttpResponse)msg;
            HttpRequest httpRequest = proxyResponse.getHttpRequest();
            HttpResponse httpResponse = proxyResponse.getHttpResponse();
            Object response = proxyResponse.getResponse();
            if (!this.transparent && response instanceof HttpResponse) {
                HttpResponse hr = (HttpResponse)response;
                ProxyUtils.stripHopByHopHeaders((HttpMessage)hr);
                ProxyUtils.addVia((HttpMessage)hr);
            }
            if ((encoded = (ChannelBuffer)super.encode(ctx, channel, response)) != null && this.cacheManager != null) {
                this.cacheManager.cache(httpRequest, httpResponse, response, encoded);
            }
            return encoded;
        }
        if (msg instanceof HttpResponse && !this.transparent) {
            HttpResponse hr = (HttpResponse)msg;
            ProxyUtils.stripHopByHopHeaders((HttpMessage)hr);
            ProxyUtils.addVia((HttpMessage)hr);
        }
        return super.encode(ctx, channel, msg);
    }
}

