/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.proxy;

import java.security.KeyStore;
import java.security.Security;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.littleshoot.proxy.KeyStoreManager;

public class SslContextFactory {
    private static final String PROTOCOL = "TLS";
    private final SSLContext SERVER_CONTEXT;

    public SslContextFactory(KeyStoreManager ksm) {
        this(ksm, null);
    }

    public SslContextFactory(KeyStoreManager ksm, TrustManager[] trustManagers) {
        SSLContext serverContext;
        String algorithm = Security.getProperty("ssl.KeyManagerFactory.algorithm");
        if (algorithm == null) {
            algorithm = "SunX509";
        }
        try {
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(ksm.keyStoreAsInputStream(), ksm.getKeyStorePassword());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
            kmf.init(ks, ksm.getCertificatePassword());
            serverContext = SSLContext.getInstance(PROTOCOL);
            serverContext.init(kmf.getKeyManagers(), trustManagers, null);
        }
        catch (Exception e) {
            throw new Error("Failed to initialize the server-side SSLContext", e);
        }
        this.SERVER_CONTEXT = serverContext;
    }

    public SSLContext getServerContext() {
        return this.SERVER_CONTEXT;
    }
}

