/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.proxy;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.ChannelGroupFuture;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.ClientSocketChannelFactory;
import org.jboss.netty.channel.socket.ServerSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.ThreadNameDeterminer;
import org.jboss.netty.util.ThreadRenamingRunnable;
import org.jboss.netty.util.Timer;
import org.littleshoot.proxy.ChainProxyManager;
import org.littleshoot.proxy.DefaultProxyAuthorizationManager;
import org.littleshoot.proxy.DefaultRelayPipelineFactoryFactory;
import org.littleshoot.proxy.HandshakeHandlerFactory;
import org.littleshoot.proxy.HttpFilter;
import org.littleshoot.proxy.HttpProxyServer;
import org.littleshoot.proxy.HttpRequestFilter;
import org.littleshoot.proxy.HttpResponseFilters;
import org.littleshoot.proxy.HttpServerPipelineFactory;
import org.littleshoot.proxy.NetworkUtils;
import org.littleshoot.proxy.ProxyAuthorizationHandler;
import org.littleshoot.proxy.ProxyAuthorizationManager;
import org.littleshoot.proxy.ProxyCacheManager;
import org.littleshoot.proxy.ProxyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHttpProxyServer
implements HttpProxyServer {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ChannelGroup allChannels = new DefaultChannelGroup("HTTP-Proxy-Server");
    private final int port;
    private final ProxyAuthorizationManager authenticationManager = new DefaultProxyAuthorizationManager();
    private final ChainProxyManager chainProxyManager;
    private final HandshakeHandlerFactory handshakeHandlerFactory;
    private final HttpRequestFilter requestFilter;
    private final ServerBootstrap serverBootstrap;
    private final HttpResponseFilters responseFilters;
    private final Timer timer;
    private final ServerSocketChannelFactory serverChannelFactory;
    private final ClientSocketChannelFactory clientChannelFactory;
    private final ProxyCacheManager cacheManager;
    private final AtomicBoolean stopped = new AtomicBoolean(false);

    public DefaultHttpProxyServer(int port) {
        this(port, new HttpResponseFilters(){

            @Override
            public HttpFilter getFilter(String hostAndPort) {
                return null;
            }
        });
    }

    public DefaultHttpProxyServer(int port, HttpResponseFilters responseFilters) {
        this(port, responseFilters, null, null, null, (ClientSocketChannelFactory)new NioClientSocketChannelFactory(DefaultHttpProxyServer.newClientThreadPool(), DefaultHttpProxyServer.newClientThreadPool()), (Timer)new HashedWheelTimer(), (ServerSocketChannelFactory)new NioServerSocketChannelFactory(DefaultHttpProxyServer.newServerThreadPool(), DefaultHttpProxyServer.newServerThreadPool()));
    }

    public DefaultHttpProxyServer(int port, HttpResponseFilters responseFilters, ProxyCacheManager cacheManager) {
        this(port, responseFilters, null, null, null, (ClientSocketChannelFactory)new NioClientSocketChannelFactory(DefaultHttpProxyServer.newClientThreadPool(), DefaultHttpProxyServer.newClientThreadPool()), (Timer)new HashedWheelTimer(), (ServerSocketChannelFactory)new NioServerSocketChannelFactory(DefaultHttpProxyServer.newServerThreadPool(), DefaultHttpProxyServer.newServerThreadPool()), cacheManager);
    }

    public DefaultHttpProxyServer(int port, HttpRequestFilter requestFilter) {
        this(port, requestFilter, new HttpResponseFilters(){

            @Override
            public HttpFilter getFilter(String hostAndPort) {
                return null;
            }
        });
    }

    public DefaultHttpProxyServer(int port, ProxyCacheManager cacheManager) {
        this(port, new HttpResponseFilters(){

            @Override
            public HttpFilter getFilter(String hostAndPort) {
                return null;
            }
        }, cacheManager);
    }

    public DefaultHttpProxyServer(int port, HttpRequestFilter requestFilter, HttpResponseFilters responseFilters) {
        this(port, responseFilters, null, null, requestFilter, (ClientSocketChannelFactory)new NioClientSocketChannelFactory(DefaultHttpProxyServer.newClientThreadPool(), DefaultHttpProxyServer.newClientThreadPool()), (Timer)new HashedWheelTimer(), (ServerSocketChannelFactory)new NioServerSocketChannelFactory(DefaultHttpProxyServer.newServerThreadPool(), DefaultHttpProxyServer.newServerThreadPool()));
    }

    public DefaultHttpProxyServer(int port, HttpRequestFilter requestFilter, ClientSocketChannelFactory clientChannelFactory, Timer timer, ServerSocketChannelFactory serverChannelFactory) {
        this(port, new HttpResponseFilters(){

            @Override
            public HttpFilter getFilter(String hostAndPort) {
                return null;
            }
        }, null, null, requestFilter, clientChannelFactory, timer, serverChannelFactory);
    }

    public DefaultHttpProxyServer(int port, HttpResponseFilters responseFilters, ChainProxyManager chainProxyManager, HandshakeHandlerFactory handshakeHandlerFactory, HttpRequestFilter requestFilter) {
        this(port, responseFilters, chainProxyManager, handshakeHandlerFactory, requestFilter, (ClientSocketChannelFactory)new NioClientSocketChannelFactory(DefaultHttpProxyServer.newClientThreadPool(), DefaultHttpProxyServer.newClientThreadPool()), (Timer)new HashedWheelTimer(), (ServerSocketChannelFactory)new NioServerSocketChannelFactory(DefaultHttpProxyServer.newServerThreadPool(), DefaultHttpProxyServer.newServerThreadPool()));
    }

    public DefaultHttpProxyServer(int port, HttpResponseFilters responseFilters, ChainProxyManager chainProxyManager, HandshakeHandlerFactory handshakeHandlerFactory, HttpRequestFilter requestFilter, ClientSocketChannelFactory clientChannelFactory, Timer timer, ServerSocketChannelFactory serverChannelFactory) {
        this(port, responseFilters, chainProxyManager, handshakeHandlerFactory, requestFilter, clientChannelFactory, timer, serverChannelFactory, ProxyUtils.loadCacheManager());
    }

    public DefaultHttpProxyServer(int port, HttpResponseFilters responseFilters, ChainProxyManager chainProxyManager, HandshakeHandlerFactory handshakeHandlerFactory, HttpRequestFilter requestFilter, ClientSocketChannelFactory clientChannelFactory, Timer timer, ServerSocketChannelFactory serverChannelFactory, ProxyCacheManager cacheManager) {
        this.port = port;
        this.responseFilters = responseFilters;
        this.handshakeHandlerFactory = handshakeHandlerFactory;
        this.requestFilter = requestFilter;
        this.chainProxyManager = chainProxyManager;
        this.clientChannelFactory = clientChannelFactory;
        this.timer = timer;
        this.serverChannelFactory = serverChannelFactory;
        this.cacheManager = cacheManager == null ? ProxyUtils.loadCacheManager() : cacheManager;
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                DefaultHttpProxyServer.this.log.error("Uncaught throwable", e);
            }
        });
        ThreadRenamingRunnable.setThreadNameDeterminer((ThreadNameDeterminer)ThreadNameDeterminer.CURRENT);
        this.serverBootstrap = new ServerBootstrap((ChannelFactory)serverChannelFactory);
    }

    @Override
    public void start() {
        this.start(false, true);
    }

    @Override
    public void start(boolean localOnly, boolean anyAddress) {
        InetSocketAddress isa;
        this.log.info("Starting proxy on port: " + this.port);
        this.stopped.set(false);
        HttpServerPipelineFactory factory = new HttpServerPipelineFactory(this.authenticationManager, this.allChannels, this.chainProxyManager, this.handshakeHandlerFactory, new DefaultRelayPipelineFactoryFactory(this.chainProxyManager, this.responseFilters, this.requestFilter, this.allChannels, this.timer), this.timer, this.clientChannelFactory, this.cacheManager);
        this.serverBootstrap.setPipelineFactory((ChannelPipelineFactory)factory);
        if (localOnly) {
            isa = new InetSocketAddress("127.0.0.1", this.port);
        } else if (anyAddress) {
            isa = new InetSocketAddress(this.port);
        } else {
            try {
                isa = new InetSocketAddress(NetworkUtils.getLocalHost(), this.port);
            }
            catch (UnknownHostException e) {
                this.log.error("Could not get local host?", (Throwable)e);
                isa = new InetSocketAddress(this.port);
            }
        }
        Channel channel = this.serverBootstrap.bind((SocketAddress)isa);
        this.allChannels.add((Object)channel);
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                DefaultHttpProxyServer.this.stop();
            }
        }));
    }

    @Override
    public void stop() {
        this.log.info("Shutting down proxy");
        if (this.stopped.get()) {
            this.log.info("Already stopped");
            return;
        }
        this.stopped.set(true);
        this.log.info("Closing all channels...");
        ChannelGroupFuture future = this.allChannels.close();
        future.awaitUninterruptibly(10000L);
        if (!future.isCompleteSuccess()) {
            for (ChannelFuture cf : future) {
                if (cf.isSuccess()) continue;
                this.log.warn("Cause of failure for {} is {}", (Object)cf.getChannel(), (Object)cf.getCause());
            }
        }
        this.log.info("Stopping timer");
        this.timer.stop();
        this.serverChannelFactory.releaseExternalResources();
        this.clientChannelFactory.releaseExternalResources();
        this.log.info("Done shutting down proxy");
    }

    @Override
    public void addProxyAuthenticationHandler(ProxyAuthorizationHandler pah) {
        this.authenticationManager.addHandler(pah);
    }

    private static Executor newClientThreadPool() {
        return Executors.newCachedThreadPool(new ThreadFactory(){
            private int num = 0;

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "LittleProxy-NioClientSocketChannelFactory-Thread-" + this.num++);
                return t;
            }
        });
    }

    private static Executor newServerThreadPool() {
        return Executors.newCachedThreadPool(new ThreadFactory(){
            private int num = 0;

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "LittleProxy-NioServerSocketChannelFactory-Thread-" + this.num++);
                return t;
            }
        });
    }
}

