/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.proxy;

import java.lang.management.ManagementFactory;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.socket.ClientSocketChannelFactory;
import org.jboss.netty.handler.codec.http.HttpRequestDecoder;
import org.jboss.netty.handler.timeout.IdleStateHandler;
import org.jboss.netty.util.Timer;
import org.littleshoot.proxy.AllConnectionData;
import org.littleshoot.proxy.ChainProxyManager;
import org.littleshoot.proxy.HandshakeHandler;
import org.littleshoot.proxy.HandshakeHandlerFactory;
import org.littleshoot.proxy.HttpRequestHandler;
import org.littleshoot.proxy.IdleRequestHandler;
import org.littleshoot.proxy.LittleProxyConfig;
import org.littleshoot.proxy.ProxyAuthorizationManager;
import org.littleshoot.proxy.ProxyCacheManager;
import org.littleshoot.proxy.ProxyHttpResponseEncoder;
import org.littleshoot.proxy.ProxyUtils;
import org.littleshoot.proxy.RelayPipelineFactoryFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServerPipelineFactory
implements ChannelPipelineFactory,
AllConnectionData {
    private final Logger log = LoggerFactory.getLogger(HttpServerPipelineFactory.class);
    private final ProxyAuthorizationManager authenticationManager;
    private final ChannelGroup channelGroup;
    private final ChainProxyManager chainProxyManager;
    private final ProxyCacheManager cacheManager;
    private final HandshakeHandlerFactory handshakeHandlerFactory;
    private int numHandlers;
    private final RelayPipelineFactoryFactory relayPipelineFactoryFactory;
    private final Timer timer;
    private final ClientSocketChannelFactory clientChannelFactory;

    public HttpServerPipelineFactory(ProxyAuthorizationManager authorizationManager, ChannelGroup channelGroup, ChainProxyManager chainProxyManager, HandshakeHandlerFactory handshakeHandlerFactory, RelayPipelineFactoryFactory relayPipelineFactoryFactory, Timer timer, ClientSocketChannelFactory clientChannelFactory) {
        this(authorizationManager, channelGroup, chainProxyManager, handshakeHandlerFactory, relayPipelineFactoryFactory, timer, clientChannelFactory, ProxyUtils.loadCacheManager());
    }

    public HttpServerPipelineFactory(ProxyAuthorizationManager authorizationManager, ChannelGroup channelGroup, ChainProxyManager chainProxyManager, HandshakeHandlerFactory handshakeHandlerFactory, RelayPipelineFactoryFactory relayPipelineFactoryFactory, Timer timer, ClientSocketChannelFactory clientChannelFactory, ProxyCacheManager proxyCacheManager) {
        this.handshakeHandlerFactory = handshakeHandlerFactory;
        this.relayPipelineFactoryFactory = relayPipelineFactoryFactory;
        this.timer = timer;
        this.clientChannelFactory = clientChannelFactory;
        this.log.debug("Creating server with handshake handler: {}", (Object)handshakeHandlerFactory);
        this.authenticationManager = authorizationManager;
        this.channelGroup = channelGroup;
        this.chainProxyManager = chainProxyManager;
        this.cacheManager = proxyCacheManager;
        if (LittleProxyConfig.isUseJmx()) {
            this.setupJmx();
        }
    }

    private void setupJmx() {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            Class<?> clazz = this.getClass();
            String pack = clazz.getPackage().getName();
            String oName = pack + ":type=" + clazz.getSimpleName() + "-" + clazz.getSimpleName() + this.hashCode();
            this.log.debug("Registering MBean with name: {}", (Object)oName);
            ObjectName mxBeanName = new ObjectName(oName);
            if (!mbs.isRegistered(mxBeanName)) {
                mbs.registerMBean(this, mxBeanName);
            }
        }
        catch (MalformedObjectNameException e) {
            this.log.error("Could not set up JMX", (Throwable)e);
        }
        catch (InstanceAlreadyExistsException e) {
            this.log.error("Could not set up JMX", (Throwable)e);
        }
        catch (MBeanRegistrationException e) {
            this.log.error("Could not set up JMX", (Throwable)e);
        }
        catch (NotCompliantMBeanException e) {
            this.log.error("Could not set up JMX", (Throwable)e);
        }
    }

    public ChannelPipeline getPipeline() throws Exception {
        ChannelPipeline pipeline = Channels.pipeline();
        this.log.debug("Accessing pipeline");
        if (this.handshakeHandlerFactory != null) {
            this.log.debug("Adding SSL handler");
            HandshakeHandler hh = this.handshakeHandlerFactory.newHandshakeHandler();
            pipeline.addLast(hh.getId(), hh.getChannelHandler());
        }
        pipeline.addLast("decoder", (ChannelHandler)new HttpRequestDecoder(8192, 16384, 16384));
        pipeline.addLast("encoder", (ChannelHandler)new ProxyHttpResponseEncoder(this.cacheManager));
        HttpRequestHandler httpRequestHandler = new HttpRequestHandler(this.cacheManager, this.authenticationManager, this.channelGroup, this.chainProxyManager, this.relayPipelineFactoryFactory, this.clientChannelFactory);
        pipeline.addLast("idle", (ChannelHandler)new IdleStateHandler(this.timer, 0, 0, 70));
        pipeline.addLast("idleAware", (ChannelHandler)new IdleRequestHandler(httpRequestHandler));
        pipeline.addLast("handler", (ChannelHandler)httpRequestHandler);
        ++this.numHandlers;
        return pipeline;
    }

    @Override
    public int getNumRequestHandlers() {
        return this.numHandlers;
    }
}

