/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.proxy;

import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.timeout.IdleState;
import org.jboss.netty.handler.timeout.IdleStateAwareChannelHandler;
import org.jboss.netty.handler.timeout.IdleStateEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdleAwareHandler
extends IdleStateAwareChannelHandler {
    private static final Logger log = LoggerFactory.getLogger(IdleAwareHandler.class);
    private final String handlerName;

    public IdleAwareHandler(String handlerName) {
        this.handlerName = handlerName;
    }

    public void channelIdle(ChannelHandlerContext ctx, IdleStateEvent e) {
        if (e.getState() == IdleState.READER_IDLE) {
            log.info("Got reader idle -- closing -- " + (Object)((Object)this));
            e.getChannel().close();
        } else if (e.getState() == IdleState.WRITER_IDLE) {
            log.info("Got writer idle -- closing connection -- " + (Object)((Object)this));
            e.getChannel().close();
        }
    }

    public String toString() {
        return "IdleAwareHandler [handlerName=" + this.handlerName + "]";
    }
}

