/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.proxy;

import com.google.common.base.Optional;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.handler.codec.http.DefaultHttpRequest;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.util.CharsetUtil;
import org.littleshoot.proxy.HttpRequestFilter;
import org.littleshoot.proxy.LittleProxyConfig;
import org.littleshoot.proxy.NetworkUtils;
import org.littleshoot.proxy.ProxyCacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ProxyUtils.class);
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    public static final String PATTERN_RFC1123 = "EEE, dd MMM yyyy HH:mm:ss zzz";
    public static final String PATTERN_RFC1036 = "EEEE, dd-MMM-yy HH:mm:ss zzz";
    private static final Set<String> hopByHopHeaders = new HashSet<String>();
    private static final String via;
    private static final String hostName;
    public static final ChannelFutureListener NO_OP_LISTENER;
    public static final String CONNECT_OK_HEADERS;
    public static final String PROXY_ERROR_HEADERS;
    public static final HttpRequestFilter PASS_THROUGH_REQUEST_FILTER;
    private static Pattern HTTP_PREFIX;
    private static Pattern HTTPS_PREFIX;
    private static ChannelFutureListener CLOSE;

    private ProxyUtils() {
    }

    public static String stripHost(String uri) {
        if (!HTTP_PREFIX.matcher(uri).matches()) {
            return uri;
        }
        String noHttpUri = StringUtils.substringAfter((String)uri, (String)"://");
        int slashIndex = noHttpUri.indexOf("/");
        if (slashIndex == -1) {
            return "/";
        }
        String noHostUri = noHttpUri.substring(slashIndex);
        return noHostUri;
    }

    public static String cacheUri(HttpRequest httpRequest) {
        String host = httpRequest.getHeader("Host");
        String uri = httpRequest.getUri();
        String path = HTTP_PREFIX.matcher(uri).matches() ? ProxyUtils.stripHost(uri) : uri;
        return host + path;
    }

    public static String formatDate(Date date) {
        return ProxyUtils.formatDate(date, PATTERN_RFC1123);
    }

    public static String formatDate(Date date, String pattern) {
        if (date == null) {
            throw new IllegalArgumentException("date is null");
        }
        if (pattern == null) {
            throw new IllegalArgumentException("pattern is null");
        }
        SimpleDateFormat formatter = new SimpleDateFormat(pattern, Locale.US);
        formatter.setTimeZone(GMT);
        return formatter.format(date);
    }

    public static String httpDate() {
        return ProxyUtils.formatDate(new Date());
    }

    public static HttpResponse copyMutableResponseFields(HttpResponse original, HttpResponse copy) {
        Set headerNames = original.getHeaderNames();
        for (String name : headerNames) {
            List values = original.getHeaders(name);
            copy.setHeader(name, (Iterable)values);
        }
        copy.setContent(original.getContent());
        if (original.isChunked()) {
            copy.setChunked(true);
        }
        return copy;
    }

    public static void writeResponse(Channel channel, String statusLine, String headers) {
        ProxyUtils.writeResponse(channel, statusLine, headers, "");
    }

    public static void writeResponse(Channel channel, String statusLine, String headers, String responseBody) {
        String fullResponse = statusLine + headers + responseBody;
        LOG.info("Writing full response:\n" + fullResponse);
        try {
            ChannelBuffer buf = ChannelBuffers.copiedBuffer((byte[])fullResponse.getBytes("UTF-8"));
            channel.write((Object)buf);
            channel.setReadable(true);
        }
        catch (UnsupportedEncodingException e) {
            return;
        }
    }

    public static void printHeaders(HttpMessage msg) {
        String status = msg.getProtocolVersion().toString();
        LOG.debug(status);
        StringBuilder sb = new StringBuilder();
        Set headerNames = msg.getHeaderNames();
        for (String name : headerNames) {
            String value = msg.getHeader(name);
            sb.append(name);
            sb.append(": ");
            sb.append(value);
            sb.append("\n");
        }
        LOG.debug("\n" + sb.toString());
    }

    public static void printHeader(HttpMessage msg, String name) {
        String value = msg.getHeader(name);
        LOG.debug(name + ": " + value);
    }

    static boolean isLastChunk(Object msg) {
        if (msg instanceof HttpChunk) {
            HttpChunk chunk = (HttpChunk)msg;
            return chunk.isLast();
        }
        return false;
    }

    public static void closeOnFlush(Channel ch) {
        LOG.debug("Closing on flush: {}", (Object)ch);
        if (ch.isOpen()) {
            ch.write((Object)ChannelBuffers.EMPTY_BUFFER).addListener(CLOSE);
        }
    }

    public static String parseHostAndPort(HttpRequest httpRequest) {
        return ProxyUtils.parseHostAndPort(httpRequest.getUri());
    }

    public static String parseHostAndPort(String uri) {
        String tempUri = !HTTP_PREFIX.matcher(uri).matches() ? uri : StringUtils.substringAfter((String)uri, (String)"://");
        String hostAndPort = tempUri.contains("/") ? tempUri.substring(0, tempUri.indexOf("/")) : tempUri;
        return hostAndPort;
    }

    public static String parseHost(HttpRequest request) {
        String host = request.getHeader("Host");
        if (StringUtils.isNotBlank((CharSequence)host)) {
            return host;
        }
        return ProxyUtils.parseHost(request.getUri());
    }

    public static String parseHost(String request) {
        String hostAndPort = ProxyUtils.parseHostAndPort(request);
        if (hostAndPort.contains(":")) {
            return StringUtils.substringBefore((String)hostAndPort, (String)":");
        }
        return hostAndPort;
    }

    public static int parsePort(HttpRequest httpRequest) {
        String uri = httpRequest.getUri();
        if (uri.contains(":")) {
            String portStr = StringUtils.substringAfter((String)uri, (String)":");
            return Integer.parseInt(portStr);
        }
        if (HTTP_PREFIX.matcher(uri).matches()) {
            return 80;
        }
        if (HTTPS_PREFIX.matcher(uri).matches()) {
            return 443;
        }
        return 80;
    }

    public static HttpRequest copyHttpRequest(HttpRequest original, boolean keepProxyFormat) {
        DefaultHttpRequest copy;
        HttpMethod method = original.getMethod();
        String uri = original.getUri();
        LOG.info("Raw URI before switching from proxy format: {}", (Object)uri);
        if (keepProxyFormat) {
            copy = new DefaultHttpRequest(original.getProtocolVersion(), method, uri);
        } else {
            String noHostUri = ProxyUtils.stripHost(uri);
            copy = new DefaultHttpRequest(original.getProtocolVersion(), method, noHostUri);
        }
        ChannelBuffer originalContent = original.getContent();
        if (originalContent != null) {
            copy.setContent(originalContent);
        }
        LOG.debug("Request copy method: {}", (Object)copy.getMethod());
        ProxyUtils.copyHeaders((HttpMessage)original, (HttpMessage)copy);
        String ae = copy.getHeader("Accept-Encoding");
        if (StringUtils.isNotBlank((CharSequence)ae)) {
            String noSdch = ae.replace(",sdch", "").replace("sdch", "");
            copy.setHeader("Accept-Encoding", (Object)noSdch);
            LOG.debug("Removed sdch and inserted: {}", (Object)noSdch);
        }
        String proxyConnectionKey = "Proxy-Connection";
        if (copy.containsHeader("Proxy-Connection")) {
            String header = copy.getHeader("Proxy-Connection");
            copy.removeHeader("Proxy-Connection");
            copy.setHeader("Connection", (Object)header);
        }
        ProxyUtils.addVia((HttpMessage)copy);
        return copy;
    }

    private static void copyHeaders(HttpMessage original, HttpMessage copy) {
        Set headerNames = original.getHeaderNames();
        for (String name : headerNames) {
            if (hopByHopHeaders.contains(name.toLowerCase())) continue;
            List values = original.getHeaders(name);
            copy.setHeader(name, (Iterable)values);
        }
    }

    public static void stripHopByHopHeaders(HttpMessage msg) {
        Set headerNames = msg.getHeaderNames();
        for (String name : headerNames) {
            if (!hopByHopHeaders.contains(name.toLowerCase())) continue;
            msg.removeHeader(name);
        }
    }

    public static HttpRequest copyHttpRequest(HttpRequest original) {
        return ProxyUtils.copyHttpRequest(original, false);
    }

    public static void addVia(HttpMessage msg) {
        List<String> vias;
        StringBuilder sb = new StringBuilder();
        sb.append(msg.getProtocolVersion().getMajorVersion());
        sb.append(".");
        sb.append(msg.getProtocolVersion().getMinorVersion());
        sb.append(".");
        sb.append(hostName);
        if (msg.containsHeader("Via")) {
            vias = msg.getHeaders("Via");
            vias.add(sb.toString());
        } else {
            vias = Arrays.asList(sb.toString());
        }
        msg.setHeader("Via", vias);
    }

    public static Charset detectCharset(HttpResponse http) {
        String charsetName;
        String charsetName2;
        String header_pattern;
        Pattern pattern;
        Matcher matcher;
        Charset charset = null;
        Charset headerCharset = CharsetUtil.ISO_8859_1;
        if (http.getHeader("Content-Type") != null && (matcher = (pattern = Pattern.compile(header_pattern = "^\\s*?.*?\\s*?charset\\s*?=\\s*?(.*?)$", 2)).matcher(http.getHeader("Content-Type"))).find() && Charset.isSupported(charsetName2 = matcher.group(1))) {
            charset = Charset.forName(charsetName2);
            headerCharset = Charset.forName(charsetName2);
        }
        String html = http.getContent().toString(headerCharset);
        String meta_pattern = "<meta\\s+.*? content\\s*?=\\s*?\\\"\\s*?text/html;\\s*?charset\\s*?=\\s*?(.*?)\\\"\\s*?/*?>";
        Pattern pattern2 = Pattern.compile(meta_pattern, 2);
        Matcher matcher2 = pattern2.matcher(html);
        if (matcher2.find() && Charset.isSupported(charsetName = matcher2.group(1))) {
            charset = Charset.forName(charsetName);
        }
        if ((matcher2 = (pattern2 = Pattern.compile(meta_pattern = "<meta\\s+.*?charset\\s*?=\\s*?\\\"(.*?)\\\"\\s*?/*?>", 2)).matcher(html)).find() && Charset.isSupported(charsetName = matcher2.group(1))) {
            charset = Charset.forName(charsetName);
        }
        if ((matcher2 = (pattern2 = Pattern.compile(meta_pattern = "<meta\\s+.*?name=\\\"charset\\\"\\s*?content\\s*?=\\s*?\\\"(.*?)\\\"\\s*?/*?>", 2)).matcher(html)).find() && Charset.isSupported(charsetName = matcher2.group(1))) {
            charset = Charset.forName(charsetName);
        }
        return charset;
    }

    public static boolean isTrue(String val) {
        return ProxyUtils.checkTrueOrFalse(val, "true", "on");
    }

    public static boolean isFalse(String val) {
        return ProxyUtils.checkTrueOrFalse(val, "false", "off");
    }

    private static boolean checkTrueOrFalse(String val, String str1, String str2) {
        String str = val.trim();
        return StringUtils.isNotBlank((CharSequence)str) && (str.equalsIgnoreCase(str1) || str.equalsIgnoreCase(str2));
    }

    public static boolean extractBooleanDefaultFalse(Properties props, String key) {
        String throttle = props.getProperty(key);
        if (StringUtils.isNotBlank((CharSequence)throttle)) {
            return throttle.trim().equalsIgnoreCase("true");
        }
        return false;
    }

    public static long extractLong(Properties props, String key) {
        String readThrottleString = props.getProperty(key);
        if (StringUtils.isNotBlank((CharSequence)readThrottleString) && NumberUtils.isNumber((String)readThrottleString)) {
            return Long.parseLong(readThrottleString);
        }
        return -1L;
    }

    public static ProxyCacheManager loadCacheManager() {
        Optional managerClassName = Optional.fromNullable((Object)LittleProxyConfig.getProxyCacheManagerClass());
        if (managerClassName.isPresent()) {
            ProxyCacheManager configCacheManager = null;
            try {
                Class<?> managerClass = Class.forName((String)managerClassName.get());
                configCacheManager = (ProxyCacheManager)managerClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Failed to find class: " + (String)managerClassName.get(), e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException("Failed to create instance of ProxyCacheManager: " + (String)managerClassName.get(), e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Failed to create instance of ProxyCacheManager: " + (String)managerClassName.get(), e);
            }
            return configCacheManager;
        }
        return new ProxyCacheManager(){

            @Override
            public boolean returnCacheHit(HttpRequest request, Channel channel) {
                return false;
            }

            @Override
            public Future<String> cache(HttpRequest originalRequest, HttpResponse httpResponse, Object response, ChannelBuffer encoded) {
                return null;
            }
        };
    }

    static {
        try {
            InetAddress localAddress = NetworkUtils.getLocalHost();
            hostName = localAddress.getHostName();
        }
        catch (UnknownHostException e) {
            LOG.error("Could not lookup host", (Throwable)e);
            throw new IllegalStateException("Could not determine host!", e);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Via: 1.1 ");
        sb.append(hostName);
        sb.append("\r\n");
        via = LittleProxyConfig.isTransparent() ? "" : sb.toString();
        hopByHopHeaders.add("connection");
        hopByHopHeaders.add("keep-alive");
        hopByHopHeaders.add("proxy-authenticate");
        hopByHopHeaders.add("proxy-authorization");
        hopByHopHeaders.add("te");
        hopByHopHeaders.add("trailers");
        hopByHopHeaders.add("upgrade");
        NO_OP_LISTENER = new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                LOG.info("No op listener - write finished");
            }
        };
        CONNECT_OK_HEADERS = "Connection: Keep-Alive\r\nProxy-Connection: Keep-Alive\r\n" + via + "\r\n";
        PROXY_ERROR_HEADERS = "Connection: close\r\nProxy-Connection: close\r\nPragma: no-cache\r\nCache-Control: no-cache\r\n" + via + "\r\n";
        PASS_THROUGH_REQUEST_FILTER = new HttpRequestFilter(){

            @Override
            public void filter(HttpRequest httpRequest) {
            }
        };
        HTTP_PREFIX = Pattern.compile("http.*", 2);
        HTTPS_PREFIX = Pattern.compile("https.*", 2);
        CLOSE = new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) {
                Channel ch = future.getChannel();
                if (ch.isOpen()) {
                    ch.close();
                }
            }
        };
    }
}

