/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.proxy;

import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.handler.codec.http.HttpChunkAggregator;
import org.jboss.netty.handler.codec.http.HttpContentDecompressor;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponseDecoder;
import org.jboss.netty.handler.timeout.IdleStateHandler;
import org.jboss.netty.util.Timer;
import org.littleshoot.proxy.ChainProxyManager;
import org.littleshoot.proxy.HttpFilter;
import org.littleshoot.proxy.HttpRelayingHandler;
import org.littleshoot.proxy.HttpRequestFilter;
import org.littleshoot.proxy.HttpResponseFilters;
import org.littleshoot.proxy.IdleAwareHandler;
import org.littleshoot.proxy.ProxyHttpRequestEncoder;
import org.littleshoot.proxy.RelayListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRelayPipelineFactory
implements ChannelPipelineFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultRelayPipelineFactory.class);
    private final String hostAndPort;
    private final HttpRequest httpRequest;
    private final RelayListener relayListener;
    private final Channel browserToProxyChannel;
    private final ChannelGroup channelGroup;
    private final HttpRequestFilter requestFilter;
    private final ChainProxyManager chainProxyManager;
    private final boolean filtersOff;
    private final HttpResponseFilters responseFilters;
    private final Timer timer;

    public DefaultRelayPipelineFactory(String hostAndPort, HttpRequest httpRequest, RelayListener relayListener, Channel browserToProxyChannel, ChannelGroup channelGroup, HttpResponseFilters responseFilters, HttpRequestFilter requestFilter, ChainProxyManager chainProxyManager, Timer timer) {
        this.hostAndPort = hostAndPort;
        this.httpRequest = httpRequest;
        this.relayListener = relayListener;
        this.browserToProxyChannel = browserToProxyChannel;
        this.channelGroup = channelGroup;
        this.responseFilters = responseFilters;
        this.requestFilter = requestFilter;
        this.chainProxyManager = chainProxyManager;
        this.timer = timer;
        this.filtersOff = responseFilters == null;
    }

    public ChannelPipeline getPipeline() throws Exception {
        HttpRelayingHandler handler;
        HttpFilter filter;
        boolean shouldFilter;
        ChannelPipeline pipeline = Channels.pipeline();
        HttpResponseDecoder decoder = this.httpRequest.getMethod() == HttpMethod.HEAD ? new HttpResponseDecoder(8192, 16384, 16384){

            protected boolean isContentAlwaysEmpty(HttpMessage msg) {
                return true;
            }
        } : new HttpResponseDecoder(8192, 16384, 16384);
        pipeline.addLast("decoder", (ChannelHandler)decoder);
        LOG.debug("Querying for host and port: {}", (Object)this.hostAndPort);
        if (this.filtersOff) {
            shouldFilter = false;
            filter = null;
        } else {
            filter = this.responseFilters.getFilter(this.hostAndPort);
            if (filter == null) {
                LOG.info("No filter found");
                shouldFilter = false;
            } else {
                LOG.debug("Using filter: {}", (Object)filter);
                shouldFilter = filter.filterResponses(this.httpRequest);
                if (shouldFilter) {
                    pipeline.addLast("inflater", (ChannelHandler)new HttpContentDecompressor());
                    pipeline.addLast("aggregator", (ChannelHandler)new HttpChunkAggregator(filter.getMaxResponseSize()));
                }
            }
            LOG.debug("Filtering: " + shouldFilter);
        }
        if (shouldFilter) {
            LOG.info("Creating relay handler with filter");
            handler = new HttpRelayingHandler(this.browserToProxyChannel, this.channelGroup, filter, this.relayListener, this.hostAndPort);
        } else {
            LOG.info("Creating non-filtering relay handler");
            handler = new HttpRelayingHandler(this.browserToProxyChannel, this.channelGroup, this.relayListener, this.hostAndPort);
        }
        ProxyHttpRequestEncoder encoder = new ProxyHttpRequestEncoder(handler, this.requestFilter, this.chainProxyManager != null && this.chainProxyManager.getChainProxy(this.httpRequest) != null);
        pipeline.addLast("encoder", (ChannelHandler)encoder);
        HttpMethod method = this.httpRequest.getMethod();
        if (!method.equals((Object)HttpMethod.CONNECT)) {
            int writeTimeoutSeconds;
            int readTimeoutSeconds;
            if (method.equals((Object)HttpMethod.POST) || method.equals((Object)HttpMethod.PUT)) {
                readTimeoutSeconds = 0;
                writeTimeoutSeconds = 70;
            } else {
                readTimeoutSeconds = 70;
                writeTimeoutSeconds = 0;
            }
            pipeline.addLast("idle", (ChannelHandler)new IdleStateHandler(this.timer, readTimeoutSeconds, writeTimeoutSeconds, 0));
            pipeline.addLast("idleAware", (ChannelHandler)new IdleAwareHandler("Relay-Handler"));
        }
        pipeline.addLast("handler", (ChannelHandler)handler);
        return pipeline;
    }
}

