/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.proxy;

import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.util.Timer;
import org.littleshoot.proxy.ChainProxyManager;
import org.littleshoot.proxy.DefaultRelayPipelineFactory;
import org.littleshoot.proxy.HttpRequestFilter;
import org.littleshoot.proxy.HttpResponseFilters;
import org.littleshoot.proxy.ProxyUtils;
import org.littleshoot.proxy.RelayListener;
import org.littleshoot.proxy.RelayPipelineFactoryFactory;

public class DefaultRelayPipelineFactoryFactory
implements RelayPipelineFactoryFactory {
    private final ChainProxyManager chainProxyManager;
    private final ChannelGroup channelGroup;
    private final HttpRequestFilter requestFilter;
    private final HttpResponseFilters responseFilters;
    private final Timer timer;

    public DefaultRelayPipelineFactoryFactory(ChainProxyManager chainProxyManager, HttpResponseFilters responseFilters, HttpRequestFilter requestFilter, ChannelGroup channelGroup, Timer timer) {
        this.chainProxyManager = chainProxyManager;
        this.responseFilters = responseFilters;
        this.channelGroup = channelGroup;
        this.requestFilter = requestFilter;
        this.timer = timer;
    }

    @Override
    public ChannelPipelineFactory getRelayPipelineFactory(HttpRequest httpRequest, Channel browserToProxyChannel, RelayListener relayListener) {
        String hostAndPort;
        String string = hostAndPort = this.chainProxyManager == null ? null : this.chainProxyManager.getChainProxy(httpRequest);
        if (hostAndPort == null) {
            hostAndPort = ProxyUtils.parseHostAndPort(httpRequest);
        }
        return new DefaultRelayPipelineFactory(hostAndPort, httpRequest, relayListener, browserToProxyChannel, this.channelGroup, this.responseFilters, this.requestFilter, this.chainProxyManager, this.timer);
    }
}

