/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.proxy;

import java.util.LinkedList;
import java.util.Queue;
import org.apache.commons.lang3.StringUtils;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.littleshoot.proxy.HttpFilter;
import org.littleshoot.proxy.InterestOpsListener;
import org.littleshoot.proxy.NoOpHttpFilter;
import org.littleshoot.proxy.ProxyHttpResponse;
import org.littleshoot.proxy.ProxyUtils;
import org.littleshoot.proxy.RelayListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRelayingHandler
extends SimpleChannelUpstreamHandler
implements InterestOpsListener {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private volatile boolean readingChunks;
    private final Channel browserToProxyChannel;
    private final ChannelGroup channelGroup;
    private final HttpFilter httpFilter;
    private HttpResponse originalHttpResponse;
    private HttpRequest currentHttpRequest;
    private final RelayListener relayListener;
    private final String hostAndPort;
    private boolean closeEndsResponseBody;
    private Channel channel;
    private final Object trafficLock = new Object();
    private final Queue<HttpRequest> requestQueue = new LinkedList<HttpRequest>();

    public HttpRelayingHandler(Channel browserToProxyChannel, ChannelGroup channelGroup, RelayListener relayListener, String hostAndPort) {
        this(browserToProxyChannel, channelGroup, new NoOpHttpFilter(), relayListener, hostAndPort);
    }

    public HttpRelayingHandler(Channel browserToProxyChannel, ChannelGroup channelGroup, HttpFilter filter, RelayListener relayListener, String hostAndPort) {
        this.browserToProxyChannel = browserToProxyChannel;
        this.channelGroup = channelGroup;
        this.httpFilter = filter;
        this.relayListener = relayListener;
        this.hostAndPort = hostAndPort;
        relayListener.addInterestOpsListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(ChannelHandlerContext ctx, final MessageEvent me) throws Exception {
        HttpChunk messageToWrite;
        boolean writeEndBuffer;
        if (!this.readingChunks) {
            HttpResponse response;
            HttpResponse hr = (HttpResponse)me.getMessage();
            this.log.debug("Received raw response: {}", (Object)hr);
            this.originalHttpResponse = ProxyUtils.copyMutableResponseFields(hr, (HttpResponse)new DefaultHttpResponse(hr.getProtocolVersion(), hr.getStatus()));
            String te = hr.getHeader("Transfer-Encoding");
            if (StringUtils.isNotBlank((CharSequence)te) && te.equalsIgnoreCase("chunked")) {
                if (hr.getProtocolVersion() != HttpVersion.HTTP_1_1) {
                    this.log.warn("Fixing HTTP version.");
                    response = ProxyUtils.copyMutableResponseFields(hr, (HttpResponse)new DefaultHttpResponse(HttpVersion.HTTP_1_1, hr.getStatus()));
                    if (!response.containsHeader("Transfer-Encoding")) {
                        this.log.debug("Adding chunked encoding header");
                        response.addHeader("Transfer-Encoding", (Object)"chunked");
                    }
                } else {
                    response = hr;
                }
            } else {
                response = hr;
            }
            if (response.isChunked()) {
                this.log.debug("Starting to read chunks");
                this.readingChunks = true;
                writeEndBuffer = false;
            } else {
                writeEndBuffer = true;
            }
            if (!this.requestQueue.isEmpty()) {
                this.currentHttpRequest = this.requestQueue.remove();
                if (this.currentHttpRequest == null) {
                    this.log.warn("Got null HTTP request object.");
                }
            } else {
                this.log.debug("Request queue is empty!");
            }
            messageToWrite = this.httpFilter.filterResponse(this.currentHttpRequest, response);
        } else {
            this.log.debug("Processing a chunk");
            HttpChunk chunk = (HttpChunk)me.getMessage();
            if (chunk.isLast()) {
                this.readingChunks = false;
                writeEndBuffer = true;
            } else {
                writeEndBuffer = false;
            }
            messageToWrite = chunk;
        }
        if (this.browserToProxyChannel.isConnected()) {
            boolean closeRemote = this.shouldCloseRemoteConnection(this.currentHttpRequest, this.originalHttpResponse, messageToWrite);
            boolean closePending = this.shouldCloseBrowserConnection(this.currentHttpRequest, this.originalHttpResponse, messageToWrite);
            boolean wroteFullResponse = this.wroteFullResponse(this.originalHttpResponse, messageToWrite);
            if (closeRemote && this.closeEndsResponseBody(this.originalHttpResponse)) {
                this.closeEndsResponseBody = true;
            }
            ChannelFuture future = this.browserToProxyChannel.write((Object)new ProxyHttpResponse(this.currentHttpRequest, this.originalHttpResponse, messageToWrite));
            if (writeEndBuffer) {
                future = this.browserToProxyChannel.write((Object)ChannelBuffers.EMPTY_BUFFER);
            }
            Object object = this.trafficLock;
            synchronized (object) {
                if (!this.browserToProxyChannel.isWritable()) {
                    this.log.debug("SETTING UNREADABLE!!");
                    me.getChannel().setReadable(false);
                }
            }
            if (wroteFullResponse) {
                this.log.debug("Notifying request handler of completed response.");
                future.addListener(new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture cf) throws Exception {
                        HttpRelayingHandler.this.relayListener.onRelayHttpResponse(HttpRelayingHandler.this.browserToProxyChannel, HttpRelayingHandler.this.hostAndPort, HttpRelayingHandler.this.currentHttpRequest);
                    }
                });
            }
            if (closeRemote) {
                this.log.debug("Closing remote connection after writing to browser");
                future.addListener(new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture cf) throws Exception {
                        if (me.getChannel().isConnected()) {
                            me.getChannel().close();
                        }
                    }
                });
            }
            if (closePending) {
                this.log.debug("Closing connection to browser after writes");
                future.addListener(new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture cf) throws Exception {
                        HttpRelayingHandler.this.log.info("Closing browser connection on flush!!");
                        ProxyUtils.closeOnFlush(HttpRelayingHandler.this.browserToProxyChannel);
                    }
                });
            }
            if (wroteFullResponse && !closePending && !closeRemote) {
                this.log.debug("Making remote channel available for requests");
                this.relayListener.onChannelAvailable(this.hostAndPort, Channels.succeededFuture((Channel)me.getChannel()));
            }
        } else {
            this.log.debug("Channel not open. Connected? {}", (Object)this.browserToProxyChannel.isConnected());
            if (me.getChannel().isConnected()) {
                this.log.debug("Closing channel to remote server -- received a response after the browser connection is closed? Current request:\n{}\nResponse:\n{}", (Object)this.currentHttpRequest, me.getMessage());
                me.getChannel().close();
            }
        }
        this.log.debug("Finished processing message");
    }

    public void channelInterestChanged(ChannelHandlerContext ctx, ChannelStateEvent cse) throws Exception {
        this.log.debug("OPS CHANGED!!");
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.log.debug("CHANNEL CONNECTED!!");
        this.channel = ctx.getChannel();
    }

    private boolean closeEndsResponseBody(HttpResponse res) {
        String cl = res.getHeader("Content-Length");
        if (StringUtils.isNotBlank((CharSequence)cl)) {
            return false;
        }
        String te = res.getHeader("Transfer-Encoding");
        return !StringUtils.isNotBlank((CharSequence)te) || !te.equalsIgnoreCase("chunked");
    }

    private boolean wroteFullResponse(HttpResponse res, Object messageToWrite) {
        if (res.isChunked()) {
            if (messageToWrite instanceof HttpResponse) {
                return false;
            }
            return ProxyUtils.isLastChunk(messageToWrite);
        }
        return true;
    }

    private boolean shouldCloseBrowserConnection(HttpRequest req, HttpResponse res, Object msg) {
        if (res.isChunked() && msg != null) {
            if (!ProxyUtils.isLastChunk(msg)) {
                this.log.debug("Not closing on middle chunk for {}", (Object)req.getUri());
                return false;
            }
            this.log.debug("Last chunk...using normal closing rules");
        }
        String proxyConnectionKey = "Proxy-Connection";
        if (req.containsHeader("Proxy-Connection")) {
            String header = req.getHeader("Proxy-Connection");
            req.removeHeader("Proxy-Connection");
            if (req.getProtocolVersion() == HttpVersion.HTTP_1_1) {
                this.log.debug("Switching Proxy-Connection to Connection for analyzing request for close");
                req.setHeader("Connection", (Object)header);
            }
        }
        if (!HttpHeaders.isKeepAlive((HttpMessage)req)) {
            this.log.debug("Closing since request is not keep alive:");
            return true;
        }
        this.log.debug("Not closing browser/client to proxy connection for request: {}", (Object)req);
        return false;
    }

    private boolean shouldCloseRemoteConnection(HttpRequest req, HttpResponse res, Object msg) {
        if (res.isChunked() && msg != null) {
            if (!ProxyUtils.isLastChunk(msg)) {
                this.log.debug("Not closing on middle chunk");
                return false;
            }
            this.log.debug("Last chunk...using normal closing rules");
        }
        if (!HttpHeaders.isKeepAlive((HttpMessage)req)) {
            this.log.debug("Closing since request is not keep alive:{}, ", (Object)req);
            return true;
        }
        if (!HttpHeaders.isKeepAlive((HttpMessage)res)) {
            this.log.debug("Closing since response is not keep alive:{}", (Object)res);
            return true;
        }
        this.log.debug("Not closing -- response probably keep alive for:\n{}", (Object)res);
        return false;
    }

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent cse) throws Exception {
        Channel ch = cse.getChannel();
        this.log.debug("New channel opened from proxy to web: {}", (Object)ch);
        if (this.channelGroup != null) {
            this.channelGroup.add((Object)ch);
        }
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.log.debug("Got closed event on proxy -> web connection: {}", (Object)e.getChannel());
        int unansweredRequests = this.requestQueue.size();
        this.log.debug("Unanswered requests: {}", (Object)unansweredRequests);
        this.relayListener.onRelayChannelClose(this.browserToProxyChannel, this.hostAndPort, unansweredRequests, this.closeEndsResponseBody);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        String msg;
        Throwable cause = e.getCause();
        String message = "Caught exception on proxy -> web connection: " + e.getChannel();
        boolean warn = cause != null ? (msg = cause.getMessage()) == null || !msg.contains("Connection reset by peer") : true;
        if (warn) {
            this.log.warn(message, cause);
        } else {
            this.log.debug(message, cause);
        }
        if (e.getChannel().isConnected()) {
            if (warn) {
                this.log.warn("Closing open connection");
            } else {
                this.log.debug("Closing open connection");
            }
            ProxyUtils.closeOnFlush(e.getChannel());
        }
    }

    public void requestEncoded(HttpRequest request) {
        this.requestQueue.add(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelWritable(ChannelHandlerContext ctx, ChannelStateEvent cse) {
        Object object = this.trafficLock;
        synchronized (object) {
            if (cse.getChannel().isWritable() && this.channel != null) {
                this.channel.setReadable(true);
            }
        }
    }
}

