/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.proxy;

import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.apache.commons.lang3.StringUtils;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.socket.ClientSocketChannelFactory;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpRequestEncoder;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.littleshoot.dnssec4j.VerifiedAddressFactory;
import org.littleshoot.proxy.ChainProxyManager;
import org.littleshoot.proxy.ConnectionData;
import org.littleshoot.proxy.HttpConnectRelayingHandler;
import org.littleshoot.proxy.InterestOpsListener;
import org.littleshoot.proxy.LittleProxyConfig;
import org.littleshoot.proxy.ProxyAuthorizationManager;
import org.littleshoot.proxy.ProxyCacheManager;
import org.littleshoot.proxy.ProxyUtils;
import org.littleshoot.proxy.RelayListener;
import org.littleshoot.proxy.RelayPipelineFactoryFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestHandler
extends SimpleChannelUpstreamHandler
implements RelayListener,
ConnectionData {
    private static final Logger log = LoggerFactory.getLogger(HttpRequestHandler.class);
    private volatile boolean readingChunks;
    private static final AtomicInteger totalBrowserToProxyConnections = new AtomicInteger(0);
    private final AtomicInteger browserToProxyConnections = new AtomicInteger(0);
    private final Map<String, Queue<ChannelFuture>> externalHostsToChannelFutures = new ConcurrentHashMap<String, Queue<ChannelFuture>>();
    private final AtomicInteger messagesReceived = new AtomicInteger(0);
    private final AtomicInteger unansweredRequestCount = new AtomicInteger(0);
    private final AtomicInteger requestsSent = new AtomicInteger(0);
    private final AtomicInteger responsesReceived = new AtomicInteger(0);
    private final ProxyAuthorizationManager authorizationManager;
    private final Set<String> answeredRequests = new HashSet<String>();
    private final Set<String> unansweredRequests = new HashSet<String>();
    private final Set<HttpRequest> unansweredHttpRequests = new HashSet<HttpRequest>();
    private ChannelFuture currentChannelFuture;
    private final Set<ChannelFuture> allChannelFutures = Collections.synchronizedSet(new HashSet());
    private final Object channelFutureLock = new Object();
    private final ChainProxyManager chainProxyManager;
    private final ChannelGroup channelGroup;
    private final ProxyCacheManager cacheManager;
    private final AtomicBoolean browserChannelClosed = new AtomicBoolean(false);
    private volatile boolean receivedChannelClosed = false;
    private final RelayPipelineFactoryFactory relayPipelineFactoryFactory;
    private ClientSocketChannelFactory clientChannelFactory;
    private boolean pendingRequestChunks = false;
    private ObjectName mxBeanName;
    private final Set<InterestOpsListener> interestOpsListeners = Collections.synchronizedSet(new HashSet());

    public HttpRequestHandler(RelayPipelineFactoryFactory relayPipelineFactoryFactory, ClientSocketChannelFactory clientChannelFactory) {
        this(null, null, null, null, relayPipelineFactoryFactory, clientChannelFactory);
    }

    public HttpRequestHandler(ProxyCacheManager cacheManager, ProxyAuthorizationManager authorizationManager, ChannelGroup channelGroup, RelayPipelineFactoryFactory relayPipelineFactoryFactory, ClientSocketChannelFactory clientChannelFactory) {
        this(cacheManager, authorizationManager, channelGroup, null, relayPipelineFactoryFactory, clientChannelFactory);
    }

    public HttpRequestHandler(ProxyCacheManager cacheManager, ProxyAuthorizationManager authorizationManager, ChannelGroup channelGroup, ChainProxyManager chainProxyManager, RelayPipelineFactoryFactory relayPipelineFactoryFactory, ClientSocketChannelFactory clientChannelFactory) {
        log.info("Creating new request handler...");
        this.clientChannelFactory = clientChannelFactory;
        this.cacheManager = cacheManager;
        this.authorizationManager = authorizationManager;
        this.channelGroup = channelGroup;
        this.chainProxyManager = chainProxyManager;
        this.relayPipelineFactoryFactory = relayPipelineFactoryFactory;
        if (LittleProxyConfig.isUseJmx()) {
            this.setupJmx();
        }
    }

    private void setupJmx() {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            Class<?> clazz = this.getClass();
            String pack = clazz.getPackage().getName();
            String oName = pack + ":type=" + clazz.getSimpleName() + "-" + clazz.getSimpleName() + "-" + this.hashCode();
            log.info("Registering MBean with name: {}", (Object)oName);
            this.mxBeanName = new ObjectName(oName);
            if (!mbs.isRegistered(this.mxBeanName)) {
                mbs.registerMBean(this, this.mxBeanName);
            }
        }
        catch (MalformedObjectNameException e) {
            log.error("Could not set up JMX", (Throwable)e);
        }
        catch (InstanceAlreadyExistsException e) {
            log.error("Could not set up JMX", (Throwable)e);
        }
        catch (MBeanRegistrationException e) {
            log.error("Could not set up JMX", (Throwable)e);
        }
        catch (NotCompliantMBeanException e) {
            log.error("Could not set up JMX", (Throwable)e);
        }
    }

    protected void cleanupJmx() {
        if (this.mxBeanName == null) {
            log.debug("JMX not setup");
            return;
        }
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            mbs.unregisterMBean(this.mxBeanName);
        }
        catch (MBeanRegistrationException e) {
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            // empty catch block
        }
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent me) {
        if (this.browserChannelClosed.get()) {
            log.info("Ignoring message since the connection to the browser is about to close");
            return;
        }
        this.messagesReceived.incrementAndGet();
        log.debug("Received " + this.messagesReceived + " total messages");
        if (!this.readingChunks) {
            this.processRequest(ctx, me);
        } else {
            this.processChunk(me);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processChunk(MessageEvent me) {
        log.info("Processing chunk...");
        final HttpChunk chunk = (HttpChunk)me.getMessage();
        if (chunk.isLast()) {
            this.readingChunks = false;
        }
        if (this.currentChannelFuture == null) {
            if (this.pendingRequestChunks) {
                if (chunk.isLast()) {
                    log.info("Received last chunk -- setting proxy auth chunking to false");
                    this.pendingRequestChunks = false;
                }
                log.info("Ignoring chunk with chunked post for edge case");
                return;
            }
            log.error("NO CHANNEL FUTURE!!");
            Object object = this.channelFutureLock;
            synchronized (object) {
                if (this.currentChannelFuture == null) {
                    try {
                        log.debug("Waiting for channel future!");
                        this.channelFutureLock.wait(4000L);
                    }
                    catch (InterruptedException e) {
                        log.info("Interrupted!!", (Throwable)e);
                    }
                }
            }
        }
        if (this.currentChannelFuture.getChannel().isConnected()) {
            this.currentChannelFuture.getChannel().write((Object)chunk);
        } else {
            this.currentChannelFuture.addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    HttpRequestHandler.this.currentChannelFuture.getChannel().write((Object)chunk);
                }
            });
        }
    }

    private void processRequest(final ChannelHandlerContext ctx, final MessageEvent me) {
        final HttpRequest request = (HttpRequest)me.getMessage();
        final Channel inboundChannel = me.getChannel();
        if (this.cacheManager != null && this.cacheManager.returnCacheHit((HttpRequest)me.getMessage(), inboundChannel)) {
            log.debug("Found cache hit! Cache wrote the response.");
            return;
        }
        this.unansweredRequestCount.incrementAndGet();
        log.debug("Got request: {} on channel: " + inboundChannel, (Object)request);
        if (this.authorizationManager != null && !this.authorizationManager.handleProxyAuthorization(request, ctx)) {
            log.debug("Not authorized!!");
            this.handleFutureChunksIfNecessary(request);
            return;
        }
        this.pendingRequestChunks = false;
        String hostAndPort = null;
        if (this.chainProxyManager != null) {
            hostAndPort = this.chainProxyManager.getChainProxy(request);
        }
        if (hostAndPort == null && StringUtils.isBlank((CharSequence)(hostAndPort = ProxyUtils.parseHostAndPort(request)))) {
            List hosts = request.getHeaders("Host");
            if (hosts != null && !hosts.isEmpty()) {
                hostAndPort = (String)hosts.get(0);
            } else {
                log.warn("No host and port found in {}", (Object)request.getUri());
                this.badGateway(request, inboundChannel);
                this.handleFutureChunksIfNecessary(request);
                return;
            }
        }
        final class OnConnect {
            OnConnect() {
            }

            public ChannelFuture onConnect(ChannelFuture cf) {
                if (request.getMethod() != HttpMethod.CONNECT) {
                    ChannelFuture writeFuture = cf.getChannel().write((Object)request);
                    writeFuture.addListener(new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture future) throws Exception {
                            if (LittleProxyConfig.isUseJmx()) {
                                HttpRequestHandler.this.unansweredRequests.add(request.toString());
                            }
                            HttpRequestHandler.this.unansweredHttpRequests.add(request);
                            HttpRequestHandler.this.requestsSent.incrementAndGet();
                        }
                    });
                    return writeFuture;
                }
                HttpRequestHandler.this.writeConnectResponse(ctx, request, cf.getChannel());
                return cf;
            }
        }
        final OnConnect onConnect = new OnConnect();
        final ChannelFuture curFuture = this.getChannelFuture(hostAndPort);
        if (curFuture != null) {
            log.debug("Using existing connection...");
            if (this.currentChannelFuture == null) {
                log.error("Should not be null here");
            }
            this.currentChannelFuture = curFuture;
            if (curFuture.getChannel().isConnected()) {
                onConnect.onConnect(curFuture);
            } else {
                ChannelFutureListener cfl = new ChannelFutureListener(){
                    {
                    }

                    public void operationComplete(ChannelFuture future) throws Exception {
                        onConnect.onConnect(curFuture);
                    }
                };
                curFuture.addListener(cfl);
            }
        } else {
            ChannelFuture cf;
            log.debug("Establishing new connection");
            ctx.getChannel().setReadable(false);
            try {
                cf = this.newChannelFuture(request, inboundChannel, hostAndPort);
            }
            catch (UnknownHostException e) {
                log.warn("Could not resolve host?", (Throwable)e);
                this.badGateway(request, inboundChannel);
                this.handleFutureChunksIfNecessary(request);
                ctx.getChannel().setReadable(true);
                return;
            }
            final class LocalChannelFutureListener
            implements ChannelFutureListener {
                private final String copiedHostAndPort;

                LocalChannelFutureListener(String copiedHostAndPort) {
                    this.copiedHostAndPort = copiedHostAndPort;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void operationComplete(ChannelFuture future) throws Exception {
                    final Channel channel = future.getChannel();
                    if (HttpRequestHandler.this.channelGroup != null) {
                        HttpRequestHandler.this.channelGroup.add((Object)channel);
                    }
                    if (future.isSuccess()) {
                        log.debug("Connected successfully to: {}", (Object)channel);
                        log.debug("Writing message on channel...");
                        ChannelFuture wf = onConnect.onConnect(cf);
                        wf.addListener(new ChannelFutureListener(){

                            public void operationComplete(ChannelFuture wcf) throws Exception {
                                log.debug("Finished write: " + wcf + " to: " + request.getMethod() + " " + request.getUri());
                                ctx.getChannel().setReadable(true);
                                log.debug("Channel is readable: {}", (Object)channel.isReadable());
                            }
                        });
                        HttpRequestHandler.this.currentChannelFuture = wf;
                        Object object = HttpRequestHandler.this.channelFutureLock;
                        synchronized (object) {
                            HttpRequestHandler.this.channelFutureLock.notifyAll();
                        }
                    } else {
                        String nextHostAndPort;
                        log.debug("Could not connect to " + this.copiedHostAndPort, future.getCause());
                        if (HttpRequestHandler.this.chainProxyManager == null) {
                            nextHostAndPort = this.copiedHostAndPort;
                        } else {
                            HttpRequestHandler.this.chainProxyManager.onCommunicationError(this.copiedHostAndPort);
                            nextHostAndPort = HttpRequestHandler.this.chainProxyManager.getChainProxy(request);
                        }
                        if (this.copiedHostAndPort.equals(nextHostAndPort)) {
                            HttpRequestHandler.this.onRelayChannelClose(inboundChannel, this.copiedHostAndPort, 1, true);
                        } else {
                            HttpRequestHandler.this.removeProxyToWebConnection(this.copiedHostAndPort);
                            HttpRequestHandler.this.processRequest(ctx, me);
                        }
                    }
                    if (LittleProxyConfig.isUseJmx()) {
                        HttpRequestHandler.this.cleanupJmx();
                    }
                }
            }
            cf.addListener((ChannelFutureListener)new LocalChannelFutureListener(hostAndPort));
        }
        if (request.isChunked()) {
            this.readingChunks = true;
        }
    }

    private void badGateway(HttpRequest request, Channel inboundChannel) {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_GATEWAY);
        response.setHeader("Connection", (Object)"close");
        String body = "Bad Gateway: " + request.getUri();
        response.setContent(ChannelBuffers.copiedBuffer((CharSequence)body, (Charset)Charset.forName("UTF-8")));
        response.setHeader("Content-Length", (Object)body.length());
        inboundChannel.write((Object)response);
    }

    private void handleFutureChunksIfNecessary(HttpRequest request) {
        if (request.isChunked()) {
            this.pendingRequestChunks = true;
            this.readingChunks = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onChannelAvailable(String hostAndPortKey, ChannelFuture cf) {
        Map<String, Queue<ChannelFuture>> map = this.externalHostsToChannelFutures;
        synchronized (map) {
            Queue<ChannelFuture> toUse;
            Queue<ChannelFuture> futures = this.externalHostsToChannelFutures.get(hostAndPortKey);
            if (futures == null) {
                toUse = new LinkedList<ChannelFuture>();
                this.externalHostsToChannelFutures.put(hostAndPortKey, toUse);
            } else {
                toUse = futures;
            }
            toUse.add(cf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChannelFuture getChannelFuture(String hostAndPort) {
        Map<String, Queue<ChannelFuture>> map = this.externalHostsToChannelFutures;
        synchronized (map) {
            Queue<ChannelFuture> futures = this.externalHostsToChannelFutures.get(hostAndPort);
            if (futures == null) {
                return null;
            }
            if (futures.isEmpty()) {
                return null;
            }
            ChannelFuture cf = futures.remove();
            if (cf != null && cf.isSuccess() && !cf.getChannel().isConnected()) {
                this.removeProxyToWebConnection(hostAndPort);
                return null;
            }
            return cf;
        }
    }

    private void writeConnectResponse(ChannelHandlerContext ctx, HttpRequest httpRequest, final Channel outgoingChannel) {
        int port = ProxyUtils.parsePort(httpRequest);
        Channel browserToProxyChannel = ctx.getChannel();
        if (port != 443) {
            log.warn("Connecting on port other than 443: " + httpRequest.getUri());
        }
        if (port < 0) {
            log.warn("Connecting on port other than 443!!");
            String statusLine = "HTTP/1.1 502 Proxy Error\r\n";
            ProxyUtils.writeResponse(browserToProxyChannel, "HTTP/1.1 502 Proxy Error\r\n", ProxyUtils.PROXY_ERROR_HEADERS);
            ProxyUtils.closeOnFlush(browserToProxyChannel);
        } else {
            browserToProxyChannel.setReadable(false);
            ctx.getPipeline().remove("encoder");
            ctx.getPipeline().remove("decoder");
            ctx.getPipeline().remove("handler");
            ctx.getPipeline().addLast("handler", (ChannelHandler)new HttpConnectRelayingHandler(outgoingChannel, this.channelGroup));
        }
        log.debug("Sending response to CONNECT request...");
        String chainProxy = null;
        if (this.chainProxyManager != null && (chainProxy = this.chainProxyManager.getChainProxy(httpRequest)) != null) {
            outgoingChannel.getPipeline().addBefore("handler", "encoder", (ChannelHandler)new HttpRequestEncoder());
            outgoingChannel.write((Object)httpRequest).addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    outgoingChannel.getPipeline().remove("encoder");
                }
            });
        }
        if (chainProxy == null) {
            String statusLine = "HTTP/1.1 200 Connection established\r\n";
            ProxyUtils.writeResponse(browserToProxyChannel, "HTTP/1.1 200 Connection established\r\n", ProxyUtils.CONNECT_OK_HEADERS);
        }
        browserToProxyChannel.setReadable(true);
    }

    private ChannelFuture newChannelFuture(HttpRequest httpRequest, final Channel browserToProxyChannel, String hostAndPort) throws UnknownHostException {
        ChannelFuture cf;
        int port;
        String host;
        if (hostAndPort.contains(":")) {
            host = StringUtils.substringBefore((String)hostAndPort, (String)":");
            String portString = StringUtils.substringAfter((String)hostAndPort, (String)":");
            port = Integer.parseInt(portString);
        } else {
            host = hostAndPort;
            port = 80;
        }
        ClientBootstrap cb = new ClientBootstrap((ChannelFactory)this.clientChannelFactory);
        ChannelPipelineFactory cpf = httpRequest.getMethod() == HttpMethod.CONNECT ? new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline pipeline = Channels.pipeline();
                pipeline.addLast("handler", (ChannelHandler)new HttpConnectRelayingHandler(browserToProxyChannel, HttpRequestHandler.this.channelGroup));
                return pipeline;
            }
        } : this.relayPipelineFactoryFactory.getRelayPipelineFactory(httpRequest, browserToProxyChannel, this);
        cb.setPipelineFactory(cpf);
        cb.setOption("connectTimeoutMillis", (Object)40000);
        log.debug("Starting new connection to: {}", (Object)hostAndPort);
        if (LittleProxyConfig.isUseDnsSec()) {
            cf = cb.connect((SocketAddress)VerifiedAddressFactory.newInetSocketAddress((String)host, (int)port, (boolean)LittleProxyConfig.isUseDnsSec()));
        } else {
            InetAddress ia = InetAddress.getByName(host);
            String address = ia.getHostAddress();
            cf = cb.connect((SocketAddress)new InetSocketAddress(address, port));
        }
        this.allChannelFutures.add(cf);
        return cf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelInterestChanged(ChannelHandlerContext ctx, ChannelStateEvent cse) throws Exception {
        if (cse.getChannel().isWritable()) {
            Set<InterestOpsListener> set = this.interestOpsListeners;
            synchronized (set) {
                for (InterestOpsListener iol : this.interestOpsListeners) {
                    iol.channelWritable(ctx, cse);
                }
            }
        }
    }

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent cse) throws Exception {
        Channel inboundChannel = cse.getChannel();
        log.debug("New channel opened: {}", (Object)inboundChannel);
        totalBrowserToProxyConnections.incrementAndGet();
        this.browserToProxyConnections.incrementAndGet();
        log.debug("Now " + totalBrowserToProxyConnections + " browser to proxy channels...");
        log.debug("Now this class has " + this.browserToProxyConnections + " browser to proxy channels...");
        if (this.channelGroup != null) {
            this.channelGroup.add((Object)inboundChannel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent cse) {
        log.debug("Channel closed: {}", (Object)cse.getChannel());
        this.receivedChannelClosed = true;
        totalBrowserToProxyConnections.decrementAndGet();
        this.browserToProxyConnections.decrementAndGet();
        log.debug("Now " + totalBrowserToProxyConnections + " total browser to proxy channels...");
        log.debug("Now this class has " + this.browserToProxyConnections + " browser to proxy channels...");
        if (this.browserToProxyConnections.get() == 0) {
            log.debug("Closing all proxy to web channels for this browser to proxy connection!!!");
            this.externalHostsToChannelFutures.clear();
            Set<ChannelFuture> set = this.allChannelFutures;
            synchronized (set) {
                for (ChannelFuture cf : this.allChannelFutures) {
                    log.debug("Closing future...");
                    cf.getChannel().close();
                }
                this.allChannelFutures.clear();
            }
        }
    }

    @Override
    public void onRelayChannelClose(Channel browserToProxyChannel, String key, int unansweredRequestsOnChannel, boolean closedEndsResponseBody) {
        if (closedEndsResponseBody) {
            log.debug("Close ends response body");
            this.receivedChannelClosed = true;
        }
        log.debug("this.receivedChannelClosed: " + this.receivedChannelClosed);
        this.removeProxyToWebConnection(key);
        this.unansweredRequestCount.set(this.unansweredRequestCount.get() - unansweredRequestsOnChannel);
        if (this.receivedChannelClosed && (this.externalHostsToChannelFutures.isEmpty() || this.unansweredRequestCount.get() == 0)) {
            if (!this.browserChannelClosed.getAndSet(true)) {
                log.debug("Closing browser to proxy channel");
                ProxyUtils.closeOnFlush(browserToProxyChannel);
            }
        } else {
            log.debug("Not closing browser to proxy channel. Received channel closed is " + this.receivedChannelClosed + " and we have {} " + "connections and awaiting {} responses", (Object)this.externalHostsToChannelFutures.size(), (Object)this.unansweredRequestCount);
        }
    }

    private void removeProxyToWebConnection(String key) {
        this.externalHostsToChannelFutures.remove(key);
    }

    @Override
    public void onRelayHttpResponse(Channel browserToProxyChannel, String key, HttpRequest httpRequest) {
        if (LittleProxyConfig.isUseJmx()) {
            this.answeredRequests.add(httpRequest.toString());
            this.unansweredRequests.remove(httpRequest.toString());
        }
        this.unansweredHttpRequests.remove(httpRequest);
        this.unansweredRequestCount.decrementAndGet();
        this.responsesReceived.incrementAndGet();
        if (this.unansweredRequestCount.get() == 0 && this.receivedChannelClosed) {
            if (!this.browserChannelClosed.getAndSet(true)) {
                log.info("Closing browser to proxy channel on HTTP response");
                ProxyUtils.closeOnFlush(browserToProxyChannel);
            }
        } else {
            log.info("Not closing browser to proxy channel. Still awaiting " + this.unansweredRequestCount + " responses..." + "receivedChannelClosed=" + this.receivedChannelClosed);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        Channel channel = e.getChannel();
        Throwable cause = e.getCause();
        if (cause instanceof ClosedChannelException) {
            log.warn("Caught an exception on browser to proxy channel: " + channel, cause);
        } else {
            log.debug("Caught an exception on browser to proxy channel: " + channel, cause);
        }
        ProxyUtils.closeOnFlush(channel);
    }

    @Override
    public int getClientConnections() {
        return this.browserToProxyConnections.get();
    }

    @Override
    public int getTotalClientConnections() {
        return totalBrowserToProxyConnections.get();
    }

    @Override
    public int getOutgoingConnections() {
        return this.externalHostsToChannelFutures.size();
    }

    @Override
    public int getRequestsSent() {
        return this.requestsSent.get();
    }

    @Override
    public int getResponsesReceived() {
        return this.responsesReceived.get();
    }

    @Override
    public String getUnansweredRequests() {
        return this.unansweredRequests.toString();
    }

    public Set<HttpRequest> getUnansweredHttpRequests() {
        return this.unansweredHttpRequests;
    }

    @Override
    public String getAnsweredReqeusts() {
        return this.answeredRequests.toString();
    }

    @Override
    public void addInterestOpsListener(InterestOpsListener opsListener) {
        this.interestOpsListeners.add(opsListener);
    }
}

