/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.proxy;

import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.timeout.IdleStateEvent;
import org.littleshoot.proxy.HttpRequestHandler;
import org.littleshoot.proxy.IdleAwareHandler;
import org.littleshoot.proxy.IdleHttpRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdleRequestHandler
extends IdleAwareHandler {
    private final HttpRequestHandler handler;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public IdleRequestHandler(HttpRequestHandler handler) {
        super("Client-Pipeline");
        this.handler = handler;
    }

    @Override
    public void channelIdle(ChannelHandlerContext ctx, IdleStateEvent e) {
        super.channelIdle(ctx, e);
        Set<HttpRequest> unansweredHttpRequests = this.handler.getUnansweredHttpRequests();
        if (!unansweredHttpRequests.isEmpty()) {
            StringBuilder message = new StringBuilder("The connection was terminated before resolving the following resources:\n");
            for (HttpRequest unansweredRequest : unansweredHttpRequests) {
                message.append(unansweredRequest.getUri());
                String referrer = unansweredRequest.getHeader("Referer");
                if (!StringUtils.isBlank((CharSequence)referrer)) {
                    message.append(" from ").append(referrer);
                }
                message.append("\n");
            }
            this.log.error(message.toString(), (Throwable)new IdleHttpRequestException());
        }
    }
}

