/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.proxy;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.littleshoot.proxy.HttpRequestFilter;
import org.littleshoot.proxy.NetworkUtils;
import org.littleshoot.proxy.ProxyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublicIpsOnlyRequestFilter
implements HttpRequestFilter {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public void filter(HttpRequest request) {
        String host = ProxyUtils.parseHost(request);
        try {
            InetAddress ia = InetAddress.getByName(host);
            if (NetworkUtils.isPublicAddress(ia)) {
                this.log.info("Allowing request for public address");
                return;
            }
            this.log.warn("Request for non-public resource: {} \n full request: {}", (Object)request.getUri(), (Object)request);
            throw new UnsupportedOperationException("Not a public address: " + ia);
        }
        catch (UnknownHostException uhe) {
            throw new UnsupportedOperationException("Could not resolve host", uhe);
        }
    }
}

