/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.proxy;

import java.util.Arrays;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.cli.UnrecognizedOptionException;
import org.apache.commons.lang3.StringUtils;
import org.littleshoot.proxy.DefaultHttpProxyServer;
import org.littleshoot.proxy.HttpFilter;
import org.littleshoot.proxy.HttpResponseFilters;
import org.littleshoot.proxy.Launcher;
import org.littleshoot.proxy.LittleProxyConfig;
import org.littleshoot.proxy.ProxyUtils;
import org.littleshoot.proxy.SelfSignedKeyStoreManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslLauncher {
    private static final Logger LOG = LoggerFactory.getLogger(Launcher.class);
    private static final String OPTION_DNSSEC = "dnssec";
    private static final String OPTION_PORT = "port";
    private static final String OPTION_HELP = "help";

    public static void main(String ... args) {
        int port;
        CommandLine cmd;
        LOG.info("Running LittleProxy with args: {}", Arrays.asList(args));
        Options options = new Options();
        options.addOption(null, OPTION_DNSSEC, true, "Request and verify DNSSEC signatures.");
        options.addOption(null, OPTION_PORT, true, "Run on the specified port.");
        options.addOption(null, OPTION_HELP, false, "Display command line help.");
        PosixParser parser = new PosixParser();
        try {
            cmd = parser.parse(options, args);
            if (cmd.getArgs().length > 0) {
                throw new UnrecognizedOptionException("Extra arguments were provided in " + Arrays.asList(args));
            }
        }
        catch (ParseException e) {
            SslLauncher.printHelp(options, "Could not parse command line: " + Arrays.asList(args));
            return;
        }
        if (cmd.hasOption(OPTION_HELP)) {
            SslLauncher.printHelp(options, null);
            return;
        }
        if (cmd.hasOption(OPTION_DNSSEC)) {
            String val = cmd.getOptionValue(OPTION_DNSSEC);
            if (ProxyUtils.isTrue(val)) {
                LOG.info("Using DNSSEC");
                LittleProxyConfig.setUseDnsSec(true);
            } else if (ProxyUtils.isFalse(val)) {
                LOG.info("Not using DNSSEC");
                LittleProxyConfig.setUseDnsSec(false);
            } else {
                SslLauncher.printHelp(options, "Unexpected value for dnssec=:" + val);
                return;
            }
        }
        int defaultPort = 8080;
        if (cmd.hasOption(OPTION_PORT)) {
            String val = cmd.getOptionValue(OPTION_PORT);
            try {
                port = Integer.parseInt(val);
            }
            catch (NumberFormatException e) {
                SslLauncher.printHelp(options, "Unexpected port " + val);
                return;
            }
        } else {
            port = 8080;
        }
        System.out.println("About to start SSL server on port: " + port);
        HttpResponseFilters responseFilters = new HttpResponseFilters(){

            @Override
            public HttpFilter getFilter(String hostAndPort) {
                return null;
            }
        };
        DefaultHttpProxyServer server = new DefaultHttpProxyServer(port, responseFilters, null, new SelfSignedKeyStoreManager(), null);
        System.out.println("About to start...");
        server.start();
    }

    private static void printHelp(Options options, String errorMessage) {
        if (!StringUtils.isBlank((CharSequence)errorMessage)) {
            LOG.error(errorMessage);
            System.err.println(errorMessage);
        }
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("littleproxy", options);
    }
}

