/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.proxy.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLSession;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.littleshoot.proxy.ActivityTracker;
import org.littleshoot.proxy.FlowContext;
import org.littleshoot.proxy.FullFlowContext;
import org.littleshoot.proxy.HttpFilters;
import org.littleshoot.proxy.SslEngineSource;
import org.littleshoot.proxy.impl.ConnectionFlowStep;
import org.littleshoot.proxy.impl.ConnectionState;
import org.littleshoot.proxy.impl.DefaultHttpProxyServer;
import org.littleshoot.proxy.impl.ProxyConnection;
import org.littleshoot.proxy.impl.ProxyToServerConnection;
import org.littleshoot.proxy.impl.ProxyUtils;

public class ClientToProxyConnection
extends ProxyConnection<HttpRequest> {
    private static final HttpResponseStatus CONNECTION_ESTABLISHED = new HttpResponseStatus(200, "HTTP/1.1 200 Connection established");
    private static final Set<String> HOP_BY_HOP_HEADERS = new HashSet<String>(Arrays.asList("connection", "keep-alive", "proxy-authenticate", "proxy-authorization", "te", "trailers", "upgrade"));
    private final Map<String, ProxyToServerConnection> serverConnectionsByHostAndPort = new ConcurrentHashMap<String, ProxyToServerConnection>();
    private final AtomicInteger numberOfCurrentlyConnectingServers = new AtomicInteger(0);
    private final AtomicInteger numberOfCurrentlyConnectedServers = new AtomicInteger(0);
    private final AtomicInteger numberOfReusedServerConnections = new AtomicInteger(0);
    private volatile ProxyToServerConnection currentServerConnection;
    private volatile HttpFilters currentFilters;
    private volatile SSLSession clientSslSession;
    ConnectionFlowStep RespondCONNECTSuccessful = new ConnectionFlowStep(this, ConnectionState.NEGOTIATING_CONNECT){

        @Override
        boolean shouldSuppressInitialRequest() {
            return true;
        }

        @Override
        protected Future<?> execute() {
            ClientToProxyConnection.this.LOG.debug("Responding with CONNECT successful", new Object[0]);
            DefaultFullHttpResponse response = ClientToProxyConnection.this.responseFor(HttpVersion.HTTP_1_1, CONNECTION_ESTABLISHED);
            response.headers().set("Connection", "Keep-Alive");
            response.headers().set("Proxy-Connection", "Keep-Alive");
            ProxyUtils.addVia(response);
            return ClientToProxyConnection.this.writeToChannel(response);
        }
    };
    private final ProxyConnection.BytesReadMonitor bytesReadMonitor = new ProxyConnection.BytesReadMonitor(){

        @Override
        protected void bytesRead(int numberOfBytes) {
            FlowContext flowContext = ClientToProxyConnection.this.flowContext();
            for (ActivityTracker tracker : ClientToProxyConnection.this.proxyServer.getActivityTrackers()) {
                tracker.bytesReceivedFromClient(flowContext, numberOfBytes);
            }
        }
    };
    private ProxyConnection.RequestReadMonitor requestReadMonitor = new ProxyConnection.RequestReadMonitor(){

        @Override
        protected void requestRead(HttpRequest httpRequest) {
            FlowContext flowContext = ClientToProxyConnection.this.flowContext();
            for (ActivityTracker tracker : ClientToProxyConnection.this.proxyServer.getActivityTrackers()) {
                tracker.requestReceivedFromClient(flowContext, httpRequest);
            }
        }
    };
    private ProxyConnection.BytesWrittenMonitor bytesWrittenMonitor = new ProxyConnection.BytesWrittenMonitor(){

        @Override
        protected void bytesWritten(int numberOfBytes) {
            FlowContext flowContext = ClientToProxyConnection.this.flowContext();
            for (ActivityTracker tracker : ClientToProxyConnection.this.proxyServer.getActivityTrackers()) {
                tracker.bytesSentToClient(flowContext, numberOfBytes);
            }
        }
    };
    private ProxyConnection.ResponseWrittenMonitor responseWrittenMonitor = new ProxyConnection.ResponseWrittenMonitor(){

        @Override
        protected void responseWritten(HttpResponse httpResponse) {
            FlowContext flowContext = ClientToProxyConnection.this.flowContext();
            for (ActivityTracker tracker : ClientToProxyConnection.this.proxyServer.getActivityTrackers()) {
                tracker.responseSentToClient(flowContext, httpResponse);
            }
        }
    };

    ClientToProxyConnection(DefaultHttpProxyServer proxyServer, SslEngineSource sslEngineSource, ChannelPipeline pipeline) {
        super(ConnectionState.AWAITING_INITIAL, proxyServer, sslEngineSource, false);
        this.initChannelPipeline(pipeline);
        if (sslEngineSource != null) {
            this.LOG.debug("Enabling encryption of traffic from client to proxy", new Object[0]);
            this.encrypt(pipeline).addListener((GenericFutureListener<Future<Channel>>)new GenericFutureListener<Future<? super Channel>>(){

                @Override
                public void operationComplete(Future<? super Channel> future) throws Exception {
                    if (future.isSuccess()) {
                        ClientToProxyConnection.this.clientSslSession = ClientToProxyConnection.this.sslEngine.getSession();
                        ClientToProxyConnection.this.recordClientSSLHandshakeSucceeded();
                    }
                }
            });
        }
        this.LOG.debug("Created ClientToProxyConnection", new Object[0]);
    }

    @Override
    protected ConnectionState readHTTPInitial(HttpRequest httpRequest) {
        this.LOG.debug("Got request: {}", httpRequest);
        boolean authenticationRequired = this.authenticationRequired(httpRequest);
        if (authenticationRequired) {
            this.LOG.debug("Not authenticated!!", new Object[0]);
            return ConnectionState.AWAITING_PROXY_AUTHENTICATION;
        }
        return this.doReadHTTPInitial(httpRequest);
    }

    private ConnectionState doReadHTTPInitial(HttpRequest httpRequest) {
        HttpRequest originalRequest = this.copy(httpRequest);
        this.currentFilters = this.proxyServer.getFiltersSource().filterRequest(originalRequest);
        if (this.shortCircuitRespond(this.currentFilters.requestPre(httpRequest))) {
            return ConnectionState.DISCONNECT_REQUESTED;
        }
        String serverHostAndPort = this.identifyHostAndPort(httpRequest);
        this.LOG.debug("Ensuring that hostAndPort are available in {}", httpRequest.getUri());
        if (serverHostAndPort == null || StringUtils.isBlank(serverHostAndPort)) {
            this.LOG.warn("No host and port found in {}", httpRequest.getUri());
            this.writeBadGateway(httpRequest);
            return ConnectionState.DISCONNECT_REQUESTED;
        }
        this.LOG.debug("Finding ProxyToServerConnection for: {}", serverHostAndPort);
        this.currentServerConnection = this.serverConnectionsByHostAndPort.get(serverHostAndPort);
        boolean newConnectionRequired = false;
        if (ProxyUtils.isCONNECT(httpRequest)) {
            this.LOG.debug("Not reusing existing ProxyToServerConnection because request is a CONNECT for: {}", serverHostAndPort);
            newConnectionRequired = true;
        } else if (this.currentServerConnection == null) {
            this.LOG.debug("Didn't find existing ProxyToServerConnection for: {}", serverHostAndPort);
            newConnectionRequired = true;
        }
        if (newConnectionRequired) {
            try {
                this.currentServerConnection = ProxyToServerConnection.create(this.proxyServer, this, serverHostAndPort, this.currentFilters, httpRequest);
                this.serverConnectionsByHostAndPort.put(serverHostAndPort, this.currentServerConnection);
            }
            catch (UnknownHostException uhe) {
                this.LOG.info("Bad Host {}", httpRequest.getUri());
                this.writeBadGateway(httpRequest);
                this.resumeReading();
                return ConnectionState.DISCONNECT_REQUESTED;
            }
        } else {
            this.LOG.debug("Reusing existing server connection: {}", this.currentServerConnection);
            this.numberOfReusedServerConnections.incrementAndGet();
        }
        this.modifyRequestHeadersToReflectProxying(httpRequest);
        if (this.shortCircuitRespond(this.currentFilters.requestPost(httpRequest))) {
            return ConnectionState.DISCONNECT_REQUESTED;
        }
        this.LOG.debug("Writing request to ProxyToServerConnection", new Object[0]);
        this.currentServerConnection.write(httpRequest);
        if (ProxyUtils.isCONNECT(httpRequest)) {
            return ConnectionState.NEGOTIATING_CONNECT;
        }
        if (ProxyUtils.isChunked(httpRequest)) {
            return ConnectionState.AWAITING_CHUNK;
        }
        return ConnectionState.AWAITING_INITIAL;
    }

    @Override
    protected void readHTTPChunk(HttpContent chunk) {
        this.currentFilters.requestPre(chunk);
        this.currentFilters.requestPost(chunk);
        this.currentServerConnection.write(chunk);
    }

    @Override
    protected void readRaw(ByteBuf buf) {
        this.currentServerConnection.write(buf);
    }

    void respond(ProxyToServerConnection serverConnection, HttpFilters filters, HttpRequest currentHttpRequest, HttpResponse currentHttpResponse, HttpObject httpObject) {
        filters.responsePre(httpObject);
        if (httpObject instanceof HttpResponse) {
            HttpResponse httpResponse = (HttpResponse)httpObject;
            this.fixHttpVersionHeaderIfNecessary(httpResponse);
            this.modifyResponseHeadersToReflectProxying(httpResponse);
        }
        filters.responsePost(httpObject);
        this.write(httpObject);
        if (ProxyUtils.isLastChunk(httpObject)) {
            this.writeEmptyBuffer();
        }
        this.closeConnectionsAfterWriteIfNecessary(serverConnection, currentHttpRequest, currentHttpResponse, httpObject);
    }

    private boolean shortCircuitRespond(HttpResponse shortCircuitResponse) {
        if (shortCircuitResponse != null) {
            this.write(shortCircuitResponse);
            this.disconnect();
            return true;
        }
        return false;
    }

    @Override
    protected void connected() {
        super.connected();
        this.become(ConnectionState.AWAITING_INITIAL);
        this.recordClientConnected();
    }

    @Override
    protected void disconnected() {
        super.disconnected();
        for (ProxyToServerConnection serverConnection : this.serverConnectionsByHostAndPort.values()) {
            serverConnection.disconnect();
        }
        this.recordClientDisconnected();
    }

    protected void serverConnectionFlowStarted(ProxyToServerConnection serverConnection) {
        this.stopReading();
        this.numberOfCurrentlyConnectingServers.incrementAndGet();
    }

    protected void serverConnectionSucceeded(ProxyToServerConnection serverConnection, boolean shouldForwardInitialRequest) {
        this.LOG.debug("Connection to server succeeded: {}", serverConnection.getRemoteAddress());
        this.resumeReadingIfNecessary();
        this.become(shouldForwardInitialRequest ? this.getCurrentState() : ConnectionState.AWAITING_INITIAL);
        this.numberOfCurrentlyConnectedServers.incrementAndGet();
    }

    protected boolean serverConnectionFailed(ProxyToServerConnection serverConnection, ConnectionState lastStateBeforeFailure, Throwable cause) {
        this.resumeReadingIfNecessary();
        HttpRequest initialRequest = serverConnection.getInitialRequest();
        try {
            if (serverConnection.connectionFailed(cause)) {
                this.LOG.info("Failed to connect via chained proxy, falling back to next chained proxy. Last state before failure: {}", new Object[]{lastStateBeforeFailure, cause});
                return true;
            }
            this.LOG.debug("Connection to server failed: {}.  Last state before failure: {}", new Object[]{serverConnection.getRemoteAddress(), lastStateBeforeFailure, cause});
            this.connectionFailedUnrecoverably(initialRequest);
            return false;
        }
        catch (UnknownHostException uhe) {
            this.connectionFailedUnrecoverably(initialRequest);
            return false;
        }
    }

    private void connectionFailedUnrecoverably(HttpRequest initialRequest) {
        this.writeBadGateway(initialRequest);
        this.become(ConnectionState.DISCONNECT_REQUESTED);
    }

    private void resumeReadingIfNecessary() {
        if (this.numberOfCurrentlyConnectingServers.decrementAndGet() == 0) {
            this.LOG.debug("All servers have finished attempting to connect, resuming reading from client.", new Object[0]);
            this.resumeReading();
        }
    }

    protected void serverDisconnected(ProxyToServerConnection serverConnection) {
        this.numberOfCurrentlyConnectedServers.decrementAndGet();
        this.disconnectClientIfNecessary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void becameSaturated() {
        super.becameSaturated();
        Iterator<ProxyToServerConnection> i$ = this.serverConnectionsByHostAndPort.values().iterator();
        while (i$.hasNext()) {
            ProxyToServerConnection serverConnection;
            ProxyToServerConnection proxyToServerConnection = serverConnection = i$.next();
            synchronized (proxyToServerConnection) {
                if (this.isSaturated()) {
                    serverConnection.stopReading();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void becameWritable() {
        super.becameWritable();
        Iterator<ProxyToServerConnection> i$ = this.serverConnectionsByHostAndPort.values().iterator();
        while (i$.hasNext()) {
            ProxyToServerConnection serverConnection;
            ProxyToServerConnection proxyToServerConnection = serverConnection = i$.next();
            synchronized (proxyToServerConnection) {
                if (!this.isSaturated()) {
                    serverConnection.resumeReading();
                }
            }
        }
    }

    protected synchronized void serverBecameSaturated(ProxyToServerConnection serverConnection) {
        if (serverConnection.isSaturated()) {
            this.LOG.info("Connection to server became saturated, stopping reading", new Object[0]);
            this.stopReading();
        }
    }

    protected synchronized void serverBecameWriteable(ProxyToServerConnection serverConnection) {
        boolean anyServersSaturated = false;
        for (ProxyToServerConnection otherServerConnection : this.serverConnectionsByHostAndPort.values()) {
            if (!otherServerConnection.isSaturated()) continue;
            anyServersSaturated = true;
            break;
        }
        if (!anyServersSaturated) {
            this.LOG.info("All server connections writeable, resuming reading", new Object[0]);
            this.resumeReading();
        }
    }

    @Override
    protected void exceptionCaught(Throwable cause) {
        String message = "Caught an exception on ClientToProxyConnection";
        if (cause instanceof ClosedChannelException) {
            this.LOG.warn(message, cause);
        } else {
            this.LOG.error(message, cause);
        }
        this.disconnect();
    }

    private void initChannelPipeline(ChannelPipeline pipeline) {
        this.LOG.debug("Configuring ChannelPipeline", new Object[0]);
        pipeline.addLast("bytesReadMonitor", (ChannelHandler)this.bytesReadMonitor);
        pipeline.addLast("decoder", (ChannelHandler)new HttpRequestDecoder(8192, 16384, 16384));
        pipeline.addLast("requestReadMonitor", (ChannelHandler)this.requestReadMonitor);
        int numberOfBytesToBuffer = this.proxyServer.getFiltersSource().getMaximumRequestBufferSizeInBytes();
        if (numberOfBytesToBuffer > 0) {
            this.aggregateContentForFiltering(pipeline, numberOfBytesToBuffer);
        }
        pipeline.addLast("bytesWrittenMonitor", (ChannelHandler)this.bytesWrittenMonitor);
        pipeline.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
        pipeline.addLast("responseWrittenMonitor", (ChannelHandler)this.responseWrittenMonitor);
        pipeline.addLast("idle", (ChannelHandler)new IdleStateHandler(0, 0, this.proxyServer.getIdleConnectionTimeout()));
        pipeline.addLast("handler", (ChannelHandler)this);
    }

    private void disconnectClientIfNecessary() {
        if (this.numberOfCurrentlyConnectedServers.get() == 0) {
            this.disconnect();
        }
    }

    private void closeConnectionsAfterWriteIfNecessary(ProxyToServerConnection serverConnection, HttpRequest currentHttpRequest, HttpResponse currentHttpResponse, HttpObject httpObject) {
        boolean closeServerConnection = this.shouldCloseServerConnection(currentHttpRequest, currentHttpResponse, httpObject);
        boolean closeClientConnection = this.shouldCloseClientConnection(currentHttpRequest, currentHttpResponse, httpObject);
        if (closeServerConnection) {
            this.LOG.debug("Closing remote connection after writing to client", new Object[0]);
            serverConnection.disconnect();
        }
        if (closeClientConnection) {
            this.LOG.debug("Closing connection to client after writes", new Object[0]);
            this.disconnect();
        }
    }

    private boolean shouldCloseClientConnection(HttpRequest req, HttpResponse res, HttpObject httpObject) {
        if (ProxyUtils.isChunked(res) && httpObject != null) {
            if (!ProxyUtils.isLastChunk(httpObject)) {
                this.LOG.debug("Not closing on middle chunk for {}", req.getUri());
                return false;
            }
            this.LOG.debug("Last chunk... using normal closing rules", new Object[0]);
        }
        if (!HttpHeaders.isKeepAlive(req)) {
            this.LOG.debug("Closing since request is not keep alive:", new Object[0]);
            return true;
        }
        this.LOG.debug("Not closing client to proxy connection for request: {}", req);
        return false;
    }

    private boolean shouldCloseServerConnection(HttpRequest req, HttpResponse res, HttpObject msg) {
        if (ProxyUtils.isChunked(res) && msg != null) {
            if (!ProxyUtils.isLastChunk(msg)) {
                this.LOG.debug("Not closing on middle chunk", new Object[0]);
                return false;
            }
            this.LOG.debug("Last chunk...using normal closing rules", new Object[0]);
        }
        if (!HttpHeaders.isKeepAlive(req)) {
            this.LOG.debug("Closing since request is not keep alive:{}, ", req);
            return true;
        }
        if (!HttpHeaders.isKeepAlive(res)) {
            this.LOG.debug("Closing since response is not keep alive:{}", res);
            return true;
        }
        this.LOG.debug("Not closing -- response probably keep alive for:\n{}", res);
        return false;
    }

    private boolean authenticationRequired(HttpRequest request) {
        if (!request.headers().contains("Proxy-Authorization")) {
            if (this.proxyServer.getProxyAuthenticator() != null) {
                this.writeAuthenticationRequired();
                return true;
            }
            return false;
        }
        List<String> values = request.headers().getAll("Proxy-Authorization");
        String fullValue = values.iterator().next();
        String value = StringUtils.substringAfter(fullValue, "Basic ").trim();
        byte[] decodedValue = Base64.decodeBase64(value);
        try {
            String decodedString = new String(decodedValue, "UTF-8");
            String userName = StringUtils.substringBefore(decodedString, ":");
            String password = StringUtils.substringAfter(decodedString, ":");
            if (!this.proxyServer.getProxyAuthenticator().authenticate(userName, password)) {
                this.writeAuthenticationRequired();
                return true;
            }
        }
        catch (UnsupportedEncodingException e) {
            this.LOG.error("Could not decode?", e);
        }
        this.LOG.info("Got proxy authorization!", new Object[0]);
        String authentication = request.headers().get("Proxy-Authorization");
        this.LOG.info(authentication, new Object[0]);
        request.headers().remove("Proxy-Authorization");
        return false;
    }

    private void writeAuthenticationRequired() {
        String body = "<!DOCTYPE HTML \"-//IETF//DTD HTML 2.0//EN\">\n<html><head>\n<title>407 Proxy Authentication Required</title>\n</head><body>\n<h1>Proxy Authentication Required</h1>\n<p>This server could not verify that you\nare authorized to access the document\nrequested.  Either you supplied the wrong\ncredentials (e.g., bad password), or your\nbrowser doesn't understand how to supply\nthe credentials required.</p>\n</body></html>\n";
        DefaultFullHttpResponse response = this.responseFor(HttpVersion.HTTP_1_1, HttpResponseStatus.PROXY_AUTHENTICATION_REQUIRED, body);
        response.headers().set("Date", ProxyUtils.httpDate());
        response.headers().set("Proxy-Authenticate", "Basic realm=\"Restricted Files\"");
        response.headers().set("Date", ProxyUtils.httpDate());
        this.write(response);
    }

    private HttpRequest copy(HttpRequest original) {
        if (original instanceof DefaultFullHttpRequest) {
            ByteBuf content = ((DefaultFullHttpRequest)original).content();
            return new DefaultFullHttpRequest(original.getProtocolVersion(), original.getMethod(), original.getUri(), content);
        }
        return new DefaultHttpRequest(original.getProtocolVersion(), original.getMethod(), original.getUri());
    }

    private void fixHttpVersionHeaderIfNecessary(HttpResponse httpResponse) {
        String te = httpResponse.headers().get("Transfer-Encoding");
        if (StringUtils.isNotBlank(te) && te.equalsIgnoreCase("chunked") && httpResponse.getProtocolVersion() != HttpVersion.HTTP_1_1) {
            this.LOG.debug("Fixing HTTP version.", new Object[0]);
            httpResponse.setProtocolVersion(HttpVersion.HTTP_1_1);
        }
    }

    private void modifyRequestHeadersToReflectProxying(HttpRequest httpRequest) {
        if (!this.proxyServer.isTransparent()) {
            this.LOG.debug("Modifying request headers for proxying", new Object[0]);
            if (!this.currentServerConnection.isChained()) {
                this.LOG.debug("Modifying request for proxy chaining", new Object[0]);
                String uri = httpRequest.getUri();
                String adjustedUri = ProxyUtils.stripHost(uri);
                this.LOG.debug("Stripped host from uri: {}    yielding: {}", uri, adjustedUri);
                httpRequest.setUri(adjustedUri);
            }
            HttpHeaders headers = httpRequest.headers();
            this.removeSDCHEncoding(headers);
            this.switchProxyConnectionHeader(headers);
            this.stripConnectionTokens(headers);
            this.stripHopByHopHeaders(headers);
            ProxyUtils.addVia(httpRequest);
        }
    }

    private void modifyResponseHeadersToReflectProxying(HttpResponse httpResponse) {
        if (!this.proxyServer.isTransparent()) {
            HttpHeaders headers = httpResponse.headers();
            this.stripConnectionTokens(headers);
            this.stripHopByHopHeaders(headers);
            ProxyUtils.addVia(httpResponse);
            if (!headers.contains("Date")) {
                headers.set("Date", ProxyUtils.httpDate());
            }
        }
    }

    private void removeSDCHEncoding(HttpHeaders headers) {
        String ae = headers.get("Accept-Encoding");
        if (StringUtils.isNotBlank(ae)) {
            String noSdch = ae.replace(",sdch", "").replace("sdch", "");
            headers.set("Accept-Encoding", noSdch);
            this.LOG.debug("Removed sdch and inserted: {}", noSdch);
        }
    }

    private void switchProxyConnectionHeader(HttpHeaders headers) {
        String proxyConnectionKey = "Proxy-Connection";
        if (headers.contains(proxyConnectionKey)) {
            String header = headers.get(proxyConnectionKey);
            headers.remove(proxyConnectionKey);
            headers.set("Connection", header);
        }
    }

    private void stripConnectionTokens(HttpHeaders headers) {
        if (headers.contains("Connection")) {
            for (String headerValue : headers.getAll("Connection")) {
                for (String connectionToken : headerValue.split(",")) {
                    headers.remove(connectionToken);
                }
            }
        }
    }

    private void stripHopByHopHeaders(HttpHeaders headers) {
        Set<String> headerNames = headers.names();
        for (String name : headerNames) {
            if (!HOP_BY_HOP_HEADERS.contains(name.toLowerCase())) continue;
            headers.remove(name);
        }
    }

    private void writeBadGateway(HttpRequest request) {
        String body = "Bad Gateway: " + request.getUri();
        DefaultFullHttpResponse response = this.responseFor(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_GATEWAY, body);
        response.headers().set("Connection", "close");
        this.write(response);
        this.disconnect();
    }

    private DefaultFullHttpResponse responseFor(HttpVersion httpVersion, HttpResponseStatus status, String body) {
        byte[] bytes = body.getBytes(Charset.forName("UTF-8"));
        ByteBuf content = Unpooled.copiedBuffer(bytes);
        return this.responseFor(httpVersion, status, content, bytes.length);
    }

    private DefaultFullHttpResponse responseFor(HttpVersion httpVersion, HttpResponseStatus status, ByteBuf body, int contentLength) {
        DefaultFullHttpResponse response;
        DefaultFullHttpResponse defaultFullHttpResponse = response = body != null ? new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, body) : new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status);
        if (body != null) {
            response.headers().set("Content-Length", contentLength);
            response.headers().set("Content-Type", "text/html; charset=UTF-8");
        }
        return response;
    }

    private DefaultFullHttpResponse responseFor(HttpVersion httpVersion, HttpResponseStatus status) {
        return this.responseFor(httpVersion, status, null, 0);
    }

    private String identifyHostAndPort(HttpRequest httpRequest) {
        List<String> hosts;
        String hostAndPort = ProxyUtils.parseHostAndPort(httpRequest);
        if (StringUtils.isBlank(hostAndPort) && (hosts = httpRequest.headers().getAll("Host")) != null && !hosts.isEmpty()) {
            hostAndPort = hosts.get(0);
        }
        return hostAndPort;
    }

    private void writeEmptyBuffer() {
        this.write(Unpooled.EMPTY_BUFFER);
    }

    private void recordClientConnected() {
        try {
            InetSocketAddress clientAddress = this.getClientAddress();
            for (ActivityTracker tracker : this.proxyServer.getActivityTrackers()) {
                tracker.clientConnected(clientAddress);
            }
        }
        catch (Exception e) {
            this.LOG.error("Unable to recordClientConnected", e);
        }
    }

    private void recordClientSSLHandshakeSucceeded() {
        try {
            InetSocketAddress clientAddress = this.getClientAddress();
            for (ActivityTracker tracker : this.proxyServer.getActivityTrackers()) {
                tracker.clientSSLHandshakeSucceeded(clientAddress, this.clientSslSession);
            }
        }
        catch (Exception e) {
            this.LOG.error("Unable to recorClientSSLHandshakeSucceeded", e);
        }
    }

    private void recordClientDisconnected() {
        try {
            InetSocketAddress clientAddress = this.getClientAddress();
            for (ActivityTracker tracker : this.proxyServer.getActivityTrackers()) {
                tracker.clientDisconnected(clientAddress, this.clientSslSession);
            }
        }
        catch (Exception e) {
            this.LOG.error("Unable to recordClientDisconnected", e);
        }
    }

    public InetSocketAddress getClientAddress() {
        return (InetSocketAddress)this.channel.remoteAddress();
    }

    private FlowContext flowContext() {
        if (this.currentServerConnection != null) {
            return new FullFlowContext(this, this.currentServerConnection);
        }
        return new FlowContext(this);
    }
}

