/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.proxy.impl;

import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkUtils {
    private static final Logger LOG = LoggerFactory.getLogger(NetworkUtils.class);

    public static InetAddress getLocalHost() throws UnknownHostException {
        InetAddress alternateAddress;
        try {
            InetAddress is = InetAddress.getLocalHost();
            if (!is.isLoopbackAddress()) {
                return is;
            }
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        InetAddress address = NetworkUtils.getLocalHostViaUdp();
        if ((address.isLoopbackAddress() || address.isAnyLocalAddress()) && (alternateAddress = NetworkUtils.firstLocalNonLoopbackIpv4Address()) != null) {
            address = alternateAddress;
        }
        return address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InetAddress getLocalHostViaUdp() throws UnknownHostException {
        InetSocketAddress sa = new InetSocketAddress("www.google.com", 80);
        DatagramSocket sock = null;
        try {
            InetAddress address;
            sock = new DatagramSocket();
            sock.connect(sa);
            InetAddress inetAddress = address = sock.getLocalAddress();
            return inetAddress;
        }
        catch (SocketException e) {
            LOG.warn("Exception getting address", e);
            InetAddress inetAddress = InetAddress.getLocalHost();
            return inetAddress;
        }
        finally {
            if (sock != null) {
                sock.close();
            }
        }
    }

    public static InetAddress firstLocalNonLoopbackIpv4Address() {
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                if (!networkInterface.isUp()) continue;
                for (InterfaceAddress ifAddress : networkInterface.getInterfaceAddresses()) {
                    if (ifAddress.getNetworkPrefixLength() <= 0 || ifAddress.getNetworkPrefixLength() > 32 || ifAddress.getAddress().isLoopbackAddress()) continue;
                    return ifAddress.getAddress();
                }
            }
            return null;
        }
        catch (SocketException se) {
            return null;
        }
    }
}

