/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.proxy.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.ReferenceCounted;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import javax.net.ssl.SSLEngine;
import org.littleshoot.proxy.SslEngineSource;
import org.littleshoot.proxy.impl.ConnectionFlowStep;
import org.littleshoot.proxy.impl.ConnectionState;
import org.littleshoot.proxy.impl.DefaultHttpProxyServer;
import org.littleshoot.proxy.impl.ProxyConnectionLogger;
import org.littleshoot.proxy.impl.ProxyUtils;

abstract class ProxyConnection<I extends HttpObject>
extends SimpleChannelInboundHandler<Object> {
    protected final ProxyConnectionLogger LOG = new ProxyConnectionLogger(this);
    protected final DefaultHttpProxyServer proxyServer;
    protected volatile SslEngineSource sslEngineSource;
    protected final boolean runsAsSSLClient;
    protected volatile ChannelHandlerContext ctx;
    protected volatile Channel channel;
    private volatile ConnectionState currentState;
    private volatile boolean tunneling = false;
    protected volatile SSLEngine sslEngine;
    protected ConnectionFlowStep StartTunneling = new ConnectionFlowStep(this, ConnectionState.NEGOTIATING_CONNECT){

        @Override
        boolean shouldSuppressInitialRequest() {
            return true;
        }

        @Override
        protected Future execute() {
            try {
                ChannelPipeline pipeline = ProxyConnection.this.ctx.pipeline();
                if (pipeline.get("encoder") != null) {
                    pipeline.remove("encoder");
                }
                if (pipeline.get("responseWrittenMonitor") != null) {
                    pipeline.remove("responseWrittenMonitor");
                }
                if (pipeline.get("decoder") != null) {
                    pipeline.remove("decoder");
                }
                if (pipeline.get("requestReadMonitor") != null) {
                    pipeline.remove("requestReadMonitor");
                }
                ProxyConnection.this.tunneling = true;
                return ProxyConnection.this.channel.newSucceededFuture();
            }
            catch (Throwable t) {
                return ProxyConnection.this.channel.newFailedFuture(t);
            }
        }
    };

    protected ProxyConnection(ConnectionState initialState, DefaultHttpProxyServer proxyServer, SslEngineSource sslEngineSource, boolean runsAsSSLClient) {
        this.become(initialState);
        this.proxyServer = proxyServer;
        this.sslEngineSource = sslEngineSource;
        this.runsAsSSLClient = runsAsSSLClient;
    }

    protected void read(Object msg) {
        this.LOG.debug("Reading: {}", msg);
        if (this.tunneling) {
            this.readRaw((ByteBuf)msg);
        } else {
            this.readHTTP((HttpObject)msg);
        }
    }

    private void readHTTP(HttpObject httpObject) {
        ConnectionState nextState = this.getCurrentState();
        switch (this.getCurrentState()) {
            case AWAITING_INITIAL: {
                nextState = this.readHTTPInitial(httpObject);
                break;
            }
            case AWAITING_CHUNK: {
                HttpContent chunk = (HttpContent)httpObject;
                this.readHTTPChunk(chunk);
                nextState = ProxyUtils.isLastChunk(chunk) ? ConnectionState.AWAITING_INITIAL : ConnectionState.AWAITING_CHUNK;
                break;
            }
            case AWAITING_PROXY_AUTHENTICATION: {
                if (!(httpObject instanceof HttpRequest)) break;
                nextState = this.readHTTPInitial(httpObject);
                break;
            }
            case CONNECTING: {
                this.LOG.warn("Attempted to read from connection that's in the process of connecting.  This shouldn't happen.", new Object[0]);
                break;
            }
            case NEGOTIATING_CONNECT: {
                this.LOG.debug("Attempted to read from connection that's in the process of negotiating an HTTP CONNECT.  This is probably the LastHttpContent of a chunked CONNECT.", new Object[0]);
                break;
            }
            case AWAITING_CONNECT_OK: {
                this.LOG.warn("AWAITING_CONNECT_OK should have been handled by ProxyToServerConnection.read()", new Object[0]);
                break;
            }
            case HANDSHAKING: {
                this.LOG.warn("Attempted to read from connection that's in the process of handshaking.  This shouldn't happen.", this.channel);
                break;
            }
            case DISCONNECT_REQUESTED: 
            case DISCONNECTED: {
                this.LOG.info("Ignoring message since the connection is closed or about to close", new Object[0]);
            }
        }
        this.become(nextState);
    }

    protected abstract ConnectionState readHTTPInitial(I var1);

    protected abstract void readHTTPChunk(HttpContent var1);

    protected abstract void readRaw(ByteBuf var1);

    void write(Object msg) {
        if (msg instanceof ReferenceCounted) {
            this.LOG.debug("Retaining reference counted message", new Object[0]);
            ((ReferenceCounted)msg).retain();
        }
        this.doWrite(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doWrite(Object msg) {
        block3: {
            this.LOG.debug("Writing: {}", msg);
            try {
                if (msg instanceof HttpObject) {
                    this.writeHttp((HttpObject)msg);
                    break block3;
                }
                this.writeRaw((ByteBuf)msg);
            }
            catch (Throwable throwable) {
                this.LOG.debug("Wrote: {}", msg);
                throw throwable;
            }
        }
        this.LOG.debug("Wrote: {}", msg);
    }

    protected void writeHttp(HttpObject httpObject) {
        if (ProxyUtils.isLastChunk(httpObject)) {
            this.channel.write(httpObject);
            this.LOG.debug("Writing an empty buffer to signal the end of our chunked transfer", new Object[0]);
            this.writeToChannel(Unpooled.EMPTY_BUFFER);
        } else {
            this.writeToChannel(httpObject);
        }
    }

    protected void writeRaw(ByteBuf buf) {
        this.writeToChannel(buf);
    }

    protected ChannelFuture writeToChannel(Object msg) {
        return this.channel.writeAndFlush(msg);
    }

    protected void connected() {
        this.LOG.debug("Connected", new Object[0]);
    }

    protected void disconnected() {
        this.become(ConnectionState.DISCONNECTED);
        this.LOG.debug("Disconnected", new Object[0]);
    }

    protected Future<Channel> encrypt() {
        return this.encrypt(this.ctx.pipeline());
    }

    protected Future<Channel> encrypt(ChannelPipeline pipeline) {
        this.LOG.debug("Enabling encryption with SSLEngineSource: {}", this.sslEngineSource);
        this.sslEngine = this.sslEngineSource.newSslEngine();
        this.sslEngine.setUseClientMode(this.runsAsSSLClient);
        this.sslEngine.setNeedClientAuth(!this.runsAsSSLClient);
        SslHandler handler = new SslHandler(this.sslEngine);
        pipeline.addFirst("ssl", (ChannelHandler)handler);
        return handler.handshakeFuture().addListener((GenericFutureListener<Future<Channel>>)new GenericFutureListener<Future<? super Channel>>(){

            @Override
            public void operationComplete(Future<? super Channel> future) throws Exception {
            }
        });
    }

    protected void aggregateContentForFiltering(ChannelPipeline pipeline, int numberOfBytesToBuffer) {
        pipeline.addLast("inflater", (ChannelHandler)new HttpContentDecompressor());
        pipeline.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(numberOfBytesToBuffer));
    }

    protected void becameSaturated() {
        this.LOG.debug("Became saturated", new Object[0]);
    }

    protected void becameWritable() {
        this.LOG.debug("Became writeable", new Object[0]);
    }

    protected void exceptionCaught(Throwable cause) {
    }

    Future<Void> disconnect() {
        if (this.channel == null) {
            return null;
        }
        final ChannelPromise promise = this.channel.newPromise();
        this.writeToChannel(Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener<? extends Future<? super Void>>)new GenericFutureListener<Future<? super Void>>(){

            @Override
            public void operationComplete(Future<? super Void> future) throws Exception {
                ProxyConnection.this.closeChannel(promise);
            }
        });
        return promise;
    }

    private void closeChannel(final Promise<Void> promise) {
        this.channel.close().addListener((GenericFutureListener<? extends Future<? super Void>>)new GenericFutureListener<Future<? super Void>>(){

            @Override
            public void operationComplete(Future<? super Void> future) throws Exception {
                if (future.isSuccess()) {
                    promise.setSuccess(null);
                } else {
                    promise.setFailure(future.cause());
                }
            }
        });
    }

    protected boolean isSaturated() {
        return !this.channel.isWritable();
    }

    protected boolean is(ConnectionState state) {
        return this.currentState == state;
    }

    protected boolean isConnecting() {
        return this.currentState.isPartOfConnectionFlow();
    }

    protected void become(ConnectionState state) {
        this.currentState = state;
    }

    protected ConnectionState getCurrentState() {
        return this.currentState;
    }

    public boolean isTunneling() {
        return this.tunneling;
    }

    public SSLEngine getSslEngine() {
        return this.sslEngine;
    }

    protected void stopReading() {
        this.LOG.debug("Stopped reading", new Object[0]);
        this.channel.config().setAutoRead(false);
    }

    protected void resumeReading() {
        this.LOG.debug("Resumed reading", new Object[0]);
        this.channel.config().setAutoRead(true);
    }

    ProxyConnectionLogger getLOG() {
        return this.LOG;
    }

    @Override
    protected final void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        this.read(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        try {
            this.ctx = ctx;
            this.channel = ctx.channel();
            this.proxyServer.registerChannel(ctx.channel());
        }
        finally {
            super.channelRegistered(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void channelActive(ChannelHandlerContext ctx) throws Exception {
        try {
            this.connected();
        }
        finally {
            super.channelActive(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        try {
            this.disconnected();
        }
        finally {
            super.channelInactive(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        this.LOG.debug("Writability changed. Is writable: {}", this.channel.isWritable());
        try {
            if (this.channel.isWritable()) {
                this.becameWritable();
            } else {
                this.becameSaturated();
            }
        }
        finally {
            super.channelWritabilityChanged(ctx);
        }
    }

    @Override
    public final void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.exceptionCaught(cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        try {
            if (evt instanceof IdleStateEvent) {
                this.LOG.debug("Got idle, disconnecting", new Object[0]);
                this.disconnect();
            }
        }
        finally {
            super.userEventTriggered(ctx, evt);
        }
    }

    @ChannelHandler.Sharable
    protected abstract class ResponseWrittenMonitor
    extends ChannelOutboundHandlerAdapter {
        protected ResponseWrittenMonitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            try {
                if (msg instanceof HttpResponse) {
                    this.responseWritten((HttpResponse)msg);
                }
            }
            catch (Throwable t) {
                ProxyConnection.this.LOG.warn("Unable to record bytesRead", t);
            }
            finally {
                super.write(ctx, msg, promise);
            }
        }

        protected abstract void responseWritten(HttpResponse var1);
    }

    @ChannelHandler.Sharable
    protected abstract class RequestWrittenMonitor
    extends ChannelOutboundHandlerAdapter {
        protected RequestWrittenMonitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            try {
                if (msg instanceof HttpRequest) {
                    this.requestWritten((HttpRequest)msg);
                }
            }
            catch (Throwable t) {
                ProxyConnection.this.LOG.warn("Unable to record bytesRead", t);
            }
            finally {
                super.write(ctx, msg, promise);
            }
        }

        protected abstract void requestWritten(HttpRequest var1);
    }

    @ChannelHandler.Sharable
    protected abstract class BytesWrittenMonitor
    extends ChannelOutboundHandlerAdapter {
        protected BytesWrittenMonitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            try {
                if (msg instanceof ByteBuf) {
                    this.bytesWritten(((ByteBuf)msg).readableBytes());
                }
            }
            catch (Throwable t) {
                ProxyConnection.this.LOG.warn("Unable to record bytesRead", t);
            }
            finally {
                super.write(ctx, msg, promise);
            }
        }

        protected abstract void bytesWritten(int var1);
    }

    @ChannelHandler.Sharable
    protected abstract class ResponseReadMonitor
    extends ChannelInboundHandlerAdapter {
        protected ResponseReadMonitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            try {
                if (msg instanceof HttpResponse) {
                    this.responseRead((HttpResponse)msg);
                }
            }
            catch (Throwable t) {
                ProxyConnection.this.LOG.warn("Unable to record bytesRead", t);
            }
            finally {
                super.channelRead(ctx, msg);
            }
        }

        protected abstract void responseRead(HttpResponse var1);
    }

    @ChannelHandler.Sharable
    protected abstract class RequestReadMonitor
    extends ChannelInboundHandlerAdapter {
        protected RequestReadMonitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            try {
                if (msg instanceof HttpRequest) {
                    this.requestRead((HttpRequest)msg);
                }
            }
            catch (Throwable t) {
                ProxyConnection.this.LOG.warn("Unable to record bytesRead", t);
            }
            finally {
                super.channelRead(ctx, msg);
            }
        }

        protected abstract void requestRead(HttpRequest var1);
    }

    @ChannelHandler.Sharable
    protected abstract class BytesReadMonitor
    extends ChannelInboundHandlerAdapter {
        protected BytesReadMonitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            try {
                if (msg instanceof ByteBuf) {
                    this.bytesRead(((ByteBuf)msg).readableBytes());
                }
            }
            catch (Throwable t) {
                ProxyConnection.this.LOG.warn("Unable to record bytesRead", t);
            }
            finally {
                super.channelRead(ctx, msg);
            }
        }

        protected abstract void bytesRead(int var1);
    }
}

