/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.proxy.impl;

import org.littleshoot.proxy.impl.ProxyConnection;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;
import org.slf4j.spi.LocationAwareLogger;

class ProxyConnectionLogger {
    private final ProxyConnection connection;
    private final LocationAwareLogger logger;
    private final String fqcn = this.getClass().getCanonicalName();

    public ProxyConnectionLogger(ProxyConnection connection) {
        this.connection = connection;
        this.logger = (LocationAwareLogger)LoggerFactory.getLogger(((Object)((Object)connection)).getClass());
    }

    protected void error(String message, Object ... params) {
        if (this.logger.isErrorEnabled()) {
            this.doLog(40, message, params, null);
        }
    }

    protected void error(String message, Throwable t) {
        if (this.logger.isErrorEnabled()) {
            this.doLog(40, message, null, t);
        }
    }

    protected void warn(String message, Object ... params) {
        if (this.logger.isWarnEnabled()) {
            this.doLog(30, message, params, null);
        }
    }

    protected void warn(String message, Throwable t) {
        if (this.logger.isWarnEnabled()) {
            this.doLog(30, message, null, t);
        }
    }

    protected void info(String message, Object ... params) {
        if (this.logger.isInfoEnabled()) {
            this.doLog(20, message, params, null);
        }
    }

    protected void info(String message, Throwable t) {
        if (this.logger.isInfoEnabled()) {
            this.doLog(20, message, null, t);
        }
    }

    protected void debug(String message, Object ... params) {
        if (this.logger.isDebugEnabled()) {
            this.doLog(10, message, params, null);
        }
    }

    protected void debug(String message, Throwable t) {
        if (this.logger.isDebugEnabled()) {
            this.doLog(10, message, null, t);
        }
    }

    private void doLog(int level, String message, Object[] params, Throwable t) {
        String formattedMessage = this.fullMessage(message);
        if (params != null && params.length > 0) {
            formattedMessage = MessageFormatter.arrayFormat((String)formattedMessage, (Object[])params).getMessage();
        }
        this.logger.log(null, this.fqcn, level, formattedMessage, null, t);
    }

    private String fullMessage(String message) {
        String stateMessage = this.connection.getCurrentState().toString();
        if (this.connection.isTunneling()) {
            stateMessage = stateMessage + " {tunneling}";
        }
        String messagePrefix = "(" + stateMessage + ")";
        if (this.connection.channel != null) {
            messagePrefix = messagePrefix + " " + this.connection.channel;
        }
        return messagePrefix + ": " + message;
    }
}

