/*
 * Decompiled with CFR 0.152.
 */
package com.barchart.udt.nio;

import com.barchart.udt.SocketUDT;
import com.barchart.udt.TypeUDT;
import com.barchart.udt.anno.ThreadSafe;
import com.barchart.udt.nio.ChannelUDT;
import com.barchart.udt.nio.KindUDT;
import com.barchart.udt.nio.NioServerSocketUDT;
import com.barchart.udt.nio.SelectorProviderUDT;
import com.barchart.udt.nio.SocketChannelUDT;
import java.io.IOException;
import java.nio.channels.ServerSocketChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerSocketChannelUDT
extends ServerSocketChannel
implements ChannelUDT {
    protected static final Logger log = LoggerFactory.getLogger(ServerSocketChannelUDT.class);
    @ThreadSafe(value="this")
    protected NioServerSocketUDT socketAdapter;
    protected final SocketUDT socketUDT;

    protected ServerSocketChannelUDT(SelectorProviderUDT provider, SocketUDT socketUDT) {
        super(provider);
        this.socketUDT = socketUDT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SocketChannelUDT accept() throws IOException {
        try {
            this.begin();
            SocketUDT clientUDT = this.socketUDT.accept();
            if (clientUDT == null) {
                SocketChannelUDT socketChannelUDT = null;
                return socketChannelUDT;
            }
            SocketChannelUDT socketChannelUDT = new SocketChannelUDT(this.providerUDT(), clientUDT, clientUDT.isConnected());
            return socketChannelUDT;
        }
        finally {
            this.end(true);
        }
    }

    @Override
    protected void implCloseSelectableChannel() throws IOException {
        this.socketUDT.close();
    }

    @Override
    protected void implConfigureBlocking(boolean block) throws IOException {
        this.socketUDT.setBlocking(block);
    }

    @Override
    public boolean isConnectFinished() {
        return true;
    }

    @Override
    public KindUDT kindUDT() {
        return KindUDT.ACCEPTOR;
    }

    @Override
    public SelectorProviderUDT providerUDT() {
        return (SelectorProviderUDT)super.provider();
    }

    @Override
    public synchronized NioServerSocketUDT socket() {
        if (this.socketAdapter == null) {
            try {
                this.socketAdapter = new NioServerSocketUDT(this);
            }
            catch (Exception e) {
                log.error("failed to make socket", e);
                return null;
            }
        }
        return this.socketAdapter;
    }

    @Override
    public SocketUDT socketUDT() {
        return this.socketUDT;
    }

    public String toString() {
        return this.socketUDT.toString();
    }

    @Override
    public TypeUDT typeUDT() {
        return this.providerUDT().type();
    }
}

