/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.dnssec4j;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.SocketFactory;
import org.littleshoot.dnssec4j.DNSSECException;
import org.littleshoot.dnssec4j.DnsSec;

public class VerifiedSocketFactory
extends SocketFactory {
    private final SocketFactory delegate;

    public VerifiedSocketFactory(SocketFactory delegate) {
        this.delegate = delegate;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        try {
            InetAddress isa = DnsSec.getByName(host);
            return this.delegate.createSocket(isa, port);
        }
        catch (DNSSECException e) {
            throw new IOException("DNSSEC verification error!!", e);
        }
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        try {
            InetAddress isa = DnsSec.getByName(host.getHostName());
            return this.delegate.createSocket(isa, port);
        }
        catch (DNSSECException e) {
            throw new IOException("DNSSEC verification error!!", e);
        }
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        try {
            InetAddress isa = DnsSec.getByName(host);
            return this.delegate.createSocket(isa, port, localHost, localPort);
        }
        catch (DNSSECException e) {
            throw new IOException("DNSSEC verification error!!", e);
        }
    }

    @Override
    public Socket createSocket(InetAddress host, int port, InetAddress localAddress, int localPort) throws IOException {
        try {
            InetAddress isa = DnsSec.getByName(host.getHostName());
            return this.delegate.createSocket(isa, port, localAddress, localPort);
        }
        catch (DNSSECException e) {
            throw new IOException("DNSSEC verification error!!", e);
        }
    }
}

