/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.proxy.impl;

import io.netty.bootstrap.ChannelFactory;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.udt.nio.NioUdtProvider;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.spi.SelectorProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.littleshoot.proxy.ActivityTracker;
import org.littleshoot.proxy.ChainedProxyManager;
import org.littleshoot.proxy.HttpFiltersSource;
import org.littleshoot.proxy.HttpFiltersSourceAdapter;
import org.littleshoot.proxy.HttpProxyServer;
import org.littleshoot.proxy.HttpProxyServerBootstrap;
import org.littleshoot.proxy.MitmManager;
import org.littleshoot.proxy.ProxyAuthenticator;
import org.littleshoot.proxy.SslEngineSource;
import org.littleshoot.proxy.TransportProtocol;
import org.littleshoot.proxy.UnknownTransportProtocolError;
import org.littleshoot.proxy.impl.ClientToProxyConnection;
import org.littleshoot.proxy.impl.NetworkUtils;
import org.littleshoot.proxy.impl.ProxyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHttpProxyServer
implements HttpProxyServer {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultHttpProxyServer.class);
    private final ServerGroup serverGroup;
    private final TransportProtocol transportProtocol;
    private final InetSocketAddress address;
    private final SslEngineSource sslEngineSource;
    private final boolean authenticateSslClients;
    private final ProxyAuthenticator proxyAuthenticator;
    private final ChainedProxyManager chainProxyManager;
    private final MitmManager mitmManager;
    private final HttpFiltersSource filtersSource;
    private final boolean useDnsSec;
    private final boolean transparent;
    private volatile int idleConnectionTimeout;
    private final Collection<ActivityTracker> activityTrackers = new ConcurrentLinkedQueue<ActivityTracker>();

    public static HttpProxyServerBootstrap bootstrap() {
        return new DefaultHttpProxyServerBootstrap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpProxyServerBootstrap bootstrapFromFile(String path) {
        File propsFile = new File(path);
        Properties props = new Properties();
        if (propsFile.isFile()) {
            FileInputStream is = null;
            try {
                is = new FileInputStream(propsFile);
                props.load(is);
            }
            catch (IOException e) {
                try {
                    LOG.warn("Could not load props file?", e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    throw throwable;
                }
                IOUtils.closeQuietly(is);
            }
            IOUtils.closeQuietly(is);
        }
        return new DefaultHttpProxyServerBootstrap(props);
    }

    private DefaultHttpProxyServer(String name, TransportProtocol transportProtocol, InetSocketAddress address, SslEngineSource sslEngineSource, boolean authenticateSslClients, ProxyAuthenticator proxyAuthenticator, ChainedProxyManager chainProxyManager, MitmManager mitmManager, HttpFiltersSource filterSource, boolean useDnsSec, boolean transparent, int idleConnectionTimeout, Collection<ActivityTracker> activityTrackers) {
        this(new ServerGroup(name), transportProtocol, address, sslEngineSource, authenticateSslClients, proxyAuthenticator, chainProxyManager, mitmManager, filterSource, useDnsSec, transparent, idleConnectionTimeout, activityTrackers);
    }

    private DefaultHttpProxyServer(ServerGroup serverGroup, TransportProtocol transportProtocol, InetSocketAddress address, SslEngineSource sslEngineSource, boolean authenticateSslClients, ProxyAuthenticator proxyAuthenticator, ChainedProxyManager chainProxyManager, MitmManager mitmManager, HttpFiltersSource filtersSource, boolean useDnsSec, boolean transparent, int idleConnectionTimeout, Collection<ActivityTracker> activityTrackers) {
        this.serverGroup = serverGroup;
        this.transportProtocol = transportProtocol;
        this.address = address;
        this.sslEngineSource = sslEngineSource;
        this.authenticateSslClients = authenticateSslClients;
        this.proxyAuthenticator = proxyAuthenticator;
        this.chainProxyManager = chainProxyManager;
        this.mitmManager = mitmManager;
        this.filtersSource = filtersSource;
        this.useDnsSec = useDnsSec;
        this.transparent = transparent;
        this.idleConnectionTimeout = idleConnectionTimeout;
        if (activityTrackers != null) {
            this.activityTrackers.addAll(activityTrackers);
        }
    }

    boolean isUseDnsSec() {
        return this.useDnsSec;
    }

    boolean isTransparent() {
        return this.transparent;
    }

    @Override
    public int getIdleConnectionTimeout() {
        return this.idleConnectionTimeout;
    }

    @Override
    public void setIdleConnectionTimeout(int idleConnectionTimeout) {
        this.idleConnectionTimeout = idleConnectionTimeout;
    }

    @Override
    public InetSocketAddress getListenAddress() {
        return this.address;
    }

    @Override
    public HttpProxyServerBootstrap clone() {
        return new DefaultHttpProxyServerBootstrap(this, this.transportProtocol, new InetSocketAddress(this.address.getAddress(), this.address.getPort() + 1), this.sslEngineSource, this.authenticateSslClients, this.proxyAuthenticator, this.chainProxyManager, this.mitmManager, this.filtersSource, this.useDnsSec, this.transparent, this.idleConnectionTimeout, this.activityTrackers);
    }

    @Override
    public void stop() {
        this.serverGroup.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpProxyServer start() {
        LOG.info("Starting proxy at address: " + this.address);
        ServerGroup serverGroup = this.serverGroup;
        synchronized (serverGroup) {
            if (this.serverGroup.stopped) {
                throw new Error("Already stopped");
            }
            this.doStart();
        }
        return this;
    }

    private void doStart() {
        ServerBootstrap serverBootstrap = new ServerBootstrap().group((EventLoopGroup)this.serverGroup.clientToProxyBossPools.get((Object)this.transportProtocol), (EventLoopGroup)this.serverGroup.clientToProxyWorkerPools.get((Object)this.transportProtocol));
        ChannelInitializer<Channel> initializer = new ChannelInitializer<Channel>(){

            @Override
            protected void initChannel(Channel ch) throws Exception {
                new ClientToProxyConnection(DefaultHttpProxyServer.this, DefaultHttpProxyServer.this.sslEngineSource, DefaultHttpProxyServer.this.authenticateSslClients, ch.pipeline());
            }
        };
        switch (this.transportProtocol) {
            case TCP: {
                LOG.info("Proxy listening with TCP transport");
                serverBootstrap.channelFactory(new ChannelFactory<ServerChannel>(){

                    @Override
                    public ServerChannel newChannel() {
                        return new NioServerSocketChannel();
                    }
                });
                break;
            }
            case UDT: {
                LOG.info("Proxy listening with UDT transport");
                ((ServerBootstrap)((ServerBootstrap)serverBootstrap.channelFactory(NioUdtProvider.BYTE_ACCEPTOR)).option(ChannelOption.SO_BACKLOG, 10)).option(ChannelOption.SO_REUSEADDR, true);
                break;
            }
            default: {
                throw new UnknownTransportProtocolError(this.transportProtocol);
            }
        }
        serverBootstrap.childHandler(initializer);
        serverBootstrap.bind(this.address).addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                DefaultHttpProxyServer.this.registerChannel(future.channel());
            }
        }).awaitUninterruptibly();
    }

    protected void registerChannel(Channel channel) {
        this.serverGroup.allChannels.add(channel);
    }

    protected ChainedProxyManager getChainProxyManager() {
        return this.chainProxyManager;
    }

    protected MitmManager getMitmManager() {
        return this.mitmManager;
    }

    protected SslEngineSource getSslEngineSource() {
        return this.sslEngineSource;
    }

    protected ProxyAuthenticator getProxyAuthenticator() {
        return this.proxyAuthenticator;
    }

    public HttpFiltersSource getFiltersSource() {
        return this.filtersSource;
    }

    protected Collection<ActivityTracker> getActivityTrackers() {
        return this.activityTrackers;
    }

    protected EventLoopGroup getProxyToServerWorkerFor(TransportProtocol transportProtocol) {
        return (EventLoopGroup)this.serverGroup.proxyToServerWorkerPools.get((Object)transportProtocol);
    }

    private static class DefaultHttpProxyServerBootstrap
    implements HttpProxyServerBootstrap {
        private String name = "LittleProxy";
        private TransportProtocol transportProtocol = TransportProtocol.TCP;
        private InetSocketAddress address;
        private int port = 8080;
        private boolean allowLocalOnly = true;
        private boolean listenOnAllAddresses = true;
        private SslEngineSource sslEngineSource = null;
        private boolean authenticateSslClients = true;
        private ProxyAuthenticator proxyAuthenticator = null;
        private ChainedProxyManager chainProxyManager = null;
        private MitmManager mitmManager = null;
        private HttpFiltersSource filtersSource = new HttpFiltersSourceAdapter();
        private boolean useDnsSec = false;
        private boolean transparent = false;
        private int idleConnectionTimeout = 70;
        private DefaultHttpProxyServer original;
        private Collection<ActivityTracker> activityTrackers = new ConcurrentLinkedQueue<ActivityTracker>();

        private DefaultHttpProxyServerBootstrap() {
        }

        private DefaultHttpProxyServerBootstrap(DefaultHttpProxyServer original, TransportProtocol transportProtocol, InetSocketAddress address, SslEngineSource sslEngineSource, boolean authenticateSslClients, ProxyAuthenticator proxyAuthenticator, ChainedProxyManager chainProxyManager, MitmManager mitmManager, HttpFiltersSource filtersSource, boolean useDnsSec, boolean transparent, int idleConnectionTimeout, Collection<ActivityTracker> activityTrackers) {
            this.original = original;
            this.transportProtocol = transportProtocol;
            this.address = address;
            this.port = address.getPort();
            this.sslEngineSource = sslEngineSource;
            this.authenticateSslClients = authenticateSslClients;
            this.proxyAuthenticator = proxyAuthenticator;
            this.chainProxyManager = chainProxyManager;
            this.filtersSource = filtersSource;
            this.useDnsSec = useDnsSec;
            this.transparent = transparent;
            this.idleConnectionTimeout = idleConnectionTimeout;
            if (activityTrackers != null) {
                this.activityTrackers.addAll(activityTrackers);
            }
        }

        private DefaultHttpProxyServerBootstrap(Properties props) {
            this.useDnsSec = ProxyUtils.extractBooleanDefaultFalse(props, "dnssec");
            this.transparent = ProxyUtils.extractBooleanDefaultFalse(props, "transparent");
            this.idleConnectionTimeout = ProxyUtils.extractInt(props, "idle_connection_timeout");
        }

        @Override
        public HttpProxyServerBootstrap withName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public HttpProxyServerBootstrap withTransportProtocol(TransportProtocol transportProtocol) {
            this.transportProtocol = transportProtocol;
            return this;
        }

        @Override
        public HttpProxyServerBootstrap withAddress(InetSocketAddress address) {
            this.address = address;
            return this;
        }

        @Override
        public HttpProxyServerBootstrap withPort(int port) {
            this.address = null;
            this.port = port;
            return this;
        }

        @Override
        public HttpProxyServerBootstrap withAllowLocalOnly(boolean allowLocalOnly) {
            this.allowLocalOnly = allowLocalOnly;
            return this;
        }

        @Override
        public HttpProxyServerBootstrap withListenOnAllAddresses(boolean listenOnAllAddresses) {
            this.listenOnAllAddresses = listenOnAllAddresses;
            return this;
        }

        @Override
        public HttpProxyServerBootstrap withSslEngineSource(SslEngineSource sslEngineSource) {
            this.sslEngineSource = sslEngineSource;
            return this;
        }

        @Override
        public HttpProxyServerBootstrap withAuthenticateSslClients(boolean authenticateSslClients) {
            this.authenticateSslClients = authenticateSslClients;
            return this;
        }

        @Override
        public HttpProxyServerBootstrap withProxyAuthenticator(ProxyAuthenticator proxyAuthenticator) {
            this.proxyAuthenticator = proxyAuthenticator;
            return this;
        }

        @Override
        public HttpProxyServerBootstrap withChainProxyManager(ChainedProxyManager chainProxyManager) {
            this.chainProxyManager = chainProxyManager;
            if (this.mitmManager != null) {
                LOG.warn("Enabled proxy chaining with man in the middle.  These are mutually exclusive - man in the middle will be disabled.");
                this.mitmManager = null;
            }
            return this;
        }

        @Override
        public HttpProxyServerBootstrap withManInTheMiddle(MitmManager mitmManager) {
            this.mitmManager = mitmManager;
            if (this.chainProxyManager != null) {
                LOG.warn("Enabled man in the middle along with proxy chaining.  These are mutually exclusive - proxy chaining will be disabled.");
                this.chainProxyManager = null;
            }
            return this;
        }

        @Override
        public HttpProxyServerBootstrap withFiltersSource(HttpFiltersSource filtersSource) {
            this.filtersSource = filtersSource;
            return this;
        }

        @Override
        public HttpProxyServerBootstrap withUseDnsSec(boolean useDnsSec) {
            this.useDnsSec = useDnsSec;
            return this;
        }

        @Override
        public HttpProxyServerBootstrap withTransparent(boolean transparent) {
            this.transparent = transparent;
            return this;
        }

        @Override
        public HttpProxyServerBootstrap withIdleConnectionTimeout(int idleConnectionTimeout) {
            this.idleConnectionTimeout = idleConnectionTimeout;
            return this;
        }

        @Override
        public HttpProxyServerBootstrap plusActivityTracker(ActivityTracker activityTracker) {
            this.activityTrackers.add(activityTracker);
            return this;
        }

        @Override
        public HttpProxyServer start() {
            return this.build().start();
        }

        private DefaultHttpProxyServer build() {
            if (this.original != null) {
                return new DefaultHttpProxyServer(this.original.serverGroup, this.transportProtocol, this.determineListenAddress(), this.sslEngineSource, this.authenticateSslClients, this.proxyAuthenticator, this.chainProxyManager, this.mitmManager, this.filtersSource, this.useDnsSec, this.transparent, this.idleConnectionTimeout, this.activityTrackers);
            }
            return new DefaultHttpProxyServer(this.name, this.transportProtocol, this.determineListenAddress(), this.sslEngineSource, this.authenticateSslClients, this.proxyAuthenticator, this.chainProxyManager, this.mitmManager, this.filtersSource, this.useDnsSec, this.transparent, this.idleConnectionTimeout, this.activityTrackers);
        }

        private InetSocketAddress determineListenAddress() {
            if (this.address != null) {
                return this.address;
            }
            if (this.allowLocalOnly) {
                return new InetSocketAddress("127.0.0.1", this.port);
            }
            if (this.listenOnAllAddresses) {
                return new InetSocketAddress(this.port);
            }
            try {
                return new InetSocketAddress(NetworkUtils.getLocalHost(), this.port);
            }
            catch (UnknownHostException e) {
                LOG.error("Could not get local host?", e);
                return new InetSocketAddress(this.port);
            }
        }
    }

    private static class ServerGroup {
        private static final int INCOMING_ACCEPTOR_THREADS = 2;
        private static final int INCOMING_WORKER_THREADS = 8;
        private static final int OUTGOING_WORKER_THREADS = 8;
        private final String name;
        private final ChannelGroup allChannels = new DefaultChannelGroup("HTTP-Proxy-Server", GlobalEventExecutor.INSTANCE);
        private final Map<TransportProtocol, EventLoopGroup> clientToProxyBossPools = new ConcurrentHashMap<TransportProtocol, EventLoopGroup>();
        private final Map<TransportProtocol, EventLoopGroup> clientToProxyWorkerPools = new ConcurrentHashMap<TransportProtocol, EventLoopGroup>();
        private final Map<TransportProtocol, EventLoopGroup> proxyToServerWorkerPools = new ConcurrentHashMap<TransportProtocol, EventLoopGroup>();
        private volatile boolean stopped = false;

        private ServerGroup(String name) {
            this.name = name;
            for (TransportProtocol transportProtocol : TransportProtocol.values()) {
                try {
                    this.initializeTransport(transportProtocol);
                }
                catch (Throwable t) {
                    LOG.warn("Unable to initialize transport protocol {}: {}", new Object[]{transportProtocol, t.getMessage(), t});
                }
            }
            Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    LOG.error("Uncaught throwable", e);
                }
            });
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    ServerGroup.this.stop();
                }
            }));
        }

        private void initializeTransport(TransportProtocol transportProtocol) {
            SelectorProvider selectorProvider = null;
            switch (transportProtocol) {
                case TCP: {
                    selectorProvider = SelectorProvider.provider();
                    break;
                }
                case UDT: {
                    selectorProvider = NioUdtProvider.BYTE_PROVIDER;
                    break;
                }
                default: {
                    throw new UnknownTransportProtocolError(transportProtocol);
                }
            }
            NioEventLoopGroup inboundAcceptorGroup = new NioEventLoopGroup(2, (ThreadFactory)new CategorizedThreadFactory("ClientToProxyAcceptor"), selectorProvider);
            NioEventLoopGroup inboundWorkerGroup = new NioEventLoopGroup(8, (ThreadFactory)new CategorizedThreadFactory("ClientToProxyWorker"), selectorProvider);
            inboundWorkerGroup.setIoRatio(90);
            NioEventLoopGroup outboundWorkerGroup = new NioEventLoopGroup(8, (ThreadFactory)new CategorizedThreadFactory("ProxyToServerWorker"), selectorProvider);
            outboundWorkerGroup.setIoRatio(90);
            this.clientToProxyBossPools.put(transportProtocol, inboundAcceptorGroup);
            this.clientToProxyWorkerPools.put(transportProtocol, inboundWorkerGroup);
            this.proxyToServerWorkerPools.put(transportProtocol, outboundWorkerGroup);
        }

        private synchronized void stop() {
            LOG.info("Shutting down proxy");
            if (this.stopped) {
                LOG.info("Already stopped");
                return;
            }
            LOG.info("Closing all channels...");
            ChannelGroupFuture future = this.allChannels.close();
            future.awaitUninterruptibly(10000L);
            if (!future.isSuccess()) {
                for (ChannelFuture cf : future) {
                    if (cf.isSuccess()) continue;
                    LOG.info("Unable to close channel.  Cause of failure for {} is {}", (Object)cf.channel(), (Object)cf.cause());
                }
            }
            LOG.info("Shutting down event loops");
            ArrayList<EventLoopGroup> allEventLoopGroups = new ArrayList<EventLoopGroup>();
            allEventLoopGroups.addAll(this.clientToProxyBossPools.values());
            allEventLoopGroups.addAll(this.clientToProxyWorkerPools.values());
            allEventLoopGroups.addAll(this.proxyToServerWorkerPools.values());
            for (EventLoopGroup group : allEventLoopGroups) {
                group.shutdownGracefully();
            }
            for (EventLoopGroup group : allEventLoopGroups) {
                try {
                    group.awaitTermination(60L, TimeUnit.SECONDS);
                }
                catch (InterruptedException ie) {
                    LOG.warn("Interrupted while shutting down event loop");
                }
            }
            this.stopped = true;
            LOG.info("Done shutting down proxy");
        }

        private class CategorizedThreadFactory
        implements ThreadFactory {
            private String category;
            private int num = 0;

            public CategorizedThreadFactory(String category) {
                this.category = category;
            }

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, ServerGroup.this.name + "-" + this.category + "-" + this.num++);
                return t;
            }
        }
    }
}

