/*
 * Decompiled with CFR 0.152.
 */
package com.barchart.udt;

import com.barchart.udt.ErrorUDT;
import com.barchart.udt.ExceptionUDT;
import com.barchart.udt.LingerUDT;
import com.barchart.udt.MonitorUDT;
import com.barchart.udt.OptionUDT;
import com.barchart.udt.ResourceUDT;
import com.barchart.udt.StatusUDT;
import com.barchart.udt.TypeUDT;
import com.barchart.udt.anno.Native;
import com.barchart.udt.lib.LibraryLoader;
import com.barchart.udt.util.HelpUDT;
import java.io.File;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketUDT {
    public static final int DEFAULT_ACCEPT_QUEUE_SIZE = 256;
    public static final int DEFAULT_FILE_BLOCK_SIZE = 0x100000;
    public static final int DEFAULT_MAX_SELECTOR_SIZE = 1024;
    public static final int DEFAULT_MIN_SELECTOR_TIMEOUT = 10;
    public static final int INFINITE_TTL = -1;
    @Native
    public static boolean INIT_OK = false;
    protected static final Logger log = LoggerFactory.getLogger(SocketUDT.class);
    @Native
    public static final int SIGNATURE_JNI = 20130512;
    public static final int TIMEOUT_INFINITE = -1;
    public static long TIMEOUT_NONE = 0L;
    @Native
    public static final int UDT_EXCEPT_INDEX = 2;
    @Native
    public static final int UDT_READ_INDEX = 0;
    @Native
    public static final int UDT_SIZE_COUNT = 3;
    @Native
    public static final int UDT_WRITE_INDEX = 1;
    private volatile int listenQueueSize;
    @Native
    private volatile InetSocketAddress localSocketAddress;
    private volatile boolean messageIsOrdered;
    private volatile int messageTimeTolive;
    @Native
    private final MonitorUDT monitor;
    @Native
    private volatile InetSocketAddress remoteSocketAddress;
    @Native
    private final int socketAddressFamily;
    @Native
    private final int socketID;
    @Native
    private final TypeUDT type;

    public static void cleanup() throws ExceptionUDT {
        SocketUDT.stopClass0();
    }

    protected static native void epollAdd0(int var0, int var1, int var2) throws ExceptionUDT;

    protected static native int epollCreate0() throws ExceptionUDT;

    protected static native void epollRelease0(int var0) throws ExceptionUDT;

    protected static native void epollRemove0(int var0, int var1) throws ExceptionUDT;

    protected static native void epollUpdate0(int var0, int var1, int var2) throws ExceptionUDT;

    protected static native int epollVerify0(int var0, int var1) throws ExceptionUDT;

    protected static native int epollWait0(int var0, IntBuffer var1, IntBuffer var2, IntBuffer var3, long var4) throws ExceptionUDT;

    protected static native int getSignatureJNI0();

    protected static native void initClass0() throws ExceptionUDT;

    protected static native int receive0(int var0, int var1, byte[] var2) throws ExceptionUDT;

    protected static native int receive1(int var0, int var1, byte[] var2, int var3, int var4) throws ExceptionUDT;

    protected static native int receive2(int var0, int var1, ByteBuffer var2, int var3, int var4) throws ExceptionUDT;

    protected static native long receiveFile0(int var0, String var1, long var2, long var4, int var6) throws ExceptionUDT;

    public static int selectEpoll(int epollId, IntBuffer readBuffer, IntBuffer writeBuffer, IntBuffer sizeBuffer, long millisTimeout) throws ExceptionUDT {
        assert (readBuffer != null && readBuffer.isDirect());
        assert (writeBuffer != null && writeBuffer.isDirect());
        assert (sizeBuffer != null && sizeBuffer.isDirect());
        return SocketUDT.epollWait0(epollId, readBuffer, writeBuffer, sizeBuffer, millisTimeout);
    }

    protected static native int send0(int var0, int var1, int var2, boolean var3, byte[] var4) throws ExceptionUDT;

    protected static native int send1(int var0, int var1, int var2, boolean var3, byte[] var4, int var5, int var6) throws ExceptionUDT;

    protected static native int send2(int var0, int var1, int var2, boolean var3, ByteBuffer var4, int var5, int var6) throws ExceptionUDT;

    protected static native long sendFile0(int var0, String var1, long var2, long var4, int var6) throws ExceptionUDT;

    protected static native void stopClass0() throws ExceptionUDT;

    protected static native void testCrashJVM0();

    protected static native void testDirectByteBufferAccess0(ByteBuffer var0);

    protected static native void testDirectIntBufferAccess0(IntBuffer var0);

    protected static native void testDirectIntBufferLoad0(IntBuffer var0);

    protected static native void testEmptyCall0();

    protected static native void testFillArray0(byte[] var0);

    protected static native void testFillBuffer0(ByteBuffer var0);

    protected static native void testGetSetArray0(int[] var0, boolean var1);

    protected static native void testInvalidClose0(int var0) throws ExceptionUDT;

    protected static native void testIterateArray0(Object[] var0);

    protected static native void testIterateSet0(Set<Object> var0);

    protected static native int[] testMakeArray0(int var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketUDT(TypeUDT type) throws ExceptionUDT {
        Class<SocketUDT> clazz = SocketUDT.class;
        synchronized (SocketUDT.class) {
            this.type = type;
            this.monitor = new MonitorUDT(this);
            this.socketID = this.initInstance0(type.code);
            this.socketAddressFamily = 2;
            this.setDefaultMessageSendMode();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            log.debug("init : {}", (Object)this);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SocketUDT(TypeUDT type, int socketID) throws ExceptionUDT {
        Class<SocketUDT> clazz = SocketUDT.class;
        synchronized (SocketUDT.class) {
            this.type = type;
            this.monitor = new MonitorUDT(this);
            this.socketID = this.initInstance1(socketID);
            this.socketAddressFamily = 2;
            this.setDefaultMessageSendMode();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            log.debug("init : {}", (Object)this);
            return;
        }
    }

    public SocketUDT accept() throws ExceptionUDT {
        return this.accept0();
    }

    protected native SocketUDT accept0() throws ExceptionUDT;

    public void bind(InetSocketAddress localSocketAddress) throws ExceptionUDT, IllegalArgumentException {
        HelpUDT.checkSocketAddress(localSocketAddress);
        this.bind0(localSocketAddress);
    }

    protected native void bind0(InetSocketAddress var1) throws ExceptionUDT;

    public void clearError() {
        this.clearError0();
    }

    protected native void clearError0();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws ExceptionUDT {
        Class<SocketUDT> clazz = SocketUDT.class;
        synchronized (SocketUDT.class) {
            switch (this.status()) {
                case INIT: 
                case OPENED: 
                case LISTENING: 
                case CONNECTING: 
                case CONNECTED: 
                case BROKEN: {
                    this.close0();
                    log.debug("done : {}", (Object)this);
                    break;
                }
                case CLOSING: 
                case CLOSED: 
                case NONEXIST: {
                    log.debug("dead : {}", (Object)this);
                    break;
                }
                default: {
                    log.error("Invalid socket/status {}/{}", (Object)this, (Object)this.status());
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected native void close0() throws ExceptionUDT;

    public void connect(InetSocketAddress remoteSocketAddress) throws ExceptionUDT {
        HelpUDT.checkSocketAddress(remoteSocketAddress);
        this.connect0(remoteSocketAddress);
    }

    protected native void connect0(InetSocketAddress var1) throws ExceptionUDT;

    public boolean equals(Object otherSocketUDT) {
        if (otherSocketUDT instanceof SocketUDT) {
            SocketUDT other = (SocketUDT)otherSocketUDT;
            return other.socketID == this.socketID;
        }
        return false;
    }

    protected void finalize() {
        try {
            this.close();
            super.finalize();
        }
        catch (Throwable e) {
            log.error("failed to close id=" + this.socketID, e);
        }
    }

    public ErrorUDT getError() {
        int code = this.getErrorCode();
        return ErrorUDT.errorFrom(code);
    }

    public int getErrorCode() {
        return this.getErrorCode0();
    }

    protected native int getErrorCode0();

    public String getErrorMessage() {
        return this.getErrorMessage0();
    }

    protected native String getErrorMessage0();

    public int getListenQueueSize() {
        return this.listenQueueSize;
    }

    public InetAddress getLocalInetAddress() {
        try {
            InetSocketAddress local = this.getLocalSocketAddress();
            if (local == null) {
                return null;
            }
            return local.getAddress();
        }
        catch (Exception e) {
            log.debug("failed to get local address", e);
            return null;
        }
    }

    public int getLocalInetPort() {
        try {
            InetSocketAddress local = this.getLocalSocketAddress();
            if (local == null) {
                return 0;
            }
            return local.getPort();
        }
        catch (Exception e) {
            log.debug("failed to get local port", e);
            return 0;
        }
    }

    public InetSocketAddress getLocalSocketAddress() throws ExceptionUDT {
        if (this.hasLoadedLocalSocketAddress()) {
            return this.localSocketAddress;
        }
        return null;
    }

    public boolean getMessageIsOdered() {
        return this.messageIsOrdered;
    }

    public int getMessageTimeTolLive() {
        return this.messageTimeTolive;
    }

    public <T> T getOption(OptionUDT<T> option) throws ExceptionUDT {
        if (option == null) {
            throw new IllegalArgumentException("option == null");
        }
        return (T)this.getOption0(option.code(), option.type());
    }

    protected native Object getOption0(int var1, Class<?> var2) throws ExceptionUDT;

    public int getReceiveBufferSize() throws ExceptionUDT {
        int protocolSize = this.getOption(OptionUDT.Protocol_Receive_Buffer_Size);
        int kernelSize = this.getOption(OptionUDT.System_Receive_Buffer_Size);
        return Math.min(protocolSize, kernelSize);
    }

    public InetAddress getRemoteInetAddress() {
        try {
            InetSocketAddress remote = this.getRemoteSocketAddress();
            if (remote == null) {
                return null;
            }
            return remote.getAddress();
        }
        catch (Exception e) {
            log.debug("failed to get remote address", e);
            return null;
        }
    }

    public int getRemoteInetPort() {
        try {
            InetSocketAddress remote = this.getRemoteSocketAddress();
            if (remote == null) {
                return 0;
            }
            return remote.getPort();
        }
        catch (Exception e) {
            log.debug("failed to get remote port", e);
            return 0;
        }
    }

    public InetSocketAddress getRemoteSocketAddress() throws ExceptionUDT {
        if (this.hasLoadedRemoteSocketAddress()) {
            return this.remoteSocketAddress;
        }
        return null;
    }

    public boolean getReuseAddress() throws ExceptionUDT {
        return this.getOption(OptionUDT.Is_Address_Reuse_Enabled);
    }

    public int getSendBufferSize() throws ExceptionUDT {
        int protocolSize = this.getOption(OptionUDT.Protocol_Send_Buffer_Size);
        int kernelSize = this.getOption(OptionUDT.System_Send_Buffer_Size);
        return Math.min(protocolSize, kernelSize);
    }

    public int getSoLinger() throws ExceptionUDT {
        return this.getOption(OptionUDT.Time_To_Linger_On_Close).intValue();
    }

    public int getSoTimeout() throws ExceptionUDT {
        int millisTimeout;
        int receiveTimeout;
        int sendTimeout = this.getOption(OptionUDT.Send_Timeout);
        if (sendTimeout != (receiveTimeout = this.getOption(OptionUDT.Receive_Timeout).intValue())) {
            log.error("sendTimeout != receiveTimeout");
            millisTimeout = Math.max(sendTimeout, receiveTimeout);
        } else if (sendTimeout < 0) {
            millisTimeout = 0;
        } else if (sendTimeout > 0) {
            millisTimeout = sendTimeout;
        } else {
            log.error("UDT reported unexpected zero timeout");
            millisTimeout = -1;
        }
        return millisTimeout;
    }

    protected native int getStatus0();

    public int hashCode() {
        return this.socketID;
    }

    protected native boolean hasLoadedLocalSocketAddress();

    protected native boolean hasLoadedRemoteSocketAddress();

    public int id() {
        return this.socketID;
    }

    protected native int initInstance0(int var1) throws ExceptionUDT;

    protected native int initInstance1(int var1) throws ExceptionUDT;

    public boolean isBlocking() {
        try {
            if (this.isOpen()) {
                boolean isReceiveBlocking = this.getOption(OptionUDT.Is_Receive_Synchronous);
                boolean isSendBlocking = this.getOption(OptionUDT.Is_Send_Synchronous);
                return isReceiveBlocking && isSendBlocking;
            }
        }
        catch (Exception e) {
            log.error("failed to get option", e);
        }
        return false;
    }

    public boolean isBound() {
        switch (this.status()) {
            case OPENED: 
            case LISTENING: 
            case CONNECTING: 
            case CONNECTED: {
                return true;
            }
        }
        return false;
    }

    public boolean isClosed() {
        return !this.isOpen();
    }

    public boolean isConnected() {
        switch (this.status()) {
            case CONNECTED: {
                return true;
            }
        }
        return false;
    }

    public boolean isNonBlocking() {
        try {
            if (this.isOpen()) {
                boolean isReceiveBlocking = this.getOption(OptionUDT.Is_Receive_Synchronous);
                boolean isSendBlocking = this.getOption(OptionUDT.Is_Send_Synchronous);
                return !isReceiveBlocking && !isSendBlocking;
            }
        }
        catch (Exception e) {
            log.error("failed to get option", e);
        }
        return false;
    }

    public boolean isOpen() {
        switch (this.status()) {
            case INIT: 
            case OPENED: 
            case LISTENING: 
            case CONNECTING: 
            case CONNECTED: {
                return true;
            }
        }
        return false;
    }

    public boolean isRendezvous() {
        try {
            if (this.isOpen()) {
                return this.getOption(OptionUDT.Is_Randezvous_Connect_Enabled);
            }
        }
        catch (Exception e) {
            log.error("failed to get option", e);
        }
        return false;
    }

    public void listen(int queueSize) throws ExceptionUDT {
        if (queueSize <= 0) {
            throw new IllegalArgumentException("queueSize <= 0");
        }
        this.listenQueueSize = queueSize;
        this.listen0(queueSize);
    }

    protected native void listen0(int var1) throws ExceptionUDT;

    public MonitorUDT monitor() {
        return this.monitor;
    }

    public int receive(byte[] array) throws ExceptionUDT {
        HelpUDT.checkArray(array);
        return SocketUDT.receive0(this.socketID, this.type.code, array);
    }

    public int receive(byte[] array, int position, int limit) throws ExceptionUDT {
        HelpUDT.checkArray(array);
        return SocketUDT.receive1(this.socketID, this.type.code, array, position, limit);
    }

    public int receive(ByteBuffer buffer) throws ExceptionUDT {
        HelpUDT.checkBuffer(buffer);
        int position = buffer.position();
        int limit = buffer.limit();
        int remaining = buffer.remaining();
        int sizeReceived = SocketUDT.receive2(this.socketID, this.type.code, buffer, position, limit);
        if (sizeReceived <= 0) {
            return sizeReceived;
        }
        if (sizeReceived <= remaining) {
            buffer.position(position + sizeReceived);
            return sizeReceived;
        }
        log.error("sizeReceived > remaining");
        return 0;
    }

    public long receiveFile(File file, long offset, long length) throws ExceptionUDT {
        if (this.type == TypeUDT.DATAGRAM) {
            throw new IllegalStateException("invalid socket type : " + (Object)((Object)this.type));
        }
        if (!(file != null && file.exists() && file.isFile() && file.canWrite())) {
            throw new IllegalArgumentException("invalid file : " + file);
        }
        if (offset < 0L || offset > file.length()) {
            throw new IllegalArgumentException("invalid offset : " + offset);
        }
        if (length < 0L || offset + length > file.length()) {
            throw new IllegalArgumentException("invalid length : " + length);
        }
        String path = file.getAbsolutePath();
        int block = length > 0x100000L ? 0x100000 : (int)length;
        return SocketUDT.receiveFile0(this.id(), path, offset, length, block);
    }

    public int send(byte[] array) throws ExceptionUDT {
        HelpUDT.checkArray(array);
        return SocketUDT.send0(this.socketID, this.type.code, this.messageTimeTolive, this.messageIsOrdered, array);
    }

    public int send(byte[] array, int position, int limit) throws ExceptionUDT {
        HelpUDT.checkArray(array);
        return SocketUDT.send1(this.socketID, this.type.code, this.messageTimeTolive, this.messageIsOrdered, array, position, limit);
    }

    public int send(ByteBuffer buffer) throws ExceptionUDT {
        HelpUDT.checkBuffer(buffer);
        int position = buffer.position();
        int limit = buffer.limit();
        int remaining = buffer.remaining();
        int sizeSent = SocketUDT.send2(this.socketID, this.type.code, this.messageTimeTolive, this.messageIsOrdered, buffer, position, limit);
        if (sizeSent <= 0) {
            return sizeSent;
        }
        if (sizeSent <= remaining) {
            buffer.position(position + sizeSent);
            return sizeSent;
        }
        log.error("sizeSent > remaining");
        return 0;
    }

    public long sendFile(File file, long offset, long length) throws ExceptionUDT {
        if (this.type == TypeUDT.DATAGRAM) {
            throw new IllegalStateException("invalid socket type : " + (Object)((Object)this.type));
        }
        if (!(file != null && file.exists() && file.isFile() && file.canRead())) {
            throw new IllegalArgumentException("invalid file : " + file);
        }
        if (offset < 0L || offset > file.length()) {
            throw new IllegalArgumentException("invalid offset : " + offset);
        }
        if (length < 0L || offset + length > file.length()) {
            throw new IllegalArgumentException("invalid length : " + length);
        }
        String path = file.getAbsolutePath();
        int block = length > 0x100000L ? 0x100000 : (int)length;
        return SocketUDT.sendFile0(this.id(), path, offset, length, block);
    }

    public void setBlocking(boolean block) throws ExceptionUDT {
        if (block) {
            this.setOption(OptionUDT.Is_Receive_Synchronous, Boolean.TRUE);
            this.setOption(OptionUDT.Is_Send_Synchronous, Boolean.TRUE);
        } else {
            this.setOption(OptionUDT.Is_Receive_Synchronous, Boolean.FALSE);
            this.setOption(OptionUDT.Is_Send_Synchronous, Boolean.FALSE);
        }
    }

    public void setDefaultMessageSendMode() {
        this.setMessageIsOdered(true);
        this.setMessageTimeTolLive(-1);
    }

    public void setMessageIsOdered(boolean isOrdered) {
        this.messageIsOrdered = isOrdered;
    }

    public void setMessageTimeTolLive(int timeToLive) {
        this.messageTimeTolive = timeToLive;
    }

    public <T> void setOption(OptionUDT<T> option, T value) throws ExceptionUDT {
        if (option == null || value == null) {
            throw new IllegalArgumentException("option == null || value == null");
        }
        this.setOption0(option.code(), option.type(), value);
    }

    protected native void setOption0(int var1, Class<?> var2, Object var3) throws ExceptionUDT;

    public void setReceiveBufferSize(int size) throws ExceptionUDT {
        this.setOption(OptionUDT.Protocol_Receive_Buffer_Size, size);
        this.setOption(OptionUDT.System_Receive_Buffer_Size, size);
    }

    public void setRendezvous(boolean isOn) throws ExceptionUDT {
        this.setOption(OptionUDT.Is_Randezvous_Connect_Enabled, isOn);
    }

    public void setReuseAddress(boolean on) throws ExceptionUDT {
        this.setOption(OptionUDT.Is_Address_Reuse_Enabled, on);
    }

    public void setSendBufferSize(int size) throws ExceptionUDT {
        this.setOption(OptionUDT.Protocol_Send_Buffer_Size, size);
        this.setOption(OptionUDT.System_Send_Buffer_Size, size);
    }

    public void setSoLinger(boolean on, int linger) throws ExceptionUDT {
        if (on) {
            if (linger <= 0) {
                throw new IllegalArgumentException("linger <= 0");
            }
            this.setOption(OptionUDT.Time_To_Linger_On_Close, new LingerUDT(linger));
        } else {
            this.setOption(OptionUDT.Time_To_Linger_On_Close, LingerUDT.LINGER_ZERO);
        }
    }

    public void setSoTimeout(int millisTimeout) throws ExceptionUDT {
        if (millisTimeout < 0) {
            throw new IllegalArgumentException("timeout < 0");
        }
        if (millisTimeout == 0) {
            millisTimeout = -1;
        }
        this.setOption(OptionUDT.Send_Timeout, millisTimeout);
        this.setOption(OptionUDT.Receive_Timeout, millisTimeout);
    }

    public StatusUDT status() {
        return StatusUDT.from(this.getStatus0());
    }

    public String toString() {
        return String.format("[id: 0x%08x] %s %s bind=%s:%s peer=%s:%s", new Object[]{this.socketID, this.type, this.status(), this.getLocalInetAddress(), this.getLocalInetPort(), this.getRemoteInetAddress(), this.getRemoteInetPort()});
    }

    public String toStringMonitor() {
        try {
            this.updateMonitor(false);
        }
        catch (Exception e) {
            return "failed to update monitor : " + e.getMessage();
        }
        StringBuilder text = new StringBuilder(1024);
        this.monitor.appendSnapshot(text);
        return text.toString();
    }

    public String toStringOptions() {
        StringBuilder text = new StringBuilder(1024);
        OptionUDT.appendSnapshot(this, text);
        return text.toString();
    }

    public TypeUDT type() {
        return this.type;
    }

    public void updateMonitor(boolean makeClear) throws ExceptionUDT {
        this.updateMonitor0(makeClear);
    }

    protected native void updateMonitor0(boolean var1) throws ExceptionUDT;

    static {
        try {
            String location = ResourceUDT.getLibraryExtractLocation();
            log.info("library location : {}", (Object)location);
            String loaderName = ResourceUDT.getLibraryLoaderClassName();
            log.info("loader provider  : {}", (Object)loaderName);
            Class<?> loaderClass = Class.forName(loaderName);
            LibraryLoader loaderInstance = (LibraryLoader)loaderClass.newInstance();
            loaderInstance.load(location);
        }
        catch (Throwable e) {
            log.error("Failed to LOAD native library", e);
            throw new RuntimeException("load", e);
        }
        try {
            SocketUDT.initClass0();
        }
        catch (Throwable e) {
            log.error("Failed to INIT native library", e);
            throw new RuntimeException("init", e);
        }
        if (20130512 != SocketUDT.getSignatureJNI0()) {
            log.error("Java/Native SIGNATURE inconsistent");
            throw new RuntimeException("signature");
        }
        INIT_OK = true;
        log.debug("native library load & init OK");
    }
}

