/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.proxy.impl;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ChannelFactory;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.channel.udt.nio.NioUdtProvider;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpRequestEncoder;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseDecoder;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.ReferenceCounted;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.lang3.StringUtils;
import org.littleshoot.dnssec4j.VerifiedAddressFactory;
import org.littleshoot.proxy.ActivityTracker;
import org.littleshoot.proxy.ChainedProxy;
import org.littleshoot.proxy.ChainedProxyAdapter;
import org.littleshoot.proxy.ChainedProxyManager;
import org.littleshoot.proxy.FullFlowContext;
import org.littleshoot.proxy.HttpFilters;
import org.littleshoot.proxy.MitmManager;
import org.littleshoot.proxy.TransportProtocol;
import org.littleshoot.proxy.UnknownTransportProtocolError;
import org.littleshoot.proxy.impl.ClientToProxyConnection;
import org.littleshoot.proxy.impl.ConnectionFlow;
import org.littleshoot.proxy.impl.ConnectionFlowStep;
import org.littleshoot.proxy.impl.ConnectionState;
import org.littleshoot.proxy.impl.DefaultHttpProxyServer;
import org.littleshoot.proxy.impl.ProxyConnection;
import org.littleshoot.proxy.impl.ProxyUtils;

@ChannelHandler.Sharable
public class ProxyToServerConnection
extends ProxyConnection<HttpResponse> {
    private final ClientToProxyConnection clientConnection;
    private final ProxyToServerConnection serverConnection = this;
    private volatile TransportProtocol transportProtocol;
    private volatile InetSocketAddress remoteAddress;
    private volatile InetSocketAddress localAddress;
    private final String serverHostAndPort;
    private volatile ChainedProxy chainedProxy;
    private final Queue<ChainedProxy> availableChainedProxies;
    private volatile HttpFilters currentFilters;
    private volatile ConnectionFlow connectionFlow;
    private final Object connectLock = new Object();
    private volatile HttpRequest initialRequest;
    private final Queue<HttpRequest> issuedRequests = new LinkedList<HttpRequest>();
    private volatile HttpRequest currentHttpRequest;
    private volatile HttpResponse currentHttpResponse;
    private ConnectionFlowStep ConnectChannel = new ConnectionFlowStep(this, ConnectionState.CONNECTING){

        @Override
        boolean shouldExecuteOnEventLoop() {
            return false;
        }

        @Override
        protected Future<?> execute() {
            Bootstrap cb = (Bootstrap)new Bootstrap().group(ProxyToServerConnection.this.proxyServer.getProxyToServerWorkerFor(ProxyToServerConnection.this.transportProtocol));
            switch (ProxyToServerConnection.this.transportProtocol) {
                case TCP: {
                    ProxyToServerConnection.this.LOG.debug("Connecting to server with TCP", new Object[0]);
                    cb.channelFactory(new ChannelFactory<Channel>(){

                        @Override
                        public Channel newChannel() {
                            return new NioSocketChannel();
                        }
                    });
                    break;
                }
                case UDT: {
                    ProxyToServerConnection.this.LOG.debug("Connecting to server with UDT", new Object[0]);
                    ((Bootstrap)cb.channelFactory(NioUdtProvider.BYTE_CONNECTOR)).option(ChannelOption.SO_REUSEADDR, true);
                    break;
                }
                default: {
                    throw new UnknownTransportProtocolError(ProxyToServerConnection.this.transportProtocol);
                }
            }
            cb.handler(new ChannelInitializer<Channel>(){

                @Override
                protected void initChannel(Channel ch) throws Exception {
                    ProxyToServerConnection.this.initChannelPipeline(ch.pipeline(), ProxyToServerConnection.this.initialRequest);
                }
            });
            cb.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, ProxyToServerConnection.this.proxyServer.getConnectTimeout());
            if (ProxyToServerConnection.this.localAddress != null) {
                return cb.connect(ProxyToServerConnection.this.remoteAddress, ProxyToServerConnection.this.localAddress);
            }
            return cb.connect(ProxyToServerConnection.this.remoteAddress);
        }
    };
    private ConnectionFlowStep HTTPCONNECTWithChainedProxy = new ConnectionFlowStep(this, ConnectionState.AWAITING_CONNECT_OK){

        @Override
        protected Future<?> execute() {
            ProxyToServerConnection.this.LOG.debug("Handling CONNECT request through Chained Proxy", new Object[0]);
            ProxyToServerConnection.this.chainedProxy.filterRequest(ProxyToServerConnection.this.initialRequest);
            return ProxyToServerConnection.this.writeToChannel(ProxyToServerConnection.this.initialRequest);
        }

        @Override
        void onSuccess(ConnectionFlow flow) {
        }

        @Override
        void read(ConnectionFlow flow, Object msg) {
            HttpResponse httpResponse;
            int statusCode;
            boolean connectOk = false;
            if (msg instanceof HttpResponse && (statusCode = (httpResponse = (HttpResponse)msg).getStatus().code()) >= 200 && statusCode <= 299) {
                connectOk = true;
            }
            if (connectOk) {
                flow.advance();
            } else {
                flow.fail();
            }
        }
    };
    private ConnectionFlowStep MitmEncryptClientChannel = new ConnectionFlowStep(this, ConnectionState.HANDSHAKING){

        @Override
        boolean shouldExecuteOnEventLoop() {
            return false;
        }

        @Override
        boolean shouldSuppressInitialRequest() {
            return true;
        }

        @Override
        protected Future<?> execute() {
            return ProxyToServerConnection.this.clientConnection.encrypt(ProxyToServerConnection.this.proxyServer.getMitmManager().clientSslEngineFor(ProxyToServerConnection.this.sslEngine.getSession()), false).addListener((GenericFutureListener<Future<Channel>>)new GenericFutureListener<Future<? super Channel>>(){

                @Override
                public void operationComplete(Future<? super Channel> future) throws Exception {
                    if (future.isSuccess()) {
                        ProxyToServerConnection.this.clientConnection.setMitming(true);
                    }
                }
            });
        }
    };
    private final ProxyConnection.BytesReadMonitor bytesReadMonitor = new ProxyConnection.BytesReadMonitor(){

        @Override
        protected void bytesRead(int numberOfBytes) {
            FullFlowContext flowContext = new FullFlowContext(ProxyToServerConnection.this.clientConnection, ProxyToServerConnection.this);
            for (ActivityTracker tracker : ProxyToServerConnection.this.proxyServer.getActivityTrackers()) {
                tracker.bytesReceivedFromServer(flowContext, numberOfBytes);
            }
        }
    };
    private ProxyConnection.ResponseReadMonitor responseReadMonitor = new ProxyConnection.ResponseReadMonitor(){

        @Override
        protected void responseRead(HttpResponse httpResponse) {
            FullFlowContext flowContext = new FullFlowContext(ProxyToServerConnection.this.clientConnection, ProxyToServerConnection.this);
            for (ActivityTracker tracker : ProxyToServerConnection.this.proxyServer.getActivityTrackers()) {
                tracker.responseReceivedFromServer(flowContext, httpResponse);
            }
        }
    };
    private ProxyConnection.BytesWrittenMonitor bytesWrittenMonitor = new ProxyConnection.BytesWrittenMonitor(){

        @Override
        protected void bytesWritten(int numberOfBytes) {
            FullFlowContext flowContext = new FullFlowContext(ProxyToServerConnection.this.clientConnection, ProxyToServerConnection.this);
            for (ActivityTracker tracker : ProxyToServerConnection.this.proxyServer.getActivityTrackers()) {
                tracker.bytesSentToServer(flowContext, numberOfBytes);
            }
        }
    };
    private ProxyConnection.RequestWrittenMonitor requestWrittenMonitor = new ProxyConnection.RequestWrittenMonitor(){

        @Override
        protected void requestWritten(HttpRequest httpRequest) {
            FullFlowContext flowContext = new FullFlowContext(ProxyToServerConnection.this.clientConnection, ProxyToServerConnection.this);
            for (ActivityTracker tracker : ProxyToServerConnection.this.proxyServer.getActivityTrackers()) {
                tracker.requestSentToServer(flowContext, httpRequest);
            }
        }
    };

    static ProxyToServerConnection create(DefaultHttpProxyServer proxyServer, ClientToProxyConnection clientConnection, String serverHostAndPort, HttpRequest initialHttpRequest) throws UnknownHostException {
        ConcurrentLinkedQueue<ChainedProxy> chainedProxies = new ConcurrentLinkedQueue<ChainedProxy>();
        ChainedProxyManager chainedProxyManager = proxyServer.getChainProxyManager();
        if (chainedProxyManager != null) {
            chainedProxyManager.lookupChainedProxies(initialHttpRequest, chainedProxies);
            if (chainedProxies.size() == 0) {
                return null;
            }
        }
        return new ProxyToServerConnection(proxyServer, clientConnection, serverHostAndPort, (ChainedProxy)chainedProxies.poll(), chainedProxies);
    }

    private ProxyToServerConnection(DefaultHttpProxyServer proxyServer, ClientToProxyConnection clientConnection, String serverHostAndPort, ChainedProxy chainedProxy, Queue<ChainedProxy> availableChainedProxies) throws UnknownHostException {
        super(ConnectionState.DISCONNECTED, proxyServer, true);
        this.clientConnection = clientConnection;
        this.serverHostAndPort = serverHostAndPort;
        this.chainedProxy = chainedProxy;
        this.availableChainedProxies = availableChainedProxies;
        this.setupConnectionParameters();
    }

    @Override
    protected void read(Object msg) {
        if (this.isConnecting()) {
            this.LOG.debug("In the middle of connecting, forwarding message to connection flow: {}", msg);
            this.connectionFlow.read(msg);
        } else {
            super.read(msg);
        }
    }

    @Override
    protected ConnectionState readHTTPInitial(HttpResponse httpResponse) {
        this.LOG.debug("Received raw response: {}", httpResponse);
        this.rememberCurrentResponse(httpResponse);
        this.respondWith(httpResponse);
        return ProxyUtils.isChunked(httpResponse) ? ConnectionState.AWAITING_CHUNK : ConnectionState.AWAITING_INITIAL;
    }

    @Override
    protected void readHTTPChunk(HttpContent chunk) {
        this.respondWith(chunk);
    }

    @Override
    protected void readRaw(ByteBuf buf) {
        this.clientConnection.write(buf);
    }

    void write(Object msg, HttpFilters filters) {
        this.currentFilters = filters;
        this.write(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void write(Object msg) {
        this.LOG.debug("Requested write of {}", msg);
        if (msg instanceof ReferenceCounted) {
            this.LOG.debug("Retaining reference counted message", new Object[0]);
            ((ReferenceCounted)msg).retain();
        }
        if (this.is(ConnectionState.DISCONNECTED) && msg instanceof HttpRequest) {
            this.LOG.debug("Currently disconnected, connect and then write the message", new Object[0]);
            this.connectAndWrite((HttpRequest)msg);
        } else {
            Object object = this.connectLock;
            synchronized (object) {
                if (this.isConnecting()) {
                    this.LOG.debug("Attempted to write while still in the process of connecting, waiting for connection.", new Object[0]);
                    this.clientConnection.stopReading();
                    try {
                        this.connectLock.wait(30000L);
                    }
                    catch (InterruptedException ie) {
                        this.LOG.warn("Interrupted while waiting for connect monitor", new Object[0]);
                    }
                    if (this.is(ConnectionState.DISCONNECTED)) {
                        this.LOG.debug("Connection failed while we were waiting for it, don't write", new Object[0]);
                        return;
                    }
                }
            }
            this.LOG.debug("Using existing connection to: {}", this.remoteAddress);
            this.doWrite(msg);
        }
    }

    @Override
    protected void writeHttp(HttpObject httpObject) {
        if (this.chainedProxy != null) {
            this.chainedProxy.filterRequest(httpObject);
        }
        if (httpObject instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)httpObject;
            this.issuedRequests.add(httpRequest);
        }
        super.writeHttp(httpObject);
    }

    @Override
    protected void becameSaturated() {
        super.becameSaturated();
        this.clientConnection.serverBecameSaturated(this);
    }

    @Override
    protected void becameWritable() {
        super.becameWritable();
        this.clientConnection.serverBecameWriteable(this);
    }

    @Override
    protected void timedOut() {
        super.timedOut();
        this.clientConnection.timedOut();
    }

    @Override
    protected void disconnected() {
        super.disconnected();
        if (this.chainedProxy != null) {
            try {
                this.chainedProxy.disconnected();
            }
            catch (Exception e) {
                this.LOG.error("Unable to record connectionFailed", e);
            }
        }
        this.clientConnection.serverDisconnected(this);
    }

    @Override
    protected void exceptionCaught(Throwable cause) {
        String message = "Caught exception on proxy -> web connection";
        int logLevel = 30;
        if (cause != null) {
            String causeMessage = cause.getMessage();
            if (cause instanceof ConnectException) {
                logLevel = 10;
            } else if (causeMessage != null) {
                if (causeMessage.contains("Connection reset by peer")) {
                    logLevel = 10;
                } else if (causeMessage.contains("event executor terminated")) {
                    logLevel = 10;
                }
            }
        }
        this.LOG.log(logLevel, message, cause);
        if (!this.is(ConnectionState.DISCONNECTED)) {
            this.LOG.log(logLevel, "Disconnecting open connection", new Object[0]);
            this.disconnect();
        }
    }

    public TransportProtocol getTransportProtocol() {
        return this.transportProtocol;
    }

    public InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public String getServerHostAndPort() {
        return this.serverHostAndPort;
    }

    public boolean hasUpstreamChainedProxy() {
        return this.getChainedProxyAddress() != null;
    }

    public InetSocketAddress getChainedProxyAddress() {
        return this.chainedProxy == null ? null : this.chainedProxy.getChainedProxyAddress();
    }

    public ChainedProxy getChainedProxy() {
        return this.chainedProxy;
    }

    public HttpRequest getInitialRequest() {
        return this.initialRequest;
    }

    private void identifyCurrentRequest() {
        this.LOG.debug("Remembering the current request.", new Object[0]);
        if (!this.issuedRequests.isEmpty()) {
            this.currentHttpRequest = this.issuedRequests.remove();
            if (this.currentHttpRequest == null) {
                this.LOG.warn("Got null HTTP request object.", new Object[0]);
            }
        } else {
            this.LOG.debug("Request queue is empty!", new Object[0]);
        }
    }

    private void rememberCurrentResponse(HttpResponse response) {
        this.LOG.debug("Remembering the current response.", new Object[0]);
        this.currentHttpResponse = ProxyUtils.copyMutableResponseFields(response);
    }

    private void respondWith(HttpObject httpObject) {
        this.clientConnection.respond(this, this.currentFilters, this.currentHttpRequest, this.currentHttpResponse, httpObject);
    }

    private void connectAndWrite(HttpRequest initialRequest) {
        this.LOG.debug("Starting new connection to: {}", this.remoteAddress);
        this.initialRequest = initialRequest;
        this.initializeConnectionFlow();
        this.connectionFlow.start();
    }

    private void initializeConnectionFlow() {
        this.connectionFlow = new ConnectionFlow(this.clientConnection, this, this.connectLock).then(this.ConnectChannel);
        if (this.chainedProxy != null && this.chainedProxy.requiresEncryption()) {
            this.connectionFlow.then(this.serverConnection.EncryptChannel(this.chainedProxy.newSslEngine()));
        }
        if (ProxyUtils.isCONNECT(this.initialRequest)) {
            boolean isMitmEnabled;
            MitmManager mitmManager = this.proxyServer.getMitmManager();
            boolean bl = isMitmEnabled = mitmManager != null;
            if (isMitmEnabled) {
                this.connectionFlow.then(this.serverConnection.EncryptChannel(mitmManager.serverSslEngine())).then(this.clientConnection.RespondCONNECTSuccessful).then(this.serverConnection.MitmEncryptClientChannel);
            } else {
                if (this.hasUpstreamChainedProxy()) {
                    this.connectionFlow.then(this.serverConnection.HTTPCONNECTWithChainedProxy);
                }
                this.connectionFlow.then(this.serverConnection.StartTunneling).then(this.clientConnection.RespondCONNECTSuccessful).then(this.clientConnection.StartTunneling);
            }
        }
    }

    protected boolean connectionFailed(Throwable cause) throws UnknownHostException {
        if (this.chainedProxy != null) {
            try {
                this.chainedProxy.connectionFailed(cause);
            }
            catch (Exception e) {
                this.LOG.error("Unable to record connectionFailed", e);
            }
        }
        this.chainedProxy = this.availableChainedProxies.poll();
        if (this.chainedProxy != null) {
            this.setupConnectionParameters();
            this.connectAndWrite(this.initialRequest);
            return true;
        }
        return false;
    }

    private void setupConnectionParameters() throws UnknownHostException {
        if (this.chainedProxy != null && this.chainedProxy != ChainedProxyAdapter.FALLBACK_TO_DIRECT_CONNECTION) {
            this.transportProtocol = this.chainedProxy.getTransportProtocol();
            this.remoteAddress = this.chainedProxy.getChainedProxyAddress();
            this.localAddress = this.chainedProxy.getLocalAddress();
        } else {
            this.transportProtocol = TransportProtocol.TCP;
            this.remoteAddress = ProxyToServerConnection.addressFor(this.serverHostAndPort, this.proxyServer);
            this.localAddress = null;
        }
    }

    private void initChannelPipeline(ChannelPipeline pipeline, HttpRequest httpRequest) {
        int numberOfBytesToBuffer;
        pipeline.addLast("bytesReadMonitor", (ChannelHandler)this.bytesReadMonitor);
        pipeline.addLast("decoder", (ChannelHandler)new HeadAwareHttpResponseDecoder(8192, 16384, 16384));
        pipeline.addLast("responseReadMonitor", (ChannelHandler)this.responseReadMonitor);
        if (!ProxyUtils.isCONNECT(httpRequest) && (numberOfBytesToBuffer = this.proxyServer.getFiltersSource().getMaximumResponseBufferSizeInBytes()) > 0) {
            this.aggregateContentForFiltering(pipeline, numberOfBytesToBuffer);
        }
        pipeline.addLast("bytesWrittenMonitor", (ChannelHandler)this.bytesWrittenMonitor);
        pipeline.addLast("encoder", (ChannelHandler)new HttpRequestEncoder());
        pipeline.addLast("requestWrittenMonitor", (ChannelHandler)this.requestWrittenMonitor);
        pipeline.addLast("idle", (ChannelHandler)new IdleStateHandler(0, 0, this.proxyServer.getIdleConnectionTimeout()));
        pipeline.addLast("handler", (ChannelHandler)this);
    }

    void connectionSucceeded(boolean shouldForwardInitialRequest) {
        this.become(ConnectionState.AWAITING_INITIAL);
        if (this.chainedProxy != null) {
            try {
                this.chainedProxy.connectionSucceeded();
            }
            catch (Exception e) {
                this.LOG.error("Unable to record connectionSucceeded", e);
            }
        }
        this.clientConnection.serverConnectionSucceeded(this, shouldForwardInitialRequest);
        if (shouldForwardInitialRequest) {
            this.LOG.debug("Writing initial request: {}", this.initialRequest);
            this.write(this.initialRequest);
        } else {
            this.LOG.debug("Dropping initial request: {}", this.initialRequest);
        }
    }

    private static InetSocketAddress addressFor(String hostAndPort, DefaultHttpProxyServer proxyServer) throws UnknownHostException {
        int port;
        String host;
        if (hostAndPort.contains(":")) {
            host = StringUtils.substringBefore(hostAndPort, ":");
            String portString = StringUtils.substringAfter(hostAndPort, ":");
            port = Integer.parseInt(portString);
        } else {
            host = hostAndPort;
            port = 80;
        }
        if (proxyServer.isUseDnsSec()) {
            return VerifiedAddressFactory.newInetSocketAddress(host, port, proxyServer.isUseDnsSec());
        }
        InetAddress ia = InetAddress.getByName(host);
        String address = ia.getHostAddress();
        return new InetSocketAddress(address, port);
    }

    private class HeadAwareHttpResponseDecoder
    extends HttpResponseDecoder {
        public HeadAwareHttpResponseDecoder(int maxInitialLineLength, int maxHeaderSize, int maxChunkSize) {
            super(maxInitialLineLength, maxHeaderSize, maxChunkSize);
        }

        @Override
        protected boolean isContentAlwaysEmpty(HttpMessage httpMessage) {
            if (httpMessage instanceof HttpResponse) {
                ProxyToServerConnection.this.identifyCurrentRequest();
            }
            return HttpMethod.HEAD.equals(ProxyToServerConnection.this.currentHttpRequest.getMethod()) ? true : super.isContentAlwaysEmpty(httpMessage);
        }
    }
}

