/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.proxy.impl;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.littleshoot.proxy.impl.NetworkUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ProxyUtils.class);
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private static final String PATTERN_RFC1123 = "EEE, dd MMM yyyy HH:mm:ss zzz";
    private static final String hostName;
    private static Pattern HTTP_PREFIX;

    private ProxyUtils() {
    }

    public static String stripHost(String uri) {
        if (!HTTP_PREFIX.matcher(uri).matches()) {
            return uri;
        }
        String noHttpUri = StringUtils.substringAfter(uri, "://");
        int slashIndex = noHttpUri.indexOf("/");
        if (slashIndex == -1) {
            return "/";
        }
        String noHostUri = noHttpUri.substring(slashIndex);
        return noHostUri;
    }

    public static String formatDate(Date date) {
        return ProxyUtils.formatDate(date, PATTERN_RFC1123);
    }

    public static String formatDate(Date date, String pattern) {
        if (date == null) {
            throw new IllegalArgumentException("date is null");
        }
        if (pattern == null) {
            throw new IllegalArgumentException("pattern is null");
        }
        SimpleDateFormat formatter = new SimpleDateFormat(pattern, Locale.US);
        formatter.setTimeZone(GMT);
        return formatter.format(date);
    }

    public static String httpDate() {
        return ProxyUtils.formatDate(new Date());
    }

    public static boolean isLastChunk(HttpObject httpObject) {
        return httpObject instanceof LastHttpContent;
    }

    public static boolean isChunked(HttpObject httpObject) {
        return !ProxyUtils.isLastChunk(httpObject);
    }

    public static String parseHostAndPort(HttpRequest httpRequest) {
        String uriHostAndPort = ProxyUtils.parseHostAndPort(httpRequest.getUri());
        return uriHostAndPort;
    }

    public static String parseHostAndPort(String uri) {
        String tempUri = !HTTP_PREFIX.matcher(uri).matches() ? uri : StringUtils.substringAfter(uri, "://");
        String hostAndPort = tempUri.contains("/") ? tempUri.substring(0, tempUri.indexOf("/")) : tempUri;
        return hostAndPort;
    }

    public static HttpResponse copyMutableResponseFields(HttpResponse original) {
        DefaultHttpResponse copy = null;
        if (original instanceof DefaultFullHttpResponse) {
            ByteBuf content = ((DefaultFullHttpResponse)original).content();
            copy = new DefaultFullHttpResponse(original.getProtocolVersion(), original.getStatus(), content);
        } else {
            copy = new DefaultHttpResponse(original.getProtocolVersion(), original.getStatus());
        }
        Set<String> headerNames = original.headers().names();
        for (String name : headerNames) {
            List<String> values = original.headers().getAll(name);
            copy.headers().set(name, (Iterable<?>)values);
        }
        return copy;
    }

    public static void addVia(HttpMessage msg) {
        List<String> vias;
        StringBuilder sb = new StringBuilder();
        sb.append(msg.getProtocolVersion().majorVersion());
        sb.append(".");
        sb.append(msg.getProtocolVersion().minorVersion());
        sb.append(".");
        sb.append(hostName);
        if (msg.headers().contains("Via")) {
            vias = msg.headers().getAll("Via");
            vias.add(sb.toString());
        } else {
            vias = Arrays.asList(sb.toString());
        }
        msg.headers().set("Via", (Iterable<?>)vias);
    }

    public static boolean isTrue(String val) {
        return ProxyUtils.checkTrueOrFalse(val, "true", "on");
    }

    public static boolean isFalse(String val) {
        return ProxyUtils.checkTrueOrFalse(val, "false", "off");
    }

    public static boolean extractBooleanDefaultFalse(Properties props, String key) {
        String throttle = props.getProperty(key);
        if (StringUtils.isNotBlank(throttle)) {
            return throttle.trim().equalsIgnoreCase("true");
        }
        return false;
    }

    public static boolean extractBooleanDefaultTrue(Properties props, String key) {
        String throttle = props.getProperty(key);
        if (StringUtils.isNotBlank(throttle)) {
            return throttle.trim().equalsIgnoreCase("true");
        }
        return true;
    }

    public static int extractInt(Properties props, String key) {
        return ProxyUtils.extractInt(props, key, -1);
    }

    public static int extractInt(Properties props, String key, int defaultValue) {
        String readThrottleString = props.getProperty(key);
        if (StringUtils.isNotBlank(readThrottleString) && NumberUtils.isNumber(readThrottleString)) {
            return Integer.parseInt(readThrottleString);
        }
        return defaultValue;
    }

    public static boolean isCONNECT(HttpObject httpObject) {
        return httpObject instanceof HttpRequest && HttpMethod.CONNECT.equals(((HttpRequest)httpObject).getMethod());
    }

    private static boolean checkTrueOrFalse(String val, String str1, String str2) {
        String str = val.trim();
        return StringUtils.isNotBlank(str) && (str.equalsIgnoreCase(str1) || str.equalsIgnoreCase(str2));
    }

    static {
        try {
            InetAddress localAddress = NetworkUtils.getLocalHost();
            hostName = localAddress.getHostName();
        }
        catch (UnknownHostException e) {
            LOG.error("Could not lookup host", e);
            throw new IllegalStateException("Could not determine host!", e);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Via: 1.1 ");
        sb.append(hostName);
        sb.append("\r\n");
        HTTP_PREFIX = Pattern.compile("^https?://.*", 2);
    }
}

