/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.proxy.impl;

import io.netty.bootstrap.ChannelFactory;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.udt.nio.NioUdtProvider;
import io.netty.handler.traffic.GlobalTrafficShapingHandler;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.IOUtils;
import org.littleshoot.proxy.ActivityTracker;
import org.littleshoot.proxy.ChainedProxyManager;
import org.littleshoot.proxy.DefaultHostResolver;
import org.littleshoot.proxy.DnsSecServerResolver;
import org.littleshoot.proxy.HostResolver;
import org.littleshoot.proxy.HttpFiltersSource;
import org.littleshoot.proxy.HttpFiltersSourceAdapter;
import org.littleshoot.proxy.HttpProxyServer;
import org.littleshoot.proxy.HttpProxyServerBootstrap;
import org.littleshoot.proxy.MitmManager;
import org.littleshoot.proxy.ProxyAuthenticator;
import org.littleshoot.proxy.SslEngineSource;
import org.littleshoot.proxy.TransportProtocol;
import org.littleshoot.proxy.UnknownTransportProtocolException;
import org.littleshoot.proxy.impl.ClientToProxyConnection;
import org.littleshoot.proxy.impl.ProxyUtils;
import org.littleshoot.proxy.impl.ServerGroup;
import org.littleshoot.proxy.impl.ThreadPoolConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHttpProxyServer
implements HttpProxyServer {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultHttpProxyServer.class);
    private static final long TRAFFIC_SHAPING_CHECK_INTERVAL_MS = 250L;
    private static final String FALLBACK_PROXY_ALIAS = "littleproxy";
    private final ServerGroup serverGroup;
    private final TransportProtocol transportProtocol;
    private final InetSocketAddress requestedAddress;
    private volatile InetSocketAddress localAddress;
    private volatile InetSocketAddress boundAddress;
    private final SslEngineSource sslEngineSource;
    private final boolean authenticateSslClients;
    private final ProxyAuthenticator proxyAuthenticator;
    private final ChainedProxyManager chainProxyManager;
    private final MitmManager mitmManager;
    private final HttpFiltersSource filtersSource;
    private final boolean transparent;
    private final int connectTimeout;
    private volatile int idleConnectionTimeout;
    private final HostResolver serverResolver;
    private volatile GlobalTrafficShapingHandler globalTrafficShapingHandler;
    private final String proxyAlias;
    private final AtomicBoolean stopped = new AtomicBoolean(false);
    private final Collection<ActivityTracker> activityTrackers = new ConcurrentLinkedQueue<ActivityTracker>();
    private final ChannelGroup allChannels = new DefaultChannelGroup("HTTP-Proxy-Server", GlobalEventExecutor.INSTANCE);
    private final Thread jvmShutdownHook = new Thread(new Runnable(){

        @Override
        public void run() {
            DefaultHttpProxyServer.this.abort();
        }
    }, "LittleProxy-JVM-shutdown-hook");

    public static HttpProxyServerBootstrap bootstrap() {
        return new DefaultHttpProxyServerBootstrap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpProxyServerBootstrap bootstrapFromFile(String path) {
        File propsFile = new File(path);
        Properties props = new Properties();
        if (propsFile.isFile()) {
            FileInputStream is = null;
            try {
                is = new FileInputStream(propsFile);
                props.load(is);
            }
            catch (IOException e) {
                try {
                    LOG.warn("Could not load props file?", e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    throw throwable;
                }
                IOUtils.closeQuietly(is);
            }
            IOUtils.closeQuietly(is);
        }
        return new DefaultHttpProxyServerBootstrap(props);
    }

    private DefaultHttpProxyServer(ServerGroup serverGroup, TransportProtocol transportProtocol, InetSocketAddress requestedAddress, SslEngineSource sslEngineSource, boolean authenticateSslClients, ProxyAuthenticator proxyAuthenticator, ChainedProxyManager chainProxyManager, MitmManager mitmManager, HttpFiltersSource filtersSource, boolean transparent, int idleConnectionTimeout, Collection<ActivityTracker> activityTrackers, int connectTimeout, HostResolver serverResolver, long readThrottleBytesPerSecond, long writeThrottleBytesPerSecond, InetSocketAddress localAddress, String proxyAlias) {
        this.serverGroup = serverGroup;
        this.transportProtocol = transportProtocol;
        this.requestedAddress = requestedAddress;
        this.sslEngineSource = sslEngineSource;
        this.authenticateSslClients = authenticateSslClients;
        this.proxyAuthenticator = proxyAuthenticator;
        this.chainProxyManager = chainProxyManager;
        this.mitmManager = mitmManager;
        this.filtersSource = filtersSource;
        this.transparent = transparent;
        this.idleConnectionTimeout = idleConnectionTimeout;
        if (activityTrackers != null) {
            this.activityTrackers.addAll(activityTrackers);
        }
        this.connectTimeout = connectTimeout;
        this.serverResolver = serverResolver;
        this.globalTrafficShapingHandler = writeThrottleBytesPerSecond > 0L || readThrottleBytesPerSecond > 0L ? this.createGlobalTrafficShapingHandler(transportProtocol, readThrottleBytesPerSecond, writeThrottleBytesPerSecond) : null;
        this.localAddress = localAddress;
        if (proxyAlias == null) {
            String hostname = ProxyUtils.getHostName();
            if (hostname == null) {
                hostname = FALLBACK_PROXY_ALIAS;
            }
            this.proxyAlias = hostname;
        } else {
            this.proxyAlias = proxyAlias;
        }
    }

    private GlobalTrafficShapingHandler createGlobalTrafficShapingHandler(TransportProtocol transportProtocol, long readThrottleBytesPerSecond, long writeThrottleBytesPerSecond) {
        EventLoopGroup proxyToServerEventLoop = this.getProxyToServerWorkerFor(transportProtocol);
        return new GlobalTrafficShapingHandler(proxyToServerEventLoop, writeThrottleBytesPerSecond, readThrottleBytesPerSecond, 250L, Long.MAX_VALUE);
    }

    boolean isTransparent() {
        return this.transparent;
    }

    @Override
    public int getIdleConnectionTimeout() {
        return this.idleConnectionTimeout;
    }

    @Override
    public void setIdleConnectionTimeout(int idleConnectionTimeout) {
        this.idleConnectionTimeout = idleConnectionTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public HostResolver getServerResolver() {
        return this.serverResolver;
    }

    public InetSocketAddress getLocalAddress() {
        return this.localAddress;
    }

    @Override
    public InetSocketAddress getListenAddress() {
        return this.boundAddress;
    }

    @Override
    public void setThrottle(long readThrottleBytesPerSecond, long writeThrottleBytesPerSecond) {
        if (this.globalTrafficShapingHandler != null) {
            this.globalTrafficShapingHandler.configure(writeThrottleBytesPerSecond, readThrottleBytesPerSecond);
        } else if (readThrottleBytesPerSecond > 0L || writeThrottleBytesPerSecond > 0L) {
            this.globalTrafficShapingHandler = this.createGlobalTrafficShapingHandler(this.transportProtocol, readThrottleBytesPerSecond, writeThrottleBytesPerSecond);
        }
    }

    public long getReadThrottle() {
        return this.globalTrafficShapingHandler.getReadLimit();
    }

    public long getWriteThrottle() {
        return this.globalTrafficShapingHandler.getWriteLimit();
    }

    @Override
    public HttpProxyServerBootstrap clone() {
        return new DefaultHttpProxyServerBootstrap(this.serverGroup, this.transportProtocol, new InetSocketAddress(this.requestedAddress.getAddress(), this.requestedAddress.getPort() == 0 ? 0 : this.requestedAddress.getPort() + 1), this.sslEngineSource, this.authenticateSslClients, this.proxyAuthenticator, this.chainProxyManager, this.mitmManager, this.filtersSource, this.transparent, this.idleConnectionTimeout, this.activityTrackers, this.connectTimeout, this.serverResolver, this.globalTrafficShapingHandler != null ? this.globalTrafficShapingHandler.getReadLimit() : 0L, this.globalTrafficShapingHandler != null ? this.globalTrafficShapingHandler.getWriteLimit() : 0L, this.localAddress, this.proxyAlias);
    }

    @Override
    public void stop() {
        this.doStop(true);
    }

    @Override
    public void abort() {
        this.doStop(false);
    }

    protected void doStop(boolean graceful) {
        if (this.stopped.compareAndSet(false, true)) {
            if (graceful) {
                LOG.info("Shutting down proxy server gracefully");
            } else {
                LOG.info("Shutting down proxy server immediately (non-graceful)");
            }
            this.closeAllChannels(graceful);
            this.serverGroup.unregisterProxyServer(this, graceful);
            try {
                Runtime.getRuntime().removeShutdownHook(this.jvmShutdownHook);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            LOG.info("Done shutting down proxy server");
        }
    }

    protected void registerChannel(Channel channel) {
        this.allChannels.add(channel);
    }

    protected void closeAllChannels(boolean graceful) {
        LOG.info("Closing all channels " + (graceful ? "(graceful)" : "(non-graceful)"));
        ChannelGroupFuture future = this.allChannels.close();
        if (graceful) {
            try {
                future.await(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOG.warn("Interrupted while waiting for channels to shut down gracefully.");
            }
            if (!future.isSuccess()) {
                for (ChannelFuture cf : future) {
                    if (cf.isSuccess()) continue;
                    LOG.info("Unable to close channel.  Cause of failure for {} is {}", (Object)cf.channel(), (Object)cf.cause());
                }
            }
        }
    }

    private HttpProxyServer start() {
        if (this.serverGroup.isStopped()) {
            throw new IllegalStateException("Attempted to start proxy, but proxy's server group is already stopped");
        }
        LOG.info("Starting proxy at address: " + this.requestedAddress);
        this.serverGroup.registerProxyServer(this);
        this.doStart();
        return this;
    }

    private void doStart() {
        ServerBootstrap serverBootstrap = new ServerBootstrap().group(this.serverGroup.getClientToProxyAcceptorPoolForTransport(this.transportProtocol), this.serverGroup.getClientToProxyWorkerPoolForTransport(this.transportProtocol));
        ChannelInitializer<Channel> initializer = new ChannelInitializer<Channel>(){

            @Override
            protected void initChannel(Channel ch) throws Exception {
                new ClientToProxyConnection(DefaultHttpProxyServer.this, DefaultHttpProxyServer.this.sslEngineSource, DefaultHttpProxyServer.this.authenticateSslClients, ch.pipeline(), DefaultHttpProxyServer.this.globalTrafficShapingHandler);
            }
        };
        switch (this.transportProtocol) {
            case TCP: {
                LOG.info("Proxy listening with TCP transport");
                serverBootstrap.channelFactory(new ChannelFactory<ServerChannel>(){

                    @Override
                    public ServerChannel newChannel() {
                        return new NioServerSocketChannel();
                    }
                });
                break;
            }
            case UDT: {
                LOG.info("Proxy listening with UDT transport");
                ((ServerBootstrap)((ServerBootstrap)serverBootstrap.channelFactory(NioUdtProvider.BYTE_ACCEPTOR)).option(ChannelOption.SO_BACKLOG, 10)).option(ChannelOption.SO_REUSEADDR, true);
                break;
            }
            default: {
                throw new UnknownTransportProtocolException(this.transportProtocol);
            }
        }
        serverBootstrap.childHandler(initializer);
        ChannelFuture future = serverBootstrap.bind(this.requestedAddress).addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    DefaultHttpProxyServer.this.registerChannel(future.channel());
                }
            }
        }).awaitUninterruptibly();
        Throwable cause = future.cause();
        if (cause != null) {
            throw new RuntimeException(cause);
        }
        this.boundAddress = (InetSocketAddress)future.channel().localAddress();
        LOG.info("Proxy started at address: " + this.boundAddress);
        Runtime.getRuntime().addShutdownHook(this.jvmShutdownHook);
    }

    protected ChainedProxyManager getChainProxyManager() {
        return this.chainProxyManager;
    }

    protected MitmManager getMitmManager() {
        return this.mitmManager;
    }

    protected SslEngineSource getSslEngineSource() {
        return this.sslEngineSource;
    }

    protected ProxyAuthenticator getProxyAuthenticator() {
        return this.proxyAuthenticator;
    }

    public HttpFiltersSource getFiltersSource() {
        return this.filtersSource;
    }

    protected Collection<ActivityTracker> getActivityTrackers() {
        return this.activityTrackers;
    }

    public String getProxyAlias() {
        return this.proxyAlias;
    }

    protected EventLoopGroup getProxyToServerWorkerFor(TransportProtocol transportProtocol) {
        return this.serverGroup.getProxyToServerWorkerPoolForTransport(transportProtocol);
    }

    private static class DefaultHttpProxyServerBootstrap
    implements HttpProxyServerBootstrap {
        private String name = "LittleProxy";
        private ServerGroup serverGroup = null;
        private TransportProtocol transportProtocol = TransportProtocol.TCP;
        private InetSocketAddress requestedAddress;
        private int port = 8080;
        private boolean allowLocalOnly = true;
        private SslEngineSource sslEngineSource = null;
        private boolean authenticateSslClients = true;
        private ProxyAuthenticator proxyAuthenticator = null;
        private ChainedProxyManager chainProxyManager = null;
        private MitmManager mitmManager = null;
        private HttpFiltersSource filtersSource = new HttpFiltersSourceAdapter();
        private boolean transparent = false;
        private int idleConnectionTimeout = 70;
        private Collection<ActivityTracker> activityTrackers = new ConcurrentLinkedQueue<ActivityTracker>();
        private int connectTimeout = 40000;
        private HostResolver serverResolver = new DefaultHostResolver();
        private long readThrottleBytesPerSecond;
        private long writeThrottleBytesPerSecond;
        private InetSocketAddress localAddress;
        private String proxyAlias;
        private int clientToProxyAcceptorThreads = 2;
        private int clientToProxyWorkerThreads = 8;
        private int proxyToServerWorkerThreads = 8;

        private DefaultHttpProxyServerBootstrap() {
        }

        private DefaultHttpProxyServerBootstrap(ServerGroup serverGroup, TransportProtocol transportProtocol, InetSocketAddress requestedAddress, SslEngineSource sslEngineSource, boolean authenticateSslClients, ProxyAuthenticator proxyAuthenticator, ChainedProxyManager chainProxyManager, MitmManager mitmManager, HttpFiltersSource filtersSource, boolean transparent, int idleConnectionTimeout, Collection<ActivityTracker> activityTrackers, int connectTimeout, HostResolver serverResolver, long readThrottleBytesPerSecond, long writeThrottleBytesPerSecond, InetSocketAddress localAddress, String proxyAlias) {
            this.serverGroup = serverGroup;
            this.transportProtocol = transportProtocol;
            this.requestedAddress = requestedAddress;
            this.port = requestedAddress.getPort();
            this.sslEngineSource = sslEngineSource;
            this.authenticateSslClients = authenticateSslClients;
            this.proxyAuthenticator = proxyAuthenticator;
            this.chainProxyManager = chainProxyManager;
            this.mitmManager = mitmManager;
            this.filtersSource = filtersSource;
            this.transparent = transparent;
            this.idleConnectionTimeout = idleConnectionTimeout;
            if (activityTrackers != null) {
                this.activityTrackers.addAll(activityTrackers);
            }
            this.connectTimeout = connectTimeout;
            this.serverResolver = serverResolver;
            this.readThrottleBytesPerSecond = readThrottleBytesPerSecond;
            this.writeThrottleBytesPerSecond = writeThrottleBytesPerSecond;
            this.localAddress = localAddress;
            this.proxyAlias = proxyAlias;
        }

        private DefaultHttpProxyServerBootstrap(Properties props) {
            this.withUseDnsSec(ProxyUtils.extractBooleanDefaultFalse(props, "dnssec"));
            this.transparent = ProxyUtils.extractBooleanDefaultFalse(props, "transparent");
            this.idleConnectionTimeout = ProxyUtils.extractInt(props, "idle_connection_timeout");
            this.connectTimeout = ProxyUtils.extractInt(props, "connect_timeout", 0);
        }

        @Override
        public HttpProxyServerBootstrap withName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public HttpProxyServerBootstrap withTransportProtocol(TransportProtocol transportProtocol) {
            this.transportProtocol = transportProtocol;
            return this;
        }

        @Override
        public HttpProxyServerBootstrap withAddress(InetSocketAddress address) {
            this.requestedAddress = address;
            return this;
        }

        @Override
        public HttpProxyServerBootstrap withPort(int port) {
            this.requestedAddress = null;
            this.port = port;
            return this;
        }

        @Override
        public HttpProxyServerBootstrap withNetworkInterface(InetSocketAddress inetSocketAddress) {
            this.localAddress = inetSocketAddress;
            return this;
        }

        @Override
        public HttpProxyServerBootstrap withProxyAlias(String alias) {
            this.proxyAlias = alias;
            return this;
        }

        @Override
        public HttpProxyServerBootstrap withAllowLocalOnly(boolean allowLocalOnly) {
            this.allowLocalOnly = allowLocalOnly;
            return this;
        }

        @Override
        @Deprecated
        public HttpProxyServerBootstrap withListenOnAllAddresses(boolean listenOnAllAddresses) {
            LOG.warn("withListenOnAllAddresses() is deprecated and will be removed in a future release. Use withNetworkInterface().");
            return this;
        }

        @Override
        public HttpProxyServerBootstrap withSslEngineSource(SslEngineSource sslEngineSource) {
            this.sslEngineSource = sslEngineSource;
            if (this.mitmManager != null) {
                LOG.warn("Enabled encrypted inbound connections with man in the middle. These are mutually exclusive - man in the middle will be disabled.");
                this.mitmManager = null;
            }
            return this;
        }

        @Override
        public HttpProxyServerBootstrap withAuthenticateSslClients(boolean authenticateSslClients) {
            this.authenticateSslClients = authenticateSslClients;
            return this;
        }

        @Override
        public HttpProxyServerBootstrap withProxyAuthenticator(ProxyAuthenticator proxyAuthenticator) {
            this.proxyAuthenticator = proxyAuthenticator;
            return this;
        }

        @Override
        public HttpProxyServerBootstrap withChainProxyManager(ChainedProxyManager chainProxyManager) {
            this.chainProxyManager = chainProxyManager;
            return this;
        }

        @Override
        public HttpProxyServerBootstrap withManInTheMiddle(MitmManager mitmManager) {
            this.mitmManager = mitmManager;
            if (this.sslEngineSource != null) {
                LOG.warn("Enabled man in the middle with encrypted inbound connections. These are mutually exclusive - encrypted inbound connections will be disabled.");
                this.sslEngineSource = null;
            }
            return this;
        }

        @Override
        public HttpProxyServerBootstrap withFiltersSource(HttpFiltersSource filtersSource) {
            this.filtersSource = filtersSource;
            return this;
        }

        @Override
        public HttpProxyServerBootstrap withUseDnsSec(boolean useDnsSec) {
            this.serverResolver = useDnsSec ? new DnsSecServerResolver() : new DefaultHostResolver();
            return this;
        }

        @Override
        public HttpProxyServerBootstrap withTransparent(boolean transparent) {
            this.transparent = transparent;
            return this;
        }

        @Override
        public HttpProxyServerBootstrap withIdleConnectionTimeout(int idleConnectionTimeout) {
            this.idleConnectionTimeout = idleConnectionTimeout;
            return this;
        }

        @Override
        public HttpProxyServerBootstrap withConnectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        @Override
        public HttpProxyServerBootstrap withServerResolver(HostResolver serverResolver) {
            this.serverResolver = serverResolver;
            return this;
        }

        @Override
        public HttpProxyServerBootstrap plusActivityTracker(ActivityTracker activityTracker) {
            this.activityTrackers.add(activityTracker);
            return this;
        }

        @Override
        public HttpProxyServerBootstrap withThrottling(long readThrottleBytesPerSecond, long writeThrottleBytesPerSecond) {
            this.readThrottleBytesPerSecond = readThrottleBytesPerSecond;
            this.writeThrottleBytesPerSecond = writeThrottleBytesPerSecond;
            return this;
        }

        @Override
        public HttpProxyServer start() {
            return this.build().start();
        }

        @Override
        public HttpProxyServerBootstrap withThreadPoolConfiguration(ThreadPoolConfiguration configuration) {
            this.clientToProxyAcceptorThreads = configuration.getAcceptorThreads();
            this.clientToProxyWorkerThreads = configuration.getClientToProxyWorkerThreads();
            this.proxyToServerWorkerThreads = configuration.getProxyToServerWorkerThreads();
            return this;
        }

        private DefaultHttpProxyServer build() {
            ServerGroup serverGroup = this.serverGroup != null ? this.serverGroup : new ServerGroup(this.name, this.clientToProxyAcceptorThreads, this.clientToProxyWorkerThreads, this.proxyToServerWorkerThreads);
            return new DefaultHttpProxyServer(serverGroup, this.transportProtocol, this.determineListenAddress(), this.sslEngineSource, this.authenticateSslClients, this.proxyAuthenticator, this.chainProxyManager, this.mitmManager, this.filtersSource, this.transparent, this.idleConnectionTimeout, this.activityTrackers, this.connectTimeout, this.serverResolver, this.readThrottleBytesPerSecond, this.writeThrottleBytesPerSecond, this.localAddress, this.proxyAlias);
        }

        private InetSocketAddress determineListenAddress() {
            if (this.requestedAddress != null) {
                return this.requestedAddress;
            }
            if (this.allowLocalOnly) {
                return new InetSocketAddress("127.0.0.1", this.port);
            }
            return new InetSocketAddress(this.port);
        }
    }
}

