/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.dnssec4j;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import org.littleshoot.dnssec4j.DNSSECException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.CNAMERecord;
import org.xbill.DNS.DNSKEYRecord;
import org.xbill.DNS.DNSSEC;
import org.xbill.DNS.ExtendedResolver;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.Options;
import org.xbill.DNS.RRSIGRecord;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;

public class DnsSec {
    private static final Logger log = LoggerFactory.getLogger(DnsSec.class);

    public DnsSec() {
        System.setProperty("sun.net.spi.nameservice.nameservers", "8.8.8.8,8.8.4.4");
    }

    public static InetSocketAddress verify(InetSocketAddress unresolved) throws DNSSECException, IOException {
        if (!unresolved.isUnresolved()) {
            return unresolved;
        }
        InetAddress verified = DnsSec.getByName(unresolved.getHostName());
        return new InetSocketAddress(verified, unresolved.getPort());
    }

    public static InetAddress getByName(String name) throws DNSSECException, IOException {
        Name full = Name.concatenate(Name.fromString(name), Name.root);
        System.out.println("Verifying record: " + full);
        Resolver res = DnsSec.newResolver();
        Record question = Record.newRecord(full, 1, 1);
        Message query = Message.newQuery(question);
        System.out.println("Sending query...");
        Message response = res.send(query);
        System.out.println("RESPONSE: " + response);
        RRset[] answer = response.getSectionRRsets(1);
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        for (RRset set : answer) {
            int type;
            Record rec;
            System.out.println("\n;; RRset to chase:");
            Iterator rrIter = set.rrs();
            boolean hasCname = false;
            Name cNameTarget = null;
            while (rrIter.hasNext()) {
                rec = (Record)rrIter.next();
                type = rec.getType();
                if (type != 5) continue;
                CNAMERecord cname = (CNAMERecord)rec;
                hasCname = true;
                cNameTarget = cname.getTarget();
            }
            rrIter = set.rrs();
            while (rrIter.hasNext()) {
                rec = (Record)rrIter.next();
                System.out.println(rec);
                type = rec.getType();
                if (type != 1) continue;
                ARecord arec = (ARecord)rec;
                if (hasCname) {
                    if (!rec.getName().equals(cNameTarget)) continue;
                    addresses.add(arec.getAddress());
                    continue;
                }
                addresses.add(arec.getAddress());
            }
            Iterator sigIter = set.sigs();
            while (sigIter.hasNext()) {
                RRSIGRecord rec2 = (RRSIGRecord)sigIter.next();
                System.out.println("\n;; RRSIG of the RRset to chase:");
                System.out.println(rec2);
                DnsSec.verifyZone(set, rec2);
            }
        }
        return (InetAddress)addresses.get(0);
    }

    private static void verifyZone(RRset set, RRSIGRecord record) throws DNSSECException, IOException {
        System.out.println("\nLaunch a query to find a RRset of type DNSKEY for zone: " + record.getSigner());
        Name signer = record.getSigner();
        int tag = record.getFootprint();
        System.out.println("Looking for tag: " + tag);
        boolean keyVerified = false;
        DNSKEYRecord keyRec = null;
        try {
            RRset[] answer;
            Options.set("multiline");
            Resolver res = DnsSec.newResolver();
            Record question = Record.newRecord(signer, 48, 1);
            Message query = Message.newQuery(question);
            Message response = res.send(query);
            System.out.println("Sent query...");
            for (RRset answerSet : answer = response.getSectionRRsets(1)) {
                System.out.println("\n;; DNSKEYset that signs the RRset to chase:");
                Iterator rrIter = answerSet.rrs();
                while (rrIter.hasNext()) {
                    DNSKEYRecord dnskKeyRec;
                    Record rec = (Record)rrIter.next();
                    System.out.println(rec);
                    if (!(rec instanceof DNSKEYRecord) || (dnskKeyRec = (DNSKEYRecord)rec).getFootprint() != tag) continue;
                    System.out.println("\n\nFound matching DNSKEY for tag!! " + tag + "\n\n");
                    keyRec = dnskKeyRec;
                }
                System.out.println("\n;; RRSIG of the DNSKEYset that signs the RRset to chase:");
                Iterator sigIter = answerSet.sigs();
                while (sigIter.hasNext()) {
                    RRSIGRecord rec = (RRSIGRecord)sigIter.next();
                    System.out.println(rec);
                    if (rec.getFootprint() != tag) continue;
                    DNSSEC.verify(answerSet, rec, keyRec);
                    keyVerified = true;
                }
                if (!keyVerified) {
                    log.info("DNSKEY not verified");
                } else {
                    log.info("DNSKEY verified!!");
                }
                keyVerified = false;
            }
            if (keyRec == null) {
                throw new DNSSECException("Did not find DNSKEY record matching tag: " + tag);
            }
        }
        catch (DNSSEC.DNSSECException e) {
            throw new DNSSECException("Error verifying record", e);
        }
        finally {
            Options.unset("multiline");
        }
        try {
            DNSSEC.verify(set, record, keyRec);
        }
        catch (DNSSEC.DNSSECException e) {
            throw new DNSSECException("Error verifying record", e);
        }
        DnsSec.verifyDsRecordForSignerOf(record);
    }

    private static Resolver newResolver() throws UnknownHostException {
        ExtendedResolver res = new ExtendedResolver();
        res.setEDNS(0, 0, 32768, null);
        res.setIgnoreTruncation(false);
        res.setTimeout(15);
        return res;
    }

    private static void verifyDsRecordForSignerOf(RRSIGRecord rec) throws IOException, DNSSECException {
        RRset[] answer;
        Name signer = rec.getSigner();
        System.out.println("\nLaunch a query to find a RRset of type DS for zone: " + signer);
        Resolver res = DnsSec.newResolver();
        Record question = Record.newRecord(signer, 43, 1);
        Message query = Message.newQuery(question);
        Message response = res.send(query);
        System.out.println("Sent query and got response: " + response);
        for (RRset set : answer = response.getSectionRRsets(1)) {
            Iterator rrIter = set.rrs();
            System.out.println("\n;; DSset of the DNSKEYset");
            while (rrIter.hasNext()) {
                System.out.println(rrIter.next());
            }
            Iterator sigIter = set.sigs();
            System.out.println("\n;; RRSIG of the DSset of the DNSKEYset");
            while (sigIter.hasNext()) {
                Record sigRec = (Record)sigIter.next();
                System.out.println(sigRec);
                if (sigIter.hasNext()) {
                    throw new IOException("We don't handle more than one RRSIGRecord for DS responses!!");
                }
                if (!(sigRec instanceof RRSIGRecord)) continue;
                RRSIGRecord rr = (RRSIGRecord)sigRec;
                System.out.println(";; Now, we want to validate the DS :  recursive call");
                DnsSec.verifyZone(set, rr);
            }
        }
        System.out.println(";; Out of recursive call");
    }
}

