/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.proxy.extras;

import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.littleshoot.proxy.SslEngineSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelfSignedSslEngineSource
implements SslEngineSource {
    private static final Logger LOG = LoggerFactory.getLogger(SelfSignedSslEngineSource.class);
    private static final String ALIAS = "littleproxy";
    private static final String PASSWORD = "Be Your Own Lantern";
    private static final String PROTOCOL = "TLS";
    private final File keyStoreFile;
    private final boolean trustAllServers;
    private final boolean sendCerts;
    private SSLContext sslContext;

    public SelfSignedSslEngineSource(String keyStorePath, boolean trustAllServers, boolean sendCerts) {
        this.trustAllServers = trustAllServers;
        this.sendCerts = sendCerts;
        this.keyStoreFile = new File(keyStorePath);
        this.initializeKeyStore();
        this.initializeSSLContext();
    }

    public SelfSignedSslEngineSource(String keyStorePath) {
        this(keyStorePath, false, true);
    }

    public SelfSignedSslEngineSource(boolean trustAllServers) {
        this(trustAllServers, true);
    }

    public SelfSignedSslEngineSource(boolean trustAllServers, boolean sendCerts) {
        this("littleproxy_keystore.jks", trustAllServers, sendCerts);
    }

    public SelfSignedSslEngineSource() {
        this(false);
    }

    @Override
    public SSLEngine newSslEngine() {
        return this.sslContext.createSSLEngine();
    }

    @Override
    public SSLEngine newSslEngine(String peerHost, int peerPort) {
        return this.sslContext.createSSLEngine(peerHost, peerPort);
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    private void initializeKeyStore() {
        if (this.keyStoreFile.isFile()) {
            LOG.info("Not deleting keystore");
            return;
        }
        this.nativeCall("keytool", "-genkey", "-alias", ALIAS, "-keysize", "4096", "-validity", "36500", "-keyalg", "RSA", "-dname", "CN=littleproxy", "-keypass", PASSWORD, "-storepass", PASSWORD, "-keystore", this.keyStoreFile.getName());
        this.nativeCall("keytool", "-exportcert", "-alias", ALIAS, "-keystore", this.keyStoreFile.getName(), "-storepass", PASSWORD, "-file", "littleproxy_cert");
    }

    private void initializeSSLContext() {
        String algorithm = Security.getProperty("ssl.KeyManagerFactory.algorithm");
        if (algorithm == null) {
            algorithm = "SunX509";
        }
        try {
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(new FileInputStream(this.keyStoreFile), PASSWORD.toCharArray());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
            kmf.init(ks, PASSWORD.toCharArray());
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm);
            tmf.init(ks);
            TrustManager[] trustManagers = null;
            trustManagers = !this.trustAllServers ? tmf.getTrustManagers() : new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            }};
            KeyManager[] keyManagers = null;
            keyManagers = this.sendCerts ? kmf.getKeyManagers() : new KeyManager[]{};
            this.sslContext = SSLContext.getInstance(PROTOCOL);
            this.sslContext.init(keyManagers, trustManagers, null);
        }
        catch (Exception e) {
            throw new Error("Failed to initialize the server-side SSLContext", e);
        }
    }

    private String nativeCall(String ... commands) {
        LOG.info("Running '{}'", Arrays.asList(commands));
        ProcessBuilder pb = new ProcessBuilder(commands);
        try {
            Process process = pb.start();
            InputStream is = process.getInputStream();
            byte[] data = ByteStreams.toByteArray((InputStream)is);
            String dataAsString = new String(data);
            LOG.info("Completed native call: '{}'\nResponse: '" + dataAsString + "'", Arrays.asList(commands));
            return dataAsString;
        }
        catch (IOException e) {
            LOG.error("Error running commands: " + Arrays.asList(commands), (Throwable)e);
            return "";
        }
    }
}

