/*
 * Decompiled with CFR 0.152.
 */
package com.barchart.udt.nio;

import com.barchart.udt.ExceptionUDT;
import com.barchart.udt.SocketUDT;
import com.barchart.udt.TypeUDT;
import com.barchart.udt.anno.ThreadSafe;
import com.barchart.udt.nio.ChannelUDT;
import com.barchart.udt.nio.KindUDT;
import com.barchart.udt.nio.NioSocketUDT;
import com.barchart.udt.nio.SelectorProviderUDT;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ConnectionPendingException;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.SocketChannel;
import java.nio.channels.UnresolvedAddressException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketChannelUDT
extends SocketChannel
implements ChannelUDT {
    protected static final Logger log = LoggerFactory.getLogger(SocketChannelUDT.class);
    protected final Object connectLock = new Object();
    protected volatile boolean isBlockingMode = this.isBlocking();
    protected volatile boolean isConnectFinished;
    protected volatile boolean isConnectionPending;
    @ThreadSafe(value="this")
    protected NioSocketUDT socketAdapter;
    protected final SocketUDT socketUDT;

    protected SocketChannelUDT(SelectorProviderUDT provider, SocketUDT socketUDT) throws ExceptionUDT {
        super(provider);
        this.socketUDT = socketUDT;
        this.socketUDT.setBlocking(true);
    }

    protected SocketChannelUDT(SelectorProviderUDT provider, SocketUDT socketUDT, boolean isConnected) throws ExceptionUDT {
        this(provider, socketUDT);
        if (isConnected) {
            this.isConnectFinished = true;
            this.isConnectionPending = false;
        } else {
            this.isConnectFinished = false;
            this.isConnectionPending = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean connect(SocketAddress remote) throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if (this.isConnected()) {
            log.warn("already connected; ignoring remote={}", (Object)remote);
            return true;
        }
        if (remote == null) {
            this.close();
            log.error("remote == null");
            throw new NullPointerException();
        }
        InetSocketAddress remoteSocket = (InetSocketAddress)remote;
        if (remoteSocket.isUnresolved()) {
            log.error("can not use unresolved address: remote={}", (Object)remote);
            this.close();
            throw new UnresolvedAddressException();
        }
        if (this.isBlocking()) {
            Object object = this.connectLock;
            synchronized (object) {
                try {
                    if (this.isConnectionPending) {
                        this.close();
                        throw new ConnectionPendingException();
                    }
                    this.isConnectionPending = true;
                    this.begin();
                    this.socketUDT.connect(remoteSocket);
                }
                finally {
                    this.end(true);
                    this.isConnectionPending = false;
                    this.connectLock.notifyAll();
                }
            }
            return this.socketUDT.isConnected();
        }
        if (!this.isRegistered()) {
            log.error("UDT channel is in NON blocking mode; must register with a selector before trying to connect(); socketId=" + this.socketUDT.id());
            throw new IllegalBlockingModeException();
        }
        Object object = this.connectLock;
        synchronized (object) {
            if (this.isConnectionPending) {
                this.close();
                log.error("connection already in progress");
                throw new ConnectionPendingException();
            }
            this.isConnectFinished = false;
            this.isConnectionPending = true;
            this.socketUDT.connect(remoteSocket);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean finishConnect() throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if (this.isBlocking()) {
            Object object = this.connectLock;
            synchronized (object) {
                while (this.isConnectionPending) {
                    try {
                        this.connectLock.wait();
                    }
                    catch (InterruptedException e) {
                        throw new IOException(e);
                    }
                }
            }
        }
        if (this.isConnected()) {
            this.isConnectFinished = true;
            this.isConnectionPending = false;
            return true;
        }
        log.error("connect failure : {}", (Object)this.socketUDT);
        throw new IOException();
    }

    @Override
    protected void implCloseSelectableChannel() throws IOException {
        this.socketUDT.close();
    }

    @Override
    protected void implConfigureBlocking(boolean block) throws IOException {
        this.socketUDT.setBlocking(block);
        this.isBlockingMode = block;
    }

    @Override
    public boolean isConnected() {
        return this.socketUDT.isConnected();
    }

    @Override
    public boolean isConnectFinished() {
        return this.isConnectFinished;
    }

    @Override
    public boolean isConnectionPending() {
        return this.isConnectionPending;
    }

    @Override
    public KindUDT kindUDT() {
        return KindUDT.CONNECTOR;
    }

    @Override
    public SelectorProviderUDT providerUDT() {
        return (SelectorProviderUDT)super.provider();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer buffer) throws IOException {
        int sizeReceived;
        int remaining = buffer.remaining();
        if (remaining <= 0) {
            return 0;
        }
        SocketUDT socket = this.socketUDT;
        boolean isBlocking = this.isBlockingMode;
        try {
            if (isBlocking) {
                this.begin();
            }
            if (buffer.isDirect()) {
                sizeReceived = socket.receive(buffer);
            } else {
                int limit;
                int position;
                byte[] array = buffer.array();
                sizeReceived = socket.receive(array, position = buffer.position(), limit = buffer.limit());
                if (0 < sizeReceived && sizeReceived <= remaining) {
                    buffer.position(position + sizeReceived);
                }
            }
        }
        finally {
            if (isBlocking) {
                this.end(true);
            }
        }
        if (sizeReceived < 0) {
            return 0;
        }
        if (sizeReceived == 0) {
            return 0;
        }
        if (sizeReceived <= remaining) {
            return sizeReceived;
        }
        log.error("should not happen: socket={}", (Object)socket);
        return 0;
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        throw new RuntimeException("feature not available");
    }

    @Override
    public synchronized NioSocketUDT socket() {
        if (this.socketAdapter == null) {
            try {
                this.socketAdapter = new NioSocketUDT(this);
            }
            catch (ExceptionUDT e) {
                log.error("failed to make socket", e);
            }
        }
        return this.socketAdapter;
    }

    @Override
    public SocketUDT socketUDT() {
        return this.socketUDT;
    }

    public String toString() {
        return this.socketUDT.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int write(ByteBuffer buffer) throws IOException {
        if (buffer == null) {
            throw new NullPointerException("buffer == null");
        }
        int remaining = buffer.remaining();
        if (remaining <= 0) {
            return 0;
        }
        SocketUDT socket = this.socketUDT;
        boolean isBlocking = this.isBlockingMode;
        int sizeSent = 0;
        int ret = 0;
        try {
            if (isBlocking) {
                this.begin();
            }
            if (buffer.isDirect()) {
                do {
                    if ((ret = socket.send(buffer)) <= 0) continue;
                    sizeSent += ret;
                } while (buffer.hasRemaining() && isBlocking);
            } else {
                byte[] array = buffer.array();
                int position = buffer.position();
                int limit = buffer.limit();
                do {
                    if (0 >= (ret = socket.send(array, position, limit)) || ret > remaining) continue;
                    sizeSent += ret;
                    buffer.position(position += ret);
                } while (buffer.hasRemaining() && isBlocking);
            }
        }
        finally {
            if (isBlocking) {
                this.end(true);
            }
        }
        if (ret < 0) {
            return 0;
        }
        if (ret == 0) {
            return 0;
        }
        if (sizeSent <= remaining) {
            return sizeSent;
        }
        log.error("should not happen; socket={}", (Object)socket);
        return 0;
    }

    @Override
    public long write(ByteBuffer[] bufferArray, int offset, int length) throws IOException {
        try {
            long total = 0L;
            for (int index = offset; index < offset + length; ++index) {
                int processed;
                ByteBuffer buffer = bufferArray[index];
                int remaining = buffer.remaining();
                if (remaining == (processed = this.write(buffer))) {
                    total += (long)processed;
                    continue;
                }
                throw new IllegalStateException("failed to write buffer in array");
            }
            return total;
        }
        catch (Throwable e) {
            throw new IOException("failed to write buffer array", e);
        }
    }

    @Override
    public TypeUDT typeUDT() {
        return this.providerUDT().type();
    }

    @Override
    public SocketChannelUDT bind(SocketAddress localAddress) throws IOException {
        this.socketUDT.bind((InetSocketAddress)localAddress);
        return this;
    }
}

