/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.id.random;

import java.io.Serializable;
import java.util.Random;
import org.apache.commons.id.AbstractStringIdentifierGenerator;

public class SessionIdGenerator
extends AbstractStringIdentifierGenerator
implements Serializable {
    private static final long serialVersionUID = 20060118L;
    private static final long MAX_RANDOM_LEN = 2176782336L;
    private static final long MAX_TIME_SECTION_LEN = 46656L;
    private static final long TIC_DIFFERENCE = 2000L;
    private static final int RANDOM_LENGTH = 6;
    private static final int TIME_LENGTH = 3;
    private int counter = 0;
    private long lastTimeValue = 0L;
    private static Random randomizer = new Random();

    @Override
    public long maxLength() {
        return 9 + AbstractStringIdentifierGenerator.MAX_INT_ALPHANUMERIC_VALUE_LENGTH;
    }

    @Override
    public long minLength() {
        return 10L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String nextStringIdentifier() {
        long currentRandom = randomizer.nextLong();
        if (currentRandom < 0L) {
            currentRandom = -currentRandom;
        }
        currentRandom %= 2176782336L;
        currentRandom += 2176782336L;
        long currentTimeValue = 0L;
        int currentCount = 0;
        SessionIdGenerator sessionIdGenerator = this;
        synchronized (sessionIdGenerator) {
            currentTimeValue = System.currentTimeMillis() / 2000L;
            currentTimeValue %= 46656L;
            if (this.lastTimeValue != (currentTimeValue += 46656L)) {
                this.lastTimeValue = currentTimeValue;
                this.counter = 0;
            }
            currentCount = this.counter++;
        }
        StringBuffer id = new StringBuffer(15);
        id.append(Long.toString(currentRandom, 36).substring(1));
        id.append(Long.toString(currentTimeValue, 36).substring(1));
        id.append(Long.toString(currentCount, 36));
        return id.toString();
    }
}

