/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.id.uuid;

import org.apache.commons.discovery.tools.DiscoverSingleton;
import org.apache.commons.id.IdentifierGenerator;
import org.apache.commons.id.uuid.Bytes;
import org.apache.commons.id.uuid.Constants;
import org.apache.commons.id.uuid.NodeManager;
import org.apache.commons.id.uuid.NodeManagerImpl;
import org.apache.commons.id.uuid.UUID;
import org.apache.commons.id.uuid.clock.OverClockedException;
import org.apache.commons.id.uuid.state.Node;

public final class VersionOneGenerator
implements IdentifierGenerator,
Constants {
    private static final int NODE_ID_BYTE_LENGTH = 6;
    private static final int CLOCK_HI_VARIANT_BYTE8 = 8;
    private static final int CLOCK_LOW_BYTE9 = 9;
    private static final int NODE_ID_BYTE10 = 10;
    private static final String DEFAULT_NODEMANAGER_IMPL = NodeManagerImpl.class.getName();
    private NodeManager manager = (NodeManager)DiscoverSingleton.find(NodeManager.class, (String)DEFAULT_NODEMANAGER_IMPL);
    private static VersionOneGenerator generator;

    private VersionOneGenerator() {
    }

    public static VersionOneGenerator getInstance() {
        if (generator == null) {
            generator = new VersionOneGenerator();
        }
        return generator;
    }

    @Override
    public Object nextIdentifier() {
        return this.nextUUID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized UUID nextUUID() {
        byte[] rawUUID = new byte[16];
        long time = 0L;
        short clockSq = 0;
        Node node = this.manager.currentNode();
        while (time < 1L) {
            try {
                this.manager.lockNode(node);
                time = node.getUUIDTime();
                clockSq = node.getClockSequence();
                System.arraycopy(node.getNodeIdentifier(), 0, rawUUID, 10, 6);
                this.manager.releaseNode(node);
            }
            catch (OverClockedException e) {
                node = this.manager.nextAvailableNode();
            }
            finally {
                this.manager.releaseNode(node);
            }
        }
        byte[] timeBytes = Bytes.toBytes(time);
        System.arraycopy(timeBytes, 4, rawUUID, 0, 4);
        System.arraycopy(timeBytes, 2, rawUUID, 4, 2);
        System.arraycopy(timeBytes, 0, rawUUID, 6, 2);
        rawUUID[6] = (byte)(rawUUID[6] | 0x10);
        rawUUID[8] = (byte)((clockSq & 0x3F00) >>> 8);
        rawUUID[8] = (byte)(rawUUID[8] | 0x80);
        rawUUID[9] = (byte)(clockSq & 0xFF);
        return new UUID(rawUUID);
    }
}

