/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.download;

import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import org.lastbamboo.common.download.Downloader;
import org.lastbamboo.common.download.DownloaderListener;
import org.lastbamboo.common.download.DownloaderState;

public abstract class AbstractDownloader<T extends DownloaderState>
implements Downloader<T> {
    private final Collection<DownloaderListener<T>> m_listeners = new LinkedList<DownloaderListener<T>>();
    private final long m_startTime = new Date().getTime();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireStateChanged(T state) {
        Collection<DownloaderListener<T>> collection = this.m_listeners;
        synchronized (collection) {
            for (DownloaderListener<T> listener : this.m_listeners) {
                listener.stateChanged(state);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addListener(DownloaderListener<T> listener) {
        Collection<DownloaderListener<T>> collection = this.m_listeners;
        synchronized (collection) {
            this.m_listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(DownloaderListener<T> listener) {
        Collection<DownloaderListener<T>> collection = this.m_listeners;
        synchronized (collection) {
            this.m_listeners.remove(listener);
        }
    }

    @Override
    public long getStartTime() {
        return this.m_startTime;
    }
}

