/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.download;

import org.lastbamboo.common.download.RangeSizeSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRangeSizeSelector
implements RangeSizeSelector {
    private final Logger m_log = LoggerFactory.getLogger(this.getClass());
    public static final long MAX_CHUNK_SIZE = 524288L;
    public static final long MIN_CHUNK_SIZE = 30720L;
    public static final long DIFFERENTIAL_SPEED_FACTOR = 10L;

    @Override
    public long selectSize(long fileSize, int numSources) {
        long theoreticalChunkSize = (long)Math.ceil(fileSize / (long)numSources / 10L);
        long upperCapChunkSize = Math.min(524288L, theoreticalChunkSize);
        long lowerCapChunkSize = Math.max(upperCapChunkSize, 30720L);
        long finalSize = numSources == 1 ? fileSize : Math.min(fileSize, lowerCapChunkSize);
        this.m_log.debug("Size for " + numSources + " source(s) for file of size " + fileSize + " is " + finalSize);
        this.m_log.debug("Differential speed factor: ", (Object)(fileSize / (finalSize * (long)numSources)));
        return finalSize;
    }
}

