/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.download;

import org.lastbamboo.common.download.DownloaderStateType;
import org.littleshoot.util.TimeUtils;

public interface DownloaderState {
    public DownloaderStateType getType();

    public static abstract class AbstractSucceeded
    implements DownloaderState {
        @Override
        public DownloaderStateType getType() {
            return DownloaderStateType.SUCCEEDED;
        }
    }

    public static abstract class AbstractFailed
    implements DownloaderState {
        @Override
        public DownloaderStateType getType() {
            return DownloaderStateType.FAILED;
        }
    }

    public static abstract class AbstractRunning
    implements DownloaderState {
        @Override
        public DownloaderStateType getType() {
            return DownloaderStateType.RUNNING;
        }

        public String calculateTimeRemaining(long read, long size, double kbs) {
            long bytesRemaining = size - read;
            double bs = kbs * 1024.0;
            long secondsRemaining = (long)((double)bytesRemaining / bs);
            return TimeUtils.secondsToHoursMinutesSeconds((long)secondsRemaining);
        }
    }
}

