/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.download;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.concurrent.PriorityBlockingQueue;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.math.LongRange;
import org.lastbamboo.common.download.LaunchFileTracker;
import org.littleshoot.util.Base32;
import org.littleshoot.util.Sha1;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadingFileLauncher
implements LaunchFileTracker {
    private final Logger m_log = LoggerFactory.getLogger(this.getClass());
    private final PriorityBlockingQueue<LongRange> m_completedRanges;
    private final RandomAccessFile m_randomAccessFile;
    private volatile long m_rangeIndex = 0L;
    private volatile boolean m_completeFlag = false;
    private final URI m_expectedSha1;
    private DigestOutputStream m_digestOutputStream;
    private volatile boolean m_writtenAll = false;
    private final File m_incompleteFile;
    private volatile boolean m_streamClosed = false;
    private volatile boolean m_failed = false;
    private volatile boolean m_stopped;

    public DownloadingFileLauncher(RandomAccessFile raf, PriorityBlockingQueue<LongRange> completedRanges, URI expectedSha1, File incompleteFile) {
        if (raf == null) {
            throw new NullPointerException("Null RAF");
        }
        if (completedRanges == null) {
            throw new NullPointerException("Null ranges");
        }
        this.m_randomAccessFile = raf;
        this.m_completedRanges = completedRanges;
        this.m_expectedSha1 = expectedSha1;
        this.m_incompleteFile = incompleteFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRangeComplete(LongRange range) {
        PriorityBlockingQueue<LongRange> priorityBlockingQueue = this.m_completedRanges;
        synchronized (priorityBlockingQueue) {
            this.m_completedRanges.add(range);
            if (range.getMinimumLong() == this.m_rangeIndex) {
                this.m_completedRanges.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFailure() {
        this.m_failed = true;
        IOUtils.closeQuietly((OutputStream)this.m_digestOutputStream);
        this.m_streamClosed = true;
        PriorityBlockingQueue<LongRange> priorityBlockingQueue = this.m_completedRanges;
        synchronized (priorityBlockingQueue) {
            this.m_completedRanges.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(OutputStream os, boolean cancelOnStreamClose) throws IOException {
        this.m_digestOutputStream = new DigestOutputStream(os, (MessageDigest)new Sha1());
        try {
            this.writeAllRanges(this.m_digestOutputStream);
            this.m_log.debug("Wrote all ranges...");
        }
        catch (IOException e) {
            this.m_log.debug("IO error writing file: " + this.m_incompleteFile.getName(), (Throwable)e);
            this.m_streamClosed = true;
            throw e;
        }
        catch (Throwable t) {
            this.m_log.warn("Throwable streaming file: " + this.m_incompleteFile.getName(), t);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)this.m_digestOutputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeAllRanges(OutputStream os) throws IOException {
        if (this.m_log.isDebugEnabled()) {
            this.m_log.debug("Writing " + this.m_completedRanges.size() + " completed ranges...");
        }
        while (true) {
            long startIndex;
            PriorityBlockingQueue<LongRange> priorityBlockingQueue = this.m_completedRanges;
            synchronized (priorityBlockingQueue) {
                LongRange nextRange;
                startIndex = this.m_rangeIndex;
                while (!this.m_completedRanges.isEmpty() && (nextRange = this.m_completedRanges.peek()).getMinimumLong() == this.m_rangeIndex) {
                    this.m_rangeIndex = nextRange.getMaximumLong() + 1L;
                    this.m_completedRanges.remove();
                }
            }
            this.writeRange(startIndex, this.m_rangeIndex, os);
            priorityBlockingQueue = this.m_completedRanges;
            synchronized (priorityBlockingQueue) {
                if (this.done()) {
                    this.m_log.debug("We're done.  Flushing and notifying for: {}", (Object)this.m_incompleteFile.getName());
                    os.flush();
                    os.close();
                    this.m_writtenAll = true;
                    this.m_completedRanges.notifyAll();
                    return;
                }
                LongRange range = this.m_completedRanges.peek();
                if (range == null || range.getMinimumLong() != this.m_rangeIndex) {
                    try {
                        this.timedWait();
                        if (this.m_failed || this.m_stopped) {
                            this.m_log.debug("Download failed...");
                            os.flush();
                            os.close();
                            this.m_completedRanges.notifyAll();
                            return;
                        }
                        if (this.done()) {
                            this.m_log.debug("We're done.  Writing any remaining...");
                            os.flush();
                            os.close();
                            this.m_writtenAll = true;
                            this.m_completedRanges.notifyAll();
                            return;
                        }
                    }
                    catch (InterruptedException e) {
                        this.m_log.warn("Interrupted!!", (Throwable)e);
                        break;
                    }
                }
            }
        }
    }

    private void timedWait() throws InterruptedException {
        long waitStart = System.currentTimeMillis();
        this.m_completedRanges.wait(86400000L);
        long waitTime = System.currentTimeMillis() - waitStart;
        if (waitTime > 3600000L) {
            this.m_log.warn("Waited for download for more than an hour: " + waitTime / 1000L / 60L);
        }
    }

    private boolean done() {
        return this.m_completedRanges.isEmpty() && this.m_completeFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRange(long startIndex, long endIndex, OutputStream os) throws IOException {
        int index = 0;
        long length = endIndex - startIndex;
        long maxChunkSize = 512000L;
        while ((long)index < length) {
            int numBytesRead;
            long curChunkSize = length - (long)index < 512000L ? length - (long)index : 512000L;
            byte[] bytesToCopy = new byte[(int)curChunkSize];
            long baseIndex = startIndex + (long)index;
            RandomAccessFile randomAccessFile = this.m_randomAccessFile;
            synchronized (randomAccessFile) {
                this.m_randomAccessFile.seek(baseIndex);
                numBytesRead = this.m_randomAccessFile.read(bytesToCopy);
            }
            if ((long)numBytesRead != curChunkSize) {
                this.m_log.warn("Unexpected number of bytes read.  Expected " + curChunkSize + " but was " + numBytesRead);
            }
            os.write(bytesToCopy);
            index += numBytesRead;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFileComplete() {
        this.m_log.debug("Received notification file is complete");
        PriorityBlockingQueue<LongRange> priorityBlockingQueue = this.m_completedRanges;
        synchronized (priorityBlockingQueue) {
            this.m_completeFlag = true;
            this.m_completedRanges.notifyAll();
            if (this.m_streamClosed) {
                this.m_log.debug("Stream is closed...returning");
                return;
            }
            while (!this.m_completedRanges.isEmpty()) {
                this.m_log.debug("Waiting to write remaining bytes...next range: {}", (Object)this.m_rangeIndex);
                try {
                    this.timedWait();
                }
                catch (InterruptedException e) {
                    this.m_log.error("Interrupted while writing...");
                }
            }
        }
        this.verifySha1();
        this.m_log.debug("Returning from file complete notification...");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifySha1() {
        PriorityBlockingQueue<LongRange> priorityBlockingQueue = this.m_completedRanges;
        synchronized (priorityBlockingQueue) {
            while (!this.m_writtenAll && !this.m_stopped) {
                try {
                    this.timedWait();
                }
                catch (InterruptedException e) {
                    this.m_log.error("Interrupted?", (Throwable)e);
                }
            }
        }
        if (this.m_stopped) {
            this.m_log.debug("Download stopped!");
            return;
        }
        byte[] sha1Bytes = this.m_digestOutputStream.getMessageDigest().digest();
        try {
            URI sha1 = new URI("urn:sha1:" + Base32.encode((byte[])sha1Bytes));
            if (this.m_expectedSha1 == null) {
                this.m_log.debug("Null expected SHA-1.  Testing?");
            } else {
                if (!this.m_expectedSha1.equals(sha1)) {
                    this.m_log.error("Did not get expected SHA-1!!!  Expected " + this.m_expectedSha1 + " but was " + sha1);
                    throw new IllegalStateException("SHA-1 mismatch!!");
                }
                this.m_log.debug("SHA-1s match!!");
            }
        }
        catch (URISyntaxException e) {
            this.m_log.error("Could not encode SHA-1", (Throwable)e);
        }
    }

    @Override
    public int getActiveWriteCalls() {
        return 0;
    }

    @Override
    public void waitForLaunchersToComplete() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDownloadStopped() {
        if (this.done()) {
            this.m_log.debug("Already finished.");
            return;
        }
        this.m_streamClosed = true;
        PriorityBlockingQueue<LongRange> priorityBlockingQueue = this.m_completedRanges;
        synchronized (priorityBlockingQueue) {
            this.m_completedRanges.notifyAll();
        }
        this.m_stopped = true;
        if (this.m_digestOutputStream != null) {
            IOUtils.closeQuietly((OutputStream)this.m_digestOutputStream);
        }
    }
}

