/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.download;

import java.io.File;
import java.io.OutputStream;
import org.lastbamboo.common.download.AbstractDownloader;
import org.lastbamboo.common.download.Downloader;
import org.lastbamboo.common.download.DownloaderListener;
import org.lastbamboo.common.download.DownloaderState;
import org.lastbamboo.common.download.DownloaderStateType;
import org.lastbamboo.common.download.Sha1DState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DummySha1Downloader<DsT extends DownloaderState>
extends AbstractDownloader<Sha1DState<DsT>>
implements Downloader<Sha1DState<DsT>> {
    private final Logger m_log = LoggerFactory.getLogger(this.getClass());
    private final Downloader<DsT> m_delegate;
    private Sha1DState<DsT> m_state;
    private final long m_expectedSize;

    public DummySha1Downloader(Downloader<DsT> delegate, long expectedSize) {
        this.m_delegate = delegate;
        this.m_expectedSize = expectedSize;
        this.m_state = new Sha1DState.DownloadingImpl<DsT>(this.m_delegate.getState());
        this.m_delegate.addListener(new DelegateListener());
    }

    private void setState(Sha1DState<DsT> state) {
        if (!this.m_state.equals(state)) {
            this.m_state = state;
            this.fireStateChanged(state);
        }
    }

    @Override
    public File getIncompleteFile() {
        return this.m_delegate.getIncompleteFile();
    }

    @Override
    public long getSize() {
        return this.m_delegate.getSize();
    }

    @Override
    public Sha1DState<DsT> getState() {
        return this.m_state;
    }

    @Override
    public void start() {
        this.m_delegate.start();
    }

    @Override
    public void stop(boolean removeFiles) {
        this.m_delegate.stop(removeFiles);
    }

    @Override
    public void pause() {
        this.m_delegate.pause();
    }

    @Override
    public void resume() {
        this.m_delegate.resume();
    }

    @Override
    public boolean isStarted() {
        return this.m_delegate.isStarted();
    }

    @Override
    public void write(OutputStream os, boolean cancelOnStreamClose) {
        this.m_delegate.write(os, cancelOnStreamClose);
    }

    @Override
    public String getFinalName() {
        return this.m_delegate.getFinalName();
    }

    @Override
    public File getCompleteFile() {
        return this.m_delegate.getCompleteFile();
    }

    private static <DsT> boolean isDownloading(Sha1DState<DsT> state) {
        Sha1DState.VisitorAdapter visitor = new Sha1DState.VisitorAdapter<Boolean, DsT>(Boolean.FALSE){

            @Override
            public Boolean visitDownloading(Sha1DState.Downloading<DsT> downloading) {
                return Boolean.TRUE;
            }
        };
        return (Boolean)state.accept(visitor);
    }

    private class DelegateListener
    implements DownloaderListener<DsT> {
        private DelegateListener() {
        }

        @Override
        public void stateChanged(DsT state) {
            if (state.getType() == DownloaderStateType.SUCCEEDED) {
                this.downloadComplete();
            } else if (state.getType() == DownloaderStateType.FAILED) {
                DummySha1Downloader.this.m_log.debug("Download failed...");
                DummySha1Downloader.this.setState(new Sha1DState.FailedImpl(state));
            } else if (DummySha1Downloader.isDownloading(DummySha1Downloader.this.m_state)) {
                DummySha1Downloader.this.m_log.debug("Is downloading");
                DummySha1Downloader.this.setState(new Sha1DState.DownloadingImpl(state));
            } else {
                DummySha1Downloader.this.m_log.debug("Is not downloading");
                DummySha1Downloader.this.m_log.warn("Got delegate downloader event despite being done with the downloader: " + state);
            }
        }

        private void downloadComplete() {
            File file = DummySha1Downloader.this.m_delegate.getIncompleteFile();
            if (file == null) {
                DummySha1Downloader.this.setState(new Sha1DState.VerifiedSha1Impl());
            } else if (file.length() != DummySha1Downloader.this.m_expectedSize) {
                DummySha1Downloader.this.m_log.warn("The downloaded file has an unexpected size.  Expected: " + DummySha1Downloader.this.m_expectedSize + " but was: " + file.length());
                DummySha1Downloader.this.setState(new Sha1DState.Sha1MismatchImpl());
            } else {
                DummySha1Downloader.this.setState(new Sha1DState.VerifiedSha1Impl());
            }
        }
    }
}

