/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.download;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.concurrent.PriorityBlockingQueue;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.math.LongRange;
import org.lastbamboo.common.download.DownloadingFileLauncher;
import org.lastbamboo.common.download.IncreasingLongRangeComparator;
import org.lastbamboo.common.download.LaunchFileTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LaunchFileDispatcher
implements LaunchFileTracker {
    private final Logger m_log = LoggerFactory.getLogger(LaunchFileDispatcher.class);
    private final Collection<LaunchFileTracker> m_trackers = Collections.synchronizedList(new LinkedList());
    private final RandomAccessFile m_randomAccessFile;
    private final PriorityBlockingQueue<LongRange> m_completedRanges;
    private final int m_initialQueueSize;
    private volatile long m_rangeIndex = 0L;
    private final File m_incompleteFile;
    private boolean m_complete = false;
    private volatile int m_activeWriteCalls = 0;
    private final Object DOWNLOAD_STREAM_LOCK = new Object();
    private final URI m_expectedSha1;

    public LaunchFileDispatcher(File incompleteFile, RandomAccessFile raf, int initialQueueSize, URI expectedSha1) {
        if (incompleteFile == null) {
            throw new NullPointerException("Null RAF");
        }
        if (raf == null) {
            throw new NullPointerException("Null ranges");
        }
        this.m_incompleteFile = incompleteFile;
        this.m_randomAccessFile = raf;
        this.m_initialQueueSize = initialQueueSize > 0 ? (initialQueueSize > 1000 ? 1000 : initialQueueSize) : 1;
        this.m_expectedSha1 = expectedSha1;
        this.m_completedRanges = this.createQueue();
    }

    private PriorityBlockingQueue<LongRange> createQueue() {
        IncreasingLongRangeComparator increasingRangeComparator = new IncreasingLongRangeComparator();
        return new PriorityBlockingQueue<LongRange>(this.m_initialQueueSize, increasingRangeComparator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForLaunchersToComplete() {
        Object object = this.DOWNLOAD_STREAM_LOCK;
        synchronized (object) {
            if (this.m_activeWriteCalls == 0) {
                this.m_log.debug("No active launchers for: {}", (Object)this.m_incompleteFile.getName());
                return;
            }
            this.m_log.debug("Waiting for active streams to finish for: {}", (Object)this.m_incompleteFile.getName());
            try {
                this.DOWNLOAD_STREAM_LOCK.wait(3600000L);
                if (this.m_activeWriteCalls > 0) {
                    this.m_log.warn("Still " + this.m_activeWriteCalls + " active writes!!");
                }
            }
            catch (InterruptedException e) {
                this.m_log.warn("Unexpected interrupt!!", (Throwable)e);
            }
            this.m_log.debug("Finished waiting...");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(OutputStream os, boolean cancelOnStreamClose) throws IOException {
        Object object;
        this.m_log.debug("Writing file...");
        try {
            ++this.m_activeWriteCalls;
            if (this.m_complete) {
                this.m_log.debug("Writing file on disk...");
                this.writeCompleteFile(os);
            } else {
                this.m_log.debug("Writing downloading file...");
                this.writeDownloadingFile(os, cancelOnStreamClose);
            }
            this.m_log.debug("Finished launcher write call...");
            object = this.DOWNLOAD_STREAM_LOCK;
            synchronized (object) {
                if (this.m_activeWriteCalls == 1) {
                    this.DOWNLOAD_STREAM_LOCK.notify();
                }
            }
        }
        finally {
            object = this.DOWNLOAD_STREAM_LOCK;
            synchronized (object) {
                --this.m_activeWriteCalls;
                this.m_log.debug("Decremented active writes for: " + this.m_incompleteFile.getName() + " Now: " + this.m_activeWriteCalls);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeCompleteFile(OutputStream os) throws IOException {
        try {
            FileInputStream is = new FileInputStream(this.m_incompleteFile);
            IOUtils.copy((InputStream)is, (OutputStream)os);
        }
        finally {
            os.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDownloadingFile(OutputStream os, boolean cancelOnStreamClose) throws IOException {
        DownloadingFileLauncher tracker;
        PriorityBlockingQueue<LongRange> completedRanges = this.createQueue();
        Collection<LaunchFileTracker> collection = this.m_trackers;
        synchronized (collection) {
            PriorityBlockingQueue<LongRange> priorityBlockingQueue = this.m_completedRanges;
            synchronized (priorityBlockingQueue) {
                completedRanges.addAll(this.m_completedRanges);
                tracker = new DownloadingFileLauncher(this.m_randomAccessFile, completedRanges, this.m_expectedSha1, this.m_incompleteFile);
                this.m_trackers.add(tracker);
            }
        }
        tracker.write(os, cancelOnStreamClose);
    }

    public void onRangeComplete(LongRange range) {
        this.onRangeCompleteOptimized(range);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onRangeCompleteVanilla(LongRange range) {
        Collection<LaunchFileTracker> collection = this.m_trackers;
        synchronized (collection) {
            for (LaunchFileTracker tracker : this.m_trackers) {
                PriorityBlockingQueue<LongRange> priorityBlockingQueue = this.m_completedRanges;
                synchronized (priorityBlockingQueue) {
                    this.m_completedRanges.add(range);
                }
                tracker.onRangeComplete(range);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onRangeCompleteOptimized(LongRange range) {
        PriorityBlockingQueue<LongRange> priorityBlockingQueue = this.m_completedRanges;
        synchronized (priorityBlockingQueue) {
            if (range.getMinimumLong() == this.m_rangeIndex) {
                LongRange nextRange;
                if (this.m_rangeIndex != 0L) {
                    this.m_completedRanges.poll();
                }
                this.m_rangeIndex = range.getMaximumLong() + 1L;
                while (!this.m_completedRanges.isEmpty() && (nextRange = this.m_completedRanges.peek()).getMinimumLong() == this.m_rangeIndex) {
                    this.m_rangeIndex = nextRange.getMaximumLong() + 1L;
                    this.m_completedRanges.remove();
                }
                LongRange startRange = new LongRange(0L, this.m_rangeIndex - 1L);
                this.m_completedRanges.add(startRange);
            } else {
                this.m_completedRanges.add(range);
            }
        }
        this.notifyTrackers(range);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyTrackers(LongRange range) {
        Collection<LaunchFileTracker> collection = this.m_trackers;
        synchronized (collection) {
            for (LaunchFileTracker tracker : this.m_trackers) {
                tracker.onRangeComplete(range);
            }
        }
    }

    public Collection<LongRange> getRanges() {
        return this.m_completedRanges;
    }

    public void addTracker(LaunchFileTracker tracker) {
        this.m_trackers.add(tracker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFileComplete() {
        Collection<LaunchFileTracker> collection = this.m_trackers;
        synchronized (collection) {
            for (LaunchFileTracker tracker : this.m_trackers) {
                tracker.onFileComplete();
            }
        }
        this.m_complete = true;
    }

    @Override
    public int getActiveWriteCalls() {
        return this.m_activeWriteCalls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFailure() {
        Collection<LaunchFileTracker> collection = this.m_trackers;
        synchronized (collection) {
            for (LaunchFileTracker tracker : this.m_trackers) {
                tracker.onFailure();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDownloadStopped() {
        Collection<LaunchFileTracker> collection = this.m_trackers;
        synchronized (collection) {
            for (LaunchFileTracker tracker : this.m_trackers) {
                tracker.onDownloadStopped();
            }
        }
    }
}

