/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.download;

import org.lastbamboo.common.download.DownloaderState;
import org.lastbamboo.common.download.RateCalculator;

public interface MsDState
extends DownloaderState {
    public static final MsDState IDLE = new IdleImpl();
    public static final MsDState GETTING_SOURCES = new GettingSourcesImpl();
    public static final MsDState COMPLETE = new CompleteImpl();
    public static final MsDState CANCELED = new CanceledImpl();
    public static final MsDState NO_SOURCES_AVAILABLE = new NoSourcesAvailableImpl();
    public static final MsDState COULD_NOT_DETERMINE_SOURCES = new CouldNotDetermineSourcesImpl();
    public static final MsDState FAILED = new FailedImpl();

    public <T> T accept(Visitor<T> var1);

    public static class CouldNotDetermineSourcesImpl
    extends DownloaderState.AbstractFailed
    implements CouldNotDetermineSources {
        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitCouldNotDetermineSources(this);
        }

        public boolean equals(Object otherObject) {
            return otherObject instanceof CouldNotDetermineSources;
        }
    }

    public static class NoSourcesAvailableImpl
    extends DownloaderState.AbstractFailed
    implements NoSourcesAvailable {
        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitNoSourcesAvailable(this);
        }

        public boolean equals(Object otherObject) {
            return otherObject instanceof NoSourcesAvailable;
        }
    }

    public static class FailedImpl
    extends DownloaderState.AbstractFailed
    implements Failed {
        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitFailed(this);
        }

        public boolean equals(Object otherObject) {
            return otherObject instanceof Failed;
        }
    }

    public static class CanceledImpl
    extends DownloaderState.AbstractFailed
    implements Canceled {
        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitCanceled(this);
        }

        public boolean equals(Object otherObject) {
            return otherObject instanceof Canceled;
        }
    }

    public static class CompleteImpl
    extends DownloaderState.AbstractSucceeded
    implements Complete {
        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitComplete(this);
        }

        public boolean equals(Object otherObject) {
            return otherObject instanceof Complete;
        }
    }

    public static class PausedImpl
    extends DownloaderState.AbstractRunning
    implements Paused {
        private final Downloading m_downloading;

        public PausedImpl(Downloading downloading) {
            this.m_downloading = downloading;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitPaused(this);
        }

        public boolean equals(Object otherObject) {
            return otherObject instanceof Canceled;
        }

        @Override
        public Downloading getDownloadingState() {
            return this.m_downloading;
        }
    }

    public static class LittleShootDownloadingState
    extends DownloaderState.AbstractRunning
    implements LittleShootDownloading {
        private final int m_numSources;
        private final RateCalculator m_rateCalculator;
        private final long m_size;

        public LittleShootDownloadingState(RateCalculator rateCalculator, int numSources, long size) {
            this.m_rateCalculator = rateCalculator;
            this.m_numSources = numSources;
            this.m_size = size;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitLittleShootDownloading(this);
        }

        @Override
        public double getKbs() {
            return this.m_rateCalculator.getRate();
        }

        @Override
        public int getNumSources() {
            return this.m_numSources;
        }

        @Override
        public long getBytesRead() {
            return this.m_rateCalculator.getBytesRead();
        }

        @Override
        public String getTimeRemaining() {
            return this.calculateTimeRemaining(this.getBytesRead(), this.m_size, this.getKbs());
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.m_numSources;
            result = 31 * result + (this.m_rateCalculator == null ? 0 : this.m_rateCalculator.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LittleShootDownloadingState other = (LittleShootDownloadingState)obj;
            if (this.m_numSources != other.m_numSources) {
                return false;
            }
            return !(this.m_rateCalculator == null ? other.m_rateCalculator != null : !this.m_rateCalculator.equals(other.m_rateCalculator));
        }
    }

    public static class LimeWireDownloadingState
    extends DownloaderState.AbstractRunning
    implements LimeWireDownloading {
        private final double m_kbs;
        private final int m_numSources;
        private final long m_bytesRead;
        private final long m_size;

        public LimeWireDownloadingState(double kbs, int numSources, long bytesRead, long size) {
            this.m_kbs = kbs;
            this.m_numSources = numSources;
            this.m_bytesRead = bytesRead;
            this.m_size = size;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitLimeWireDownloading(this);
        }

        @Override
        public double getKbs() {
            return this.m_kbs;
        }

        @Override
        public int getNumSources() {
            return this.m_numSources;
        }

        @Override
        public long getBytesRead() {
            return this.m_bytesRead;
        }

        @Override
        public String getTimeRemaining() {
            return this.calculateTimeRemaining(this.m_bytesRead, this.m_size, this.m_kbs);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)(this.m_bytesRead ^ this.m_bytesRead >>> 32);
            long temp = Double.doubleToLongBits(this.m_kbs);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            result = 31 * result + this.m_numSources;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LimeWireDownloadingState other = (LimeWireDownloadingState)obj;
            if (this.m_bytesRead != other.m_bytesRead) {
                return false;
            }
            if (Double.doubleToLongBits(this.m_kbs) != Double.doubleToLongBits(other.m_kbs)) {
                return false;
            }
            return this.m_numSources == other.m_numSources;
        }
    }

    public static class LibTorrentDownloadingState
    extends DownloaderState.AbstractRunning
    implements LibTorrentDownloading {
        private final double m_kbs;
        private final int m_numSources;
        private final long m_bytesRead;
        private final int m_numFiles;
        private final long m_maxByte;
        private final long m_size;

        public LibTorrentDownloadingState(int bytesPerSecond, int numSources, long bytesRead, int numFiles, long maxByte, long size) {
            this.m_kbs = this.bsToKbs(bytesPerSecond);
            this.m_numSources = numSources;
            this.m_bytesRead = bytesRead;
            this.m_numFiles = numFiles;
            this.m_maxByte = maxByte;
            this.m_size = size;
        }

        private double bsToKbs(double bytesPerSecond) {
            double kbs = bytesPerSecond / 1024.0;
            return kbs;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitLibTorrentDownloading(this);
        }

        @Override
        public double getKbs() {
            return this.m_kbs;
        }

        @Override
        public int getNumSources() {
            return this.m_numSources;
        }

        @Override
        public long getBytesRead() {
            return this.m_bytesRead;
        }

        @Override
        public long getMaxContiguousByte() {
            return this.m_maxByte;
        }

        @Override
        public int getNumFiles() {
            return this.m_numFiles;
        }

        @Override
        public String getTimeRemaining() {
            return this.calculateTimeRemaining(this.m_bytesRead, this.m_size, this.m_kbs);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)(this.m_bytesRead ^ this.m_bytesRead >>> 32);
            long temp = Double.doubleToLongBits(this.m_kbs);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            result = 31 * result + (int)(this.m_maxByte ^ this.m_maxByte >>> 32);
            result = 31 * result + this.m_numFiles;
            result = 31 * result + this.m_numSources;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LibTorrentDownloadingState other = (LibTorrentDownloadingState)obj;
            if (this.m_bytesRead != other.m_bytesRead) {
                return false;
            }
            if (Double.doubleToLongBits(this.m_kbs) != Double.doubleToLongBits(other.m_kbs)) {
                return false;
            }
            if (this.m_maxByte != other.m_maxByte) {
                return false;
            }
            if (this.m_numFiles != other.m_numFiles) {
                return false;
            }
            return this.m_numSources == other.m_numSources;
        }
    }

    public static class GettingSourcesImpl
    extends DownloaderState.AbstractRunning
    implements GettingSources {
        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitGettingSources(this);
        }

        public boolean equals(Object otherObject) {
            return otherObject instanceof GettingSources;
        }
    }

    public static class IdleImpl
    extends DownloaderState.AbstractRunning
    implements Idle {
        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitIdle(this);
        }

        public boolean equals(Object otherObject) {
            return otherObject instanceof Idle;
        }
    }

    public static interface CouldNotDetermineSources
    extends MsDState {
    }

    public static interface NoSourcesAvailable
    extends MsDState {
    }

    public static interface Failed
    extends MsDState {
    }

    public static interface Canceled
    extends MsDState {
    }

    public static interface Complete
    extends MsDState {
    }

    public static interface LibTorrentDownloading
    extends Downloading {
        public long getMaxContiguousByte();

        public int getNumFiles();
    }

    public static interface LimeWireDownloading
    extends Downloading {
    }

    public static interface LittleShootDownloading
    extends Downloading {
    }

    public static interface Downloading
    extends MsDState {
        public double getKbs();

        public int getNumSources();

        public long getBytesRead();

        public String getTimeRemaining();
    }

    public static interface Paused
    extends MsDState {
        public Downloading getDownloadingState();
    }

    public static interface GettingSources
    extends MsDState {
    }

    public static interface Idle
    extends MsDState {
    }

    public static abstract class VisitorAdapter<T>
    implements Visitor<T> {
        private final T m_defaultValue;

        public VisitorAdapter(T defaultValue) {
            this.m_defaultValue = defaultValue;
        }

        @Override
        public T visitCouldNotDetermineSources(CouldNotDetermineSources state) {
            return this.m_defaultValue;
        }

        @Override
        public T visitComplete(Complete state) {
            return this.m_defaultValue;
        }

        @Override
        public T visitPaused(Paused state) {
            return this.m_defaultValue;
        }

        @Override
        public T visitCanceled(Canceled state) {
            return this.m_defaultValue;
        }

        @Override
        public T visitFailed(Failed state) {
            return this.m_defaultValue;
        }

        @Override
        public T visitGettingSources(GettingSources state) {
            return this.m_defaultValue;
        }

        @Override
        public T visitIdle(Idle state) {
            return this.m_defaultValue;
        }

        @Override
        public T visitNoSourcesAvailable(NoSourcesAvailable state) {
            return this.m_defaultValue;
        }

        @Override
        public T visitLittleShootDownloading(LittleShootDownloading littleShootDownloadingState) {
            return this.m_defaultValue;
        }

        @Override
        public T visitLimeWireDownloading(LimeWireDownloading limeWireDownloadingState) {
            return this.m_defaultValue;
        }

        @Override
        public T visitLibTorrentDownloading(LibTorrentDownloading libTorrentDownloadingState) {
            return this.m_defaultValue;
        }
    }

    public static interface Visitor<T> {
        public T visitIdle(Idle var1);

        public T visitGettingSources(GettingSources var1);

        public T visitComplete(Complete var1);

        public T visitPaused(Paused var1);

        public T visitCanceled(Canceled var1);

        public T visitNoSourcesAvailable(NoSourcesAvailable var1);

        public T visitCouldNotDetermineSources(CouldNotDetermineSources var1);

        public T visitFailed(Failed var1);

        public T visitLittleShootDownloading(LittleShootDownloading var1);

        public T visitLimeWireDownloading(LimeWireDownloading var1);

        public T visitLibTorrentDownloading(LibTorrentDownloading var1);
    }
}

