/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.download;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.prefs.Preferences;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.lang.math.LongRange;
import org.lastbamboo.common.download.AbstractDownloader;
import org.lastbamboo.common.download.DownloadSpeedComparator;
import org.lastbamboo.common.download.DownloadVisitor;
import org.lastbamboo.common.download.LaunchFileDispatcher;
import org.lastbamboo.common.download.LaunchFileTracker;
import org.lastbamboo.common.download.LaunchFileTrackerAdapter;
import org.lastbamboo.common.download.LittleShootDownloader;
import org.lastbamboo.common.download.MsDState;
import org.lastbamboo.common.download.RangeDownloadListener;
import org.lastbamboo.common.download.RangeDownloader;
import org.lastbamboo.common.download.RangeTracker;
import org.lastbamboo.common.download.RangeTrackerAdapter;
import org.lastbamboo.common.download.RangeTrackerImpl;
import org.lastbamboo.common.download.RateCalculator;
import org.lastbamboo.common.download.RateCalculatorImpl;
import org.lastbamboo.common.download.SingleSourceDownloader;
import org.lastbamboo.common.download.SourceRanker;
import org.lastbamboo.common.download.SourceRankerImpl;
import org.lastbamboo.common.download.UriResolver;
import org.lastbamboo.common.download.VisitableDownloader;
import org.lastbamboo.common.http.client.CommonsHttpClient;
import org.lastbamboo.common.http.client.CommonsHttpClientImpl;
import org.littleshoot.util.None;
import org.littleshoot.util.Optional;
import org.littleshoot.util.OptionalVisitor;
import org.littleshoot.util.ResettingMultiThreadedHttpConnectionManager;
import org.littleshoot.util.Some;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MultiSourceDownloader
extends AbstractDownloader<MsDState>
implements VisitableDownloader<MsDState>,
LittleShootDownloader {
    private final Logger m_log = LoggerFactory.getLogger(MultiSourceDownloader.class);
    private static final int CONNECTION_LIMIT = 30;
    private final SourceRanker m_downloadingRanker = new SourceRankerImpl(new DownloadSpeedComparator());
    private final RateCalculator m_rateCalculator = new RateCalculatorImpl();
    private final File m_incompleteFile;
    private final URI m_uri;
    private final long m_size;
    private final UriResolver m_uriResolver;
    private final int m_connectionsPerHttpServer;
    private final RangeDownloadListener m_singleDownloadListener = new SingleDownloadListener();
    private final Collection<RangeDownloader> m_activeRangeDownloaders = Collections.synchronizedSet(new HashSet());
    private final Set<URI> m_uniqueSourceUris = Collections.synchronizedSet(new HashSet());
    private final Set<URI> m_uniqueFailedSourceUris = Collections.synchronizedSet(new HashSet());
    private final RandomAccessFile m_randomAccessFile;
    private final RangeTracker m_rangeTracker;
    private final LaunchFileTracker m_launchFileTracker;
    private volatile int m_numConnections = 0;
    private volatile MsDState m_state = MsDState.IDLE;
    private volatile boolean m_stopped = false;
    private MultiThreadedHttpConnectionManager m_connectionManager = new ResettingMultiThreadedHttpConnectionManager();
    private final CommonsHttpClient m_httpClient = new CommonsHttpClientImpl((HttpConnectionManager)this.m_connectionManager);
    private volatile boolean m_started;
    private final String m_finalName;
    private final File m_completeFile;
    private Collection<URI> m_sources = Collections.emptyList();
    private volatile boolean m_failed = false;
    private final boolean m_streamable;

    public MultiSourceDownloader(File incompleteFile, URI uri, long size, UriResolver uriResolver, int connectionsPerHost, URI expectedSha1, File downloadsDir, boolean streamable) {
        this.m_streamable = streamable;
        this.m_incompleteFile = incompleteFile;
        this.m_finalName = incompleteFile.getName();
        this.m_uri = uri;
        this.m_size = size;
        this.m_uriResolver = uriResolver;
        this.m_connectionsPerHttpServer = connectionsPerHost;
        DefaultHttpMethodRetryHandler retryHandler = new DefaultHttpMethodRetryHandler(0, false);
        this.m_httpClient.getParams().setParameter("http.method.retry-handler", (Object)retryHandler);
        HttpConnectionManagerParams params = this.m_httpClient.getHttpConnectionManager().getParams();
        params.setConnectionTimeout(50000);
        params.setSoTimeout(30000);
        params.setBooleanParameter("http.connection.stalecheck", false);
        params.setBooleanParameter("http.protocol.warn-extra-input", true);
        try {
            this.m_randomAccessFile = new RandomAccessFile(incompleteFile, "rw");
        }
        catch (FileNotFoundException e) {
            this.m_log.error("Could not create file: " + incompleteFile, (Throwable)e);
            throw new IllegalArgumentException("Cannot create file: " + incompleteFile);
        }
        this.m_completeFile = new File(downloadsDir, this.m_finalName);
        this.m_log.debug("Resolving download sources...");
        this.setState(MsDState.GETTING_SOURCES);
        try {
            this.m_sources = this.m_uriResolver.resolve(this.m_uri);
            if (this.m_sources.isEmpty()) {
                this.setState(MsDState.NO_SOURCES_AVAILABLE);
            }
        }
        catch (IOException e) {
            this.m_log.warn("Could not access sources for download", (Throwable)e);
            this.m_sources = Collections.emptyList();
            this.setState(MsDState.COULD_NOT_DETERMINE_SOURCES);
        }
        if (this.m_sources.isEmpty()) {
            this.m_log.warn("No sources available for uri: " + this.m_uri);
            this.m_rangeTracker = new RangeTrackerAdapter();
            this.m_launchFileTracker = new LaunchFileTrackerAdapter();
            return;
        }
        URI expectedSha1ToUse = expectedSha1 == null ? expectedSha1 : this.m_uriResolver.getSha1();
        this.m_rangeTracker = new RangeTrackerImpl(size, this.m_sources.size());
        int numChunks = this.m_rangeTracker.getNumChunks();
        this.m_launchFileTracker = new LaunchFileDispatcher(incompleteFile, this.m_randomAccessFile, numChunks, expectedSha1ToUse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        if (this.m_started) {
            this.m_log.warn("Already started...");
            return;
        }
        this.m_started = true;
        try {
            this.download(this.m_sources);
        }
        catch (Throwable t) {
            this.m_log.warn("Unexpected throwable during download", t);
            this.setState(MsDState.FAILED);
            return;
        }
        finally {
            try {
                this.m_randomAccessFile.close();
            }
            catch (IOException e) {
                this.m_log.warn("Could not close file: " + this.m_randomAccessFile, (Throwable)e);
            }
        }
    }

    private void connect(Collection<URI> sources, SourceRanker downloadSpeedRanker, int connectionsPerHost) {
        this.m_log.debug("Attempting to connection to " + connectionsPerHost + " hosts..");
        int numHosts = 0;
        Preferences prefs = Preferences.userRoot();
        long id = prefs.getLong("LITTLESHOOT_ID", -1L);
        Iterator<URI> sourcesIter = sources.iterator();
        while (sourcesIter.hasNext() && numHosts < 100) {
            URI uri = sourcesIter.next();
            this.m_log.info("Creating downloader for: ", (Object)uri);
            if (id == Long.parseLong(uri.getHost())) {
                this.m_log.info("Ignoring request to download from ourselves");
                continue;
            }
            int connectionsPerHostToCreate = uri.getScheme().equals("http") ? connectionsPerHost : 1;
            for (int i = 0; i < connectionsPerHostToCreate; ++i) {
                this.m_log.debug("Creating connection...");
                SingleSourceDownloader dl = new SingleSourceDownloader(this.m_httpClient, uri, this.m_singleDownloadListener, downloadSpeedRanker, this.m_rangeTracker, this.m_launchFileTracker, this.m_randomAccessFile);
                dl.issueHeadRequest();
            }
            ++numHosts;
        }
    }

    private void download(Collection<URI> sources) {
        if (sources.isEmpty()) {
            this.setState(MsDState.NO_SOURCES_AVAILABLE);
        } else {
            this.setState(new MsDState.LittleShootDownloadingState(this.m_rateCalculator, this.getNumUniqueHosts(), this.getSize()));
            this.connect(sources, this.m_downloadingRanker, this.m_connectionsPerHttpServer);
            boolean done = false;
            while (this.m_rangeTracker.hasMoreRanges() && !this.m_stopped && !this.m_failed && !done) {
                this.m_log.debug("Accessing next source...");
                RangeDownloader dl = this.m_downloadingRanker.getBestSource();
                this.m_log.debug("Accessed source...downloading...");
                if (this.m_stopped) {
                    done = true;
                    continue;
                }
                if (this.m_failed) {
                    done = true;
                    continue;
                }
                if (!this.singleRangeDownload(dl)) continue;
                this.onDownloadComplete();
                done = true;
            }
            if (this.m_failed) {
                this.setState(MsDState.FAILED);
                this.m_log.debug("The download failed");
            } else if (this.m_stopped) {
                this.setState(MsDState.CANCELED);
                this.m_log.debug("The download was cancelled");
            }
        }
    }

    private int getNumUniqueHosts() {
        this.m_log.debug("Getting numSources: " + this.m_uniqueSourceUris.size());
        return this.m_uniqueSourceUris.size();
    }

    private void onDownloadComplete() {
        this.m_log.debug("Downloaded whole file...");
        this.m_launchFileTracker.onFileComplete();
        this.m_launchFileTracker.waitForLaunchersToComplete();
        this.m_connectionManager.shutdown();
        try {
            this.m_randomAccessFile.close();
        }
        catch (IOException e) {
            this.m_log.warn("Could not close file: " + this.m_randomAccessFile, (Throwable)e);
        }
        this.setState(MsDState.COMPLETE);
    }

    private void setState(MsDState state) {
        if (!this.m_state.equals(state)) {
            this.m_state = state;
            this.m_log.debug("Setting state to: " + state);
            this.fireStateChanged(state);
        }
    }

    private boolean singleRangeDownload(final RangeDownloader downloader) {
        Optional<LongRange> oRange = this.m_rangeTracker.getNextRange();
        OptionalVisitor<Boolean, LongRange> visitor = new OptionalVisitor<Boolean, LongRange>(){

            public Boolean visitNone(None<LongRange> none) {
                return Boolean.TRUE;
            }

            public Boolean visitSome(Some<LongRange> some) {
                LongRange range = (LongRange)some.object();
                MultiSourceDownloader.this.m_log.debug("Downloading from downloader: {}", (Object)downloader);
                downloader.download(range);
                return Boolean.FALSE;
            }
        };
        return (Boolean)oRange.accept((OptionalVisitor)visitor);
    }

    @Override
    public File getIncompleteFile() {
        return this.m_incompleteFile;
    }

    @Override
    public long getSize() {
        return this.m_size;
    }

    @Override
    public MsDState getState() {
        return this.m_state;
    }

    @Override
    public boolean isStarted() {
        return this.m_started;
    }

    @Override
    public void write(OutputStream os, boolean cancelOnStreamClose) {
        try {
            this.m_launchFileTracker.write(os, cancelOnStreamClose);
        }
        catch (IOException e) {
            if (this.m_launchFileTracker.getActiveWriteCalls() == 0 && cancelOnStreamClose) {
                this.m_log.debug("Canceling stream...");
                this.stop(false);
            }
        }
        catch (Throwable t) {
            this.m_log.error("Throwable writing file.", t);
        }
    }

    private static boolean isDownloading(MsDState state) {
        MsDState.VisitorAdapter<Boolean> visitor = new MsDState.VisitorAdapter<Boolean>(Boolean.FALSE){

            @Override
            public Boolean visitLittleShootDownloading(MsDState.LittleShootDownloading downloadingState) {
                return Boolean.TRUE;
            }
        };
        return state.accept(visitor);
    }

    private void fail() {
        this.m_failed = true;
        this.m_downloadingRanker.onFailed();
        this.setState(MsDState.FAILED);
        this.m_launchFileTracker.onFailure();
    }

    @Override
    public void stop(boolean removeFiles) {
        this.m_stopped = true;
        this.setState(MsDState.CANCELED);
        try {
            this.m_randomAccessFile.close();
        }
        catch (IOException e) {
            this.m_log.debug("Error closing file.  Already closed?", (Throwable)e);
        }
        if (removeFiles) {
            this.m_log.debug("Deleting files");
            this.m_incompleteFile.delete();
            this.m_completeFile.delete();
        }
    }

    @Override
    public void pause() {
        this.m_log.error("LittleShoot downloads don't yet support pause.");
    }

    @Override
    public void resume() {
        this.m_log.error("LittleShoot downloads don't yet support resume.");
    }

    @Override
    public String getFinalName() {
        return this.m_finalName;
    }

    @Override
    public File getCompleteFile() {
        return this.m_completeFile;
    }

    @Override
    public <T> T accept(DownloadVisitor<T> visitor) {
        return visitor.visitLittleShootDownloader(this);
    }

    @Override
    public boolean isStreamable() {
        return this.m_streamable;
    }

    public long getBytesRead() {
        return this.m_rateCalculator.getBytesRead();
    }

    private final class SingleDownloadListener
    implements RangeDownloadListener {
        private SingleDownloadListener() {
        }

        @Override
        public void onConnect(RangeDownloader downloader) {
            MultiSourceDownloader.this.m_log.debug("Connected to: " + downloader);
            if (MultiSourceDownloader.this.m_numConnections > 30) {
                MultiSourceDownloader.this.m_log.debug("We already have " + MultiSourceDownloader.this.m_numConnections + " connections.  Ignoring new host...");
            } else if (MultiSourceDownloader.this.m_numConnections >= MultiSourceDownloader.this.m_rangeTracker.getNumChunks()) {
                MultiSourceDownloader.this.m_log.debug("We already have a downloader for every chunk!!");
            } else {
                MultiSourceDownloader.this.m_uniqueSourceUris.add(downloader.getSourceUri());
                MultiSourceDownloader.this.m_numConnections++;
                if (MultiSourceDownloader.this.singleRangeDownload(downloader)) {
                    MultiSourceDownloader.this.m_log.debug("Completed download on connect...");
                }
            }
        }

        @Override
        public void onBytesRead(RangeDownloader downloader) {
            MultiSourceDownloader.this.m_rateCalculator.addData(downloader);
        }

        @Override
        public void onDownloadFinished(RangeDownloader downloader) {
            if (MultiSourceDownloader.isDownloading(MultiSourceDownloader.this.m_state)) {
                MultiSourceDownloader.this.setState(new MsDState.LittleShootDownloadingState(MultiSourceDownloader.this.m_rateCalculator, MultiSourceDownloader.this.getNumUniqueHosts(), MultiSourceDownloader.this.getSize()));
            }
        }

        @Override
        public void onDownloadStarted(RangeDownloader downloader) {
            MultiSourceDownloader.this.m_activeRangeDownloaders.add(downloader);
        }

        @Override
        public void onFail(RangeDownloader downloader) {
            MultiSourceDownloader.this.m_log.debug("Received a range failure.");
            MultiSourceDownloader.this.m_uniqueFailedSourceUris.add(downloader.getSourceUri());
            int remainingSources = MultiSourceDownloader.this.m_sources.size() - MultiSourceDownloader.this.m_uniqueFailedSourceUris.size();
            if (remainingSources == 0) {
                MultiSourceDownloader.this.fail();
            } else {
                MultiSourceDownloader.this.m_log.debug("Continuing download.  Sources remaining: {}", (Object)MultiSourceDownloader.this.m_sources.size());
            }
        }
    }
}

